/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.exoplatform.component.test.AbstractGateInTest;
import org.exoplatform.groovyscript.Position;
import org.exoplatform.groovyscript.SectionItem;
import org.exoplatform.groovyscript.SectionType;
import org.exoplatform.groovyscript.TemplateParser;
import org.exoplatform.groovyscript.TemplateSection;

public class TestTemplateParser
extends AbstractGateInTest {
    private TemplateParser parser = new TemplateParser();

    public void testEmpty() throws IOException {
        TestTemplateParser.assertEquals(Collections.emptyList(), (Object)this.parser.parse(""));
    }

    public void testText() throws IOException {
        TestTemplateParser.assertEquals(Arrays.asList(new TemplateSection(SectionType.STRING, "a")), (Object)this.parser.parse("a"));
    }

    public void testSingleEmptyScriplet() throws IOException {
        TestTemplateParser.assertEquals(Arrays.asList(new TemplateSection(SectionType.SCRIPTLET, "")), (Object)this.parser.parse("<%%>"));
    }

    public void testSingleEmptyExpression() throws IOException {
        TestTemplateParser.assertEquals(Arrays.asList(new TemplateSection(SectionType.EXPR, "")), (Object)this.parser.parse("<%=%>"));
    }

    public void testSingleScriplet() throws IOException {
        TestTemplateParser.assertEquals(Arrays.asList(new TemplateSection(SectionType.SCRIPTLET, "a")), (Object)this.parser.parse("<%a%>"));
    }

    public void testSingleExpression() throws IOException {
        TestTemplateParser.assertEquals(Arrays.asList(new TemplateSection(SectionType.EXPR, "a")), (Object)this.parser.parse("<%=a%>"));
    }

    public void testPercentScriplet() throws IOException {
        TestTemplateParser.assertEquals(Arrays.asList(new TemplateSection(SectionType.SCRIPTLET, "%")), (Object)this.parser.parse("<%%%>"));
    }

    public void testPercentExpression() throws IOException {
        TestTemplateParser.assertEquals(Arrays.asList(new TemplateSection(SectionType.EXPR, "%")), (Object)this.parser.parse("<%=%%>"));
    }

    public void testStartAngleBracketScriplet() throws IOException {
        TestTemplateParser.assertEquals(Arrays.asList(new TemplateSection(SectionType.SCRIPTLET, "<")), (Object)this.parser.parse("<%<%>"));
    }

    public void testStartAngleBracketExpression() throws IOException {
        TestTemplateParser.assertEquals(Arrays.asList(new TemplateSection(SectionType.EXPR, "<")), (Object)this.parser.parse("<%=<%>"));
    }

    public void testSimpleScript() throws IOException {
        TestTemplateParser.assertEquals(Arrays.asList(new TemplateSection(SectionType.STRING, "a"), new TemplateSection(SectionType.SCRIPTLET, "b"), new TemplateSection(SectionType.STRING, "c")), (Object)this.parser.parse("a<%b%>c"));
    }

    public void testSimpleScript2() throws IOException {
        TestTemplateParser.assertEquals(Arrays.asList(new TemplateSection(SectionType.STRING, "a"), new TemplateSection(SectionType.EXPR, "b"), new TemplateSection(SectionType.STRING, "c")), (Object)this.parser.parse("a<%=b%>c"));
    }

    public void testWindowsLineBreak() throws IOException {
    }

    public void testPosition() throws IOException {
        List sections = this.parser.parse("a\nb<%= foo %>d");
        TestTemplateParser.assertEquals((Object)new Position(1, 1), (Object)((SectionItem)((TemplateSection)sections.get(0)).getItems().get(0)).getPosition());
        TestTemplateParser.assertEquals((Object)new Position(2, 1), (Object)((SectionItem)((TemplateSection)sections.get(0)).getItems().get(1)).getPosition());
        TestTemplateParser.assertEquals((Object)new Position(1, 2), (Object)((SectionItem)((TemplateSection)sections.get(0)).getItems().get(2)).getPosition());
        TestTemplateParser.assertEquals((Object)new Position(5, 2), (Object)((SectionItem)((TemplateSection)sections.get(1)).getItems().get(0)).getPosition());
        TestTemplateParser.assertEquals((Object)new Position(12, 2), (Object)((SectionItem)((TemplateSection)sections.get(2)).getItems().get(0)).getPosition());
    }
}

