/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.groovyscript;

import java.awt.AWTError;
import java.awt.AWTException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Locale;
import org.exoplatform.commons.utils.CharsetTextEncoder;
import org.exoplatform.commons.utils.OutputStreamPrinter;
import org.exoplatform.component.test.AbstractGateInTest;
import org.exoplatform.groovyscript.GroovyTemplate;
import org.exoplatform.groovyscript.TemplateCompilationException;
import org.exoplatform.groovyscript.TemplateRuntimeException;

public class TestTemplateRendering
extends AbstractGateInTest {
    private DateFormat dateFormatFR;
    private DateFormat dateFormatEN;
    public static Object out;

    protected void setUp() throws Exception {
        super.setUp();
        this.dateFormatFR = DateFormat.getDateInstance(2, Locale.FRANCE);
        this.dateFormatEN = DateFormat.getDateInstance(2, Locale.ENGLISH);
    }

    public void testOutputStreamWriter() throws Exception {
        GroovyTemplate template = new GroovyTemplate("a<%='b'%>c<%out.print('d');%>e");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamPrinter writer = new OutputStreamPrinter(CharsetTextEncoder.getUTF8(), (OutputStream)baos);
        template.render((Writer)writer);
        writer.close();
        TestTemplateRendering.assertEquals((String)"abcde", (String)baos.toString("UTF-8"));
    }

    public void testDate1() throws Exception {
        Date dateToTest = new Date(0L);
        GroovyTemplate template = new GroovyTemplate("<% print(new Date(0)); %>");
        TestTemplateRendering.assertEquals((String)this.dateFormatFR.format(dateToTest), (String)template.render(Locale.FRENCH));
        TestTemplateRendering.assertEquals((String)this.dateFormatEN.format(dateToTest), (String)template.render(Locale.ENGLISH));
        TestTemplateRendering.assertEquals((String)dateToTest.toString(), (String)template.render());
    }

    public void testDate2() throws Exception {
        Date dateToTest = new Date(0L);
        GroovyTemplate template = new GroovyTemplate("<% def date = new Date(0) %>$date");
        TestTemplateRendering.assertEquals((String)this.dateFormatFR.format(dateToTest), (String)template.render(Locale.FRENCH));
        TestTemplateRendering.assertEquals((String)this.dateFormatEN.format(dateToTest), (String)template.render(Locale.ENGLISH));
        TestTemplateRendering.assertEquals((String)dateToTest.toString(), (String)template.render());
    }

    public void testDate3() throws Exception {
        Date dateToTest = new Date(0L);
        GroovyTemplate template = new GroovyTemplate("<%= new Date(0) %>");
        TestTemplateRendering.assertEquals((String)this.dateFormatFR.format(dateToTest), (String)template.render(Locale.FRENCH));
        TestTemplateRendering.assertEquals((String)this.dateFormatEN.format(dateToTest), (String)template.render(Locale.ENGLISH));
        TestTemplateRendering.assertEquals((String)dateToTest.toString(), (String)template.render());
    }

    public void testFoo() throws Exception {
        GroovyTemplate template = new GroovyTemplate("a");
        String render = template.render();
        TestTemplateRendering.assertEquals((String)"a", (String)render);
    }

    public void testBar() throws Exception {
        GroovyTemplate template = new GroovyTemplate("<%='a'%>");
        String render = template.render();
        TestTemplateRendering.assertEquals((String)"a", (String)render);
    }

    public void testFooBar() throws Exception {
        GroovyTemplate template = new GroovyTemplate("a<%='b'%>c");
        String render = template.render();
        TestTemplateRendering.assertEquals((String)"abc", (String)render);
    }

    public void testJuu() throws Exception {
        GroovyTemplate template = new GroovyTemplate("<% out.print(\"a\"); %>");
        String render = template.render();
        TestTemplateRendering.assertEquals((String)"a", (String)render);
    }

    public void testLineBreak() throws Exception {
        GroovyTemplate template = new GroovyTemplate("\n");
        String render = template.render();
        TestTemplateRendering.assertEquals((String)"\n", (String)render);
    }

    public void testMultiLine() throws Exception {
        GroovyTemplate template = new GroovyTemplate("a\nb\n<%= 'c' %>\nd");
        String render = template.render();
        TestTemplateRendering.assertEquals((String)"a\nb\nc\nd", (String)render);
    }

    public void testIf() throws Exception {
        GroovyTemplate template = new GroovyTemplate("a\n<% if (true) {\n %>b\n<% } %>");
        String s = template.render();
        TestTemplateRendering.assertEquals((String)"a\nb\n", (String)s);
    }

    public void testLineComment() throws Exception {
        GroovyTemplate template = new GroovyTemplate("<% // foo %>a\nb");
        String s = template.render();
        TestTemplateRendering.assertEquals((String)"a\nb", (String)s);
    }

    public void testContextResolution() throws Exception {
        GroovyTemplate template = new GroovyTemplate("<%= foo %>");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("foo", "bar");
        String s = template.render(context);
        TestTemplateRendering.assertEquals((String)"bar", (String)s);
    }

    public void testGString() throws Exception {
        GroovyTemplate template = new GroovyTemplate("$foo");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("foo", "bar");
        String s = template.render(context);
        TestTemplateRendering.assertEquals((String)"bar", (String)s);
    }

    public void testQuoteAfterGString() throws Exception {
        GroovyTemplate template = new GroovyTemplate("$foo\"");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("foo", "bar");
        String s = template.render(context);
        TestTemplateRendering.assertEquals((String)"bar\"", (String)s);
    }

    public void testDollarInExpression() throws Exception {
        GroovyTemplate template = new GroovyTemplate("<%= \"$foo\" %>");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("foo", "bar");
        String s = template.render(context);
        TestTemplateRendering.assertEquals((String)"bar", (String)s);
    }

    public void testEscapeDollarInExpression() throws Exception {
        GroovyTemplate template = new GroovyTemplate("<%= \"\\$foo\" %>");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("foo", "bar");
        String s = template.render(context);
        TestTemplateRendering.assertEquals((String)"$foo", (String)s);
    }

    public void testEscapeDollarInText() throws Exception {
        GroovyTemplate template = new GroovyTemplate("\\$foo");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("foo", "bar");
        String s = template.render(context);
        TestTemplateRendering.assertEquals((String)"$foo", (String)s);
    }

    public void testDollarInScriplet() throws Exception {
        GroovyTemplate template = new GroovyTemplate("<% out.print(\"$foo\") %>");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("foo", "bar");
        String s = template.render(context);
        TestTemplateRendering.assertEquals((String)"bar", (String)s);
    }

    public void testEscapeDollarInScriplet() throws Exception {
        GroovyTemplate template = new GroovyTemplate("<% out.print(\"\\$foo\") %>");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("foo", "bar");
        String s = template.render(context);
        TestTemplateRendering.assertEquals((String)"$foo", (String)s);
    }

    public void testQuote() throws Exception {
        GroovyTemplate template = new GroovyTemplate("\"");
        String s = template.render();
        TestTemplateRendering.assertEquals((String)"\"", (String)s);
    }

    public void testFooFoo() throws Exception {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("UIPortalApplication.gtmpl");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[256];
        int l = in.read(buffer);
        while (l != -1) {
            baos.write(buffer, 0, l);
            l = in.read(buffer);
        }
        String gtmpl = baos.toString("UTF-8");
        GroovyTemplate template = new GroovyTemplate(gtmpl);
    }

    public void testException() throws Exception {
        GroovyTemplate template = new GroovyTemplate("<% throw new java.awt.AWTException(); %>");
        try {
            template.render();
            TestTemplateRendering.fail();
        }
        catch (TemplateRuntimeException e) {
            TestTemplateRendering.assertTrue((boolean)(e.getCause() instanceof AWTException));
        }
    }

    public void testRuntimeException() throws Exception {
        GroovyTemplate template = new GroovyTemplate("<% throw new java.util.EmptyStackException(); %>");
        try {
            template.render();
            TestTemplateRendering.fail();
        }
        catch (TemplateRuntimeException e) {
            TestTemplateRendering.assertTrue((boolean)(e.getCause() instanceof EmptyStackException));
        }
    }

    public void testIOException() throws Exception {
        GroovyTemplate template = new GroovyTemplate("<% throw new java.io.IOException(); %>");
        try {
            template.render();
            TestTemplateRendering.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testError() throws Exception {
        GroovyTemplate template = new GroovyTemplate("<% throw new java.awt.AWTError(); %>");
        try {
            template.render();
            TestTemplateRendering.fail();
        }
        catch (AWTError aWTError) {
            // empty catch block
        }
    }

    public void testThrowable() throws Exception {
        GroovyTemplate template = new GroovyTemplate("<% throw new Throwable(); %>");
        try {
            template.render();
            TestTemplateRendering.fail();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testScriptLineNumber() throws Exception {
        this.testLineNumber("<%");
        this.assertLineNumber(2, "throw new Exception('e')", "<%\nthrow new Exception('e')%>");
    }

    public void testExpressionLineNumber() throws Exception {
        this.testLineNumber("<%=");
    }

    private void testLineNumber(String prolog) throws Exception {
        this.assertLineNumber(1, "throw new Exception('a')", prolog + "throw new Exception('a')%>");
        this.assertLineNumber(1, "throw new Exception('b')", "foo" + prolog + "throw new Exception('b')%>");
        this.assertLineNumber(2, "throw new Exception('c')", "foo\n" + prolog + "throw new Exception('c')%>");
        this.assertLineNumber(1, "throw new Exception('d')", "<%;%>foo" + prolog + "throw new Exception('d')%>");
    }

    public void testWriterAccess() throws Exception {
        out = null;
        StringWriter writer = new StringWriter();
        GroovyTemplate template = new GroovyTemplate("<% " + TestTemplateRendering.class.getName() + ".out = out; %>");
        template.render((Writer)writer);
        TestTemplateRendering.assertNotNull((Object)out);
    }

    private void assertLineNumber(int expectedLineNumber, String expectedText, String script) throws TemplateCompilationException, IOException {
        GroovyTemplate template = new GroovyTemplate(script);
        try {
            template.render();
            TestTemplateRendering.fail();
        }
        catch (TemplateRuntimeException t) {
            TestTemplateRendering.assertEquals((String)expectedText, (String)t.getText());
            TestTemplateRendering.assertEquals((Object)expectedLineNumber, (Object)t.getLineNumber());
            StackTraceElement scriptElt = null;
            for (StackTraceElement elt : t.getCause().getStackTrace()) {
                if (!elt.getClassName().equals(template.getClassName())) continue;
                scriptElt = elt;
                break;
            }
            TestTemplateRendering.assertEquals((int)expectedLineNumber, (int)scriptElt.getLineNumber());
        }
    }
}

