/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.component.test.web;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import junit.framework.TestCase;
import org.exoplatform.component.test.web.ServletContextImpl;
import org.gatein.common.io.IOTools;

public class ServletContextTestCase {
    public void testFileGetResource() throws Exception {
        URL url = ServletContextTestCase.class.getClassLoader().getResource("org/exoplatform/component/test/web/");
        TestCase.assertNotNull((Object)url);
        File root = new File(url.toURI());
        TestCase.assertTrue((boolean)root.exists());
        TestCase.assertTrue((boolean)root.isDirectory());
        ServletContextImpl servletContext = new ServletContextImpl(root, "/webapp", "webapp");
        URL fooURL = servletContext.getResource("/foo.txt");
        TestCase.assertNotNull((Object)fooURL);
        TestCase.assertEquals((String)"foo", (String)new String(IOTools.getBytes((InputStream)fooURL.openStream())));
        URL barURL = servletContext.getResource("/folder/bar.txt");
        TestCase.assertNotNull((Object)barURL);
        TestCase.assertEquals((String)"bar", (String)new String(IOTools.getBytes((InputStream)barURL.openStream())));
        TestCase.assertEquals(null, (Object)servletContext.getResource("/bar.txt"));
    }

    public void testClassGetResource() throws Exception {
        ServletContextImpl servletContext = new ServletContextImpl(this.getClass(), "/webapp", "webapp");
        URL fooURL = servletContext.getResource("/foo.txt");
        TestCase.assertNotNull((Object)fooURL);
        TestCase.assertEquals((String)"foo", (String)new String(IOTools.getBytes((InputStream)fooURL.openStream())));
        URL barURL = servletContext.getResource("/folder/bar.txt");
        TestCase.assertNotNull((Object)barURL);
        TestCase.assertEquals((String)"bar", (String)new String(IOTools.getBytes((InputStream)barURL.openStream())));
        TestCase.assertEquals(null, (Object)servletContext.getResource("/bar.txt"));
    }

    public void testContextPath() {
        ServletContextImpl servletContext = new ServletContextImpl(this.getClass(), "/webapp", "webapp");
        TestCase.assertEquals((String)"/webapp", (String)servletContext.getContextPath());
    }
}

