/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.util.Collections;
import java.util.HashMap;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.metadata.ParamDescriptor;
import org.exoplatform.web.controller.metadata.RouteDescriptor;
import org.exoplatform.web.controller.router.AbstractTestController;
import org.exoplatform.web.controller.router.Names;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.controller.router.URIHelper;

public class TestPortal
extends AbstractTestController {
    public static final String LANG_PATTERN = "([A-Za-z]{2}(-[A-Za-z]{2})?)?";

    public void testLanguage1() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/public/{gtn:lang}").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:lang").matchedBy(LANG_PATTERN).preservePath()})}).build();
        TestPortal.assertEquals(Collections.singletonMap(Names.GTN_LANG, ""), router.route("/public"));
        TestPortal.assertEquals(Collections.singletonMap(Names.GTN_LANG, "fr"), router.route("/public/fr"));
        TestPortal.assertEquals(Collections.singletonMap(Names.GTN_LANG, "fr-FR"), router.route("/public/fr-FR"));
    }

    public void testLanguage2() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{gtn:lang}/public").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:lang").matchedBy(LANG_PATTERN)})}).build();
        TestPortal.assertEquals(Collections.singletonMap(Names.GTN_LANG, ""), router.route("/public"));
        TestPortal.assertNull((Object)router.route("/f/public"));
        TestPortal.assertEquals(Collections.singletonMap(Names.GTN_LANG, "fr"), router.route("/fr/public"));
        TestPortal.assertEquals((String)"/public", (String)router.render(Collections.singletonMap(Names.GTN_LANG, "")));
        TestPortal.assertEquals((String)"", (String)router.render(Collections.singletonMap(Names.GTN_LANG, "f")));
        TestPortal.assertEquals((String)"/fr/public", (String)router.render(Collections.singletonMap(Names.GTN_LANG, "fr")));
        TestPortal.assertEquals((String)"/fr-FR/public", (String)router.render(Collections.singletonMap(Names.GTN_LANG, "fr-FR")));
    }

    public void testLanguage3() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/public/{gtn:lang}/{gtn:sitename}{gtn:path}").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:lang").matchedBy(LANG_PATTERN).preservePath()}).with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:path").matchedBy(".*").preservePath()})}).build();
        HashMap<QualifiedName, String> expectedParameters = new HashMap<QualifiedName, String>();
        expectedParameters.put(Names.GTN_LANG, "fr");
        expectedParameters.put(Names.GTN_SITENAME, "classic");
        expectedParameters.put(Names.GTN_PATH, "/home");
        TestPortal.assertEquals(expectedParameters, router.route("/public/fr/classic/home"));
        expectedParameters.put(Names.GTN_PATH, "");
        TestPortal.assertEquals(expectedParameters, router.route("/public/fr/classic"));
        expectedParameters.put(Names.GTN_LANG, "");
        expectedParameters.put(Names.GTN_PATH, "/home");
        TestPortal.assertEquals(expectedParameters, router.route("/public/classic/home"));
    }

    public void testDuplicateRouteWithDifferentRouteParam() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"foo").withValue("foo_1")}).with(new ParamDescriptor[]{DescriptorBuilder.requestParam((String)"bar").named("bar").matchedByLiteral("bar_value")}), DescriptorBuilder.route((String)"/").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"foo").withValue("foo_2")})}).build();
        HashMap<Object, String> expected = new HashMap<QualifiedName, String>();
        expected.put(Names.FOO, "foo_1");
        expected.put(Names.BAR, "bar_value");
        TestPortal.assertEquals(expected, router.route("/", Collections.singletonMap("bar", new String[]{"bar_value"})));
        URIHelper rc = new URIHelper();
        router.render(expected, rc.writer);
        TestPortal.assertEquals((String)"/", (String)rc.getPath());
        TestPortal.assertMapEquals(Collections.singletonMap("bar", new String[]{"bar_value"}), rc.getQueryParams());
        expected = new HashMap();
        expected.put(Names.FOO, "foo_2");
        TestPortal.assertEquals(expected, router.route("/", Collections.singletonMap("bar", new String[]{"flabbergast"})));
        rc = new URIHelper();
        router.render(expected, rc.writer);
        TestPortal.assertEquals((String)"/", (String)rc.getPath());
        TestPortal.assertEquals(null, rc.getQueryParams());
    }

    public void testJSMin() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/foo{gtn:min}.js").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:min").matchedBy("-(min)|").captureGroup(true)})}).build();
        TestPortal.assertEquals(Collections.singletonMap(Names.GTN_MIN, "min"), router.route("/foo-min.js"));
        TestPortal.assertEquals(Collections.singletonMap(Names.GTN_MIN, ""), router.route("/foo.js"));
        TestPortal.assertNull((Object)router.route("/foo-max.js"));
        TestPortal.assertEquals((String)"/foo-min.js", (String)router.render(Collections.singletonMap(Names.GTN_MIN, "min")));
        TestPortal.assertEquals((String)"/foo.js", (String)router.render(Collections.singletonMap(Names.GTN_MIN, "")));
        TestPortal.assertEquals((String)"", (String)router.render(Collections.singletonMap(Names.GTN_MIN, "max")));
    }
}

