/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.web.controller.regexp.RENode;
import org.exoplatform.web.controller.regexp.REParser;
import org.exoplatform.web.controller.router.ValueResolverFactory;

public class TestFooRenderer
extends TestCase {
    private static void assertSatisfied(String expression, String ... expected) throws Exception {
        RENode root = new REParser((CharSequence)expression).parse();
        List alternatives = new ValueResolverFactory().foo(root);
        TestFooRenderer.assertEquals((int)expected.length, (int)alternatives.size());
        for (int i = 0; i < expected.length; ++i) {
            TestFooRenderer.assertEquals((String)expected[i], (String)((ValueResolverFactory.Alternative)alternatives.get(i)).getResolvingExpression().toString());
        }
    }

    public void testDisjunction() throws Exception {
        TestFooRenderer.assertSatisfied("a|b", "a", "b");
    }

    public void testAlternative() throws Exception {
        TestFooRenderer.assertSatisfied("ab", "ab");
    }

    public void testCharacterClassRange() throws Exception {
        TestFooRenderer.assertSatisfied("[b-c]", "b");
    }

    public void testCharacterClassOr() throws Exception {
        TestFooRenderer.assertSatisfied("[bc]", "b");
    }

    public void testCharacterClassAnd() throws Exception {
        TestFooRenderer.assertSatisfied("[b&&b]", "b");
    }

    public void testQuantifier() throws Exception {
        TestFooRenderer.assertSatisfied("b{2,3}", "bb");
    }

    public void testCharacterClassNegateChar() throws Exception {
        TestFooRenderer.assertSatisfied("[^a]", " ");
    }

    public void testCharacterClassNegateOr() throws Exception {
        TestFooRenderer.assertSatisfied("[^ !]", "\"");
    }

    public void testCharacterClassNegateAnd() throws Exception {
        TestFooRenderer.assertSatisfied("[^a&&b]", " ");
    }

    public void testAny() throws Exception {
        TestFooRenderer.assertSatisfied(".", "a");
    }

    public void testNonCapturingGroup() throws Exception {
        TestFooRenderer.assertSatisfied("(?:a|b)", "a");
    }

    public void testGroup() throws Exception {
        TestFooRenderer.assertSatisfied("(a|b)", "(a|b)");
    }

    public void testComplex() throws Exception {
        TestFooRenderer.assertSatisfied("[a-z&&f-t&&p-q]", "p");
    }
}

