/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;

public class DownloadHandler
extends WebRequestHandler {
    private final Log log = ExoLogger.getLogger(DownloadHandler.class);

    @Override
    public String getHandlerName() {
        return "download";
    }

    @Override
    public boolean execute(ControllerContext context) throws Exception {
        this.execute(context.getRequest(), context.getResponse());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String resourceId = req.getParameter("resourceId");
        boolean remove = !"false".equals(req.getParameter("remove"));
        res.setHeader("Cache-Control", "private max-age=600, s-maxage=120");
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        DownloadService dservice = (DownloadService)container.getComponentInstanceOfType(DownloadService.class);
        DownloadResource dresource = dservice.getDownloadResource(resourceId, remove);
        if (dresource == null) {
            res.setContentType("text/plain");
            res.getWriter().write("NO DOWNDLOAD RESOURCE CONTENT  OR YOU DO NOT HAVE THE RIGHT TO ACCESS THE CONTENT");
            return;
        }
        String userAgent = req.getHeader("User-Agent");
        if (dresource.getDownloadName() != null) {
            if (userAgent != null && userAgent.contains("Firefox")) {
                res.setHeader("Content-Disposition", "attachment; filename*=utf-8''" + URLEncoder.encode(dresource.getDownloadName(), "UTF-8").replace("+", "%20"));
            } else {
                res.setHeader("Content-Disposition", "attachment;filename=\"" + URLEncoder.encode(dresource.getDownloadName(), "UTF-8").replace("+", "%20") + "\"");
            }
        }
        res.setContentType(dresource.getResourceMimeType());
        try (InputStream is = dresource.getInputStream();){
            DownloadHandler.optimalRead(is, (OutputStream)res.getOutputStream());
        }
    }

    @Override
    protected boolean getRequiresLifeCycle() {
        return false;
    }

    private static void optimalRead(InputStream is, OutputStream os) throws Exception {
        int bufferLength = 1024;
        int readLength = 0;
        while (readLength > -1) {
            byte[] chunk = new byte[bufferLength];
            readLength = is.read(chunk);
            if (readLength <= 0) continue;
            os.write(chunk, 0, readLength);
        }
    }
}

