/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.regexp;

import java.io.IOException;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.exoplatform.web.controller.regexp.RENode;
import org.exoplatform.web.controller.regexp.REParser;
import org.exoplatform.web.controller.regexp.RERenderer;
import org.exoplatform.web.controller.regexp.SyntaxException;

public class TestRegExpRenderer
extends TestCase {
    static void assertRender(RENode re, String expected) {
        try {
            String rendered = re != null ? ((StringBuilder)RERenderer.render((RENode)re, (Appendable)new StringBuilder())).toString() : "";
            TestRegExpRenderer.assertEquals((String)expected, (String)rendered);
        }
        catch (IOException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
    }

    static RENode.Disjunction disjunction(String regexp) {
        try {
            REParser parser = new REParser((CharSequence)regexp);
            RENode.Disjunction re = parser.parseDisjunction();
            TestRegExpRenderer.assertTrue((boolean)parser.isDone());
            return re;
        }
        catch (SyntaxException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
    }

    static RENode.Alternative alternative(String regexp) {
        try {
            REParser parser = new REParser((CharSequence)regexp);
            RENode.Alternative re = parser.parseAlternative();
            TestRegExpRenderer.assertTrue((boolean)parser.isDone());
            return re;
        }
        catch (SyntaxException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
    }

    static RENode.Expr expression(String regexp) {
        try {
            REParser parser = new REParser((CharSequence)regexp);
            RENode.Expr re = parser.parseExpression();
            TestRegExpRenderer.assertTrue((boolean)parser.isDone());
            return re;
        }
        catch (SyntaxException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
    }

    static RENode.CharacterClass characterClass(String regexp) {
        try {
            REParser parser = new REParser((CharSequence)regexp);
            RENode.CharacterClass re = parser.parseCharacterClass();
            TestRegExpRenderer.assertTrue((boolean)parser.isDone());
            return re;
        }
        catch (SyntaxException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
    }

    public void testSimple() {
        TestRegExpRenderer.assertRender((RENode)TestRegExpRenderer.expression("."), ".");
        TestRegExpRenderer.assertRender((RENode)TestRegExpRenderer.expression("^"), "^");
        TestRegExpRenderer.assertRender((RENode)TestRegExpRenderer.expression("\\."), "\\.");
    }

    public void testDisjunction() {
        TestRegExpRenderer.assertRender((RENode)TestRegExpRenderer.disjunction(""), "");
        TestRegExpRenderer.assertRender((RENode)TestRegExpRenderer.disjunction("|"), "|");
        TestRegExpRenderer.assertRender((RENode)TestRegExpRenderer.disjunction("a|"), "a|");
        TestRegExpRenderer.assertRender((RENode)TestRegExpRenderer.disjunction("|a"), "|a");
        TestRegExpRenderer.assertRender((RENode)TestRegExpRenderer.disjunction("a|b"), "a|b");
    }

    public void testAlternative() {
        TestRegExpRenderer.assertRender((RENode)TestRegExpRenderer.alternative(""), "");
        TestRegExpRenderer.assertRender((RENode)TestRegExpRenderer.alternative("ab"), "ab");
        TestRegExpRenderer.assertRender((RENode)TestRegExpRenderer.alternative("abc"), "abc");
    }

    public void testCharacterClass() {
        TestRegExpRenderer.assertRender((RENode)TestRegExpRenderer.characterClass(""), "");
        TestRegExpRenderer.assertRender((RENode)TestRegExpRenderer.characterClass("[a]"), "[a]");
        TestRegExpRenderer.assertRender((RENode)TestRegExpRenderer.characterClass("[ab]"), "[ab]");
        TestRegExpRenderer.assertRender((RENode)TestRegExpRenderer.characterClass("[.\\]]"), "[\\.\\]]");
    }
}

