/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.exoplatform.web.controller.router.URIWriter;
import org.exoplatform.web.url.MimeType;

public class URIHelper
implements Appendable {
    private StringBuilder sb;
    final URIWriter writer;

    public URIHelper() {
        this(new StringBuilder());
    }

    public URIHelper(StringBuilder sb) {
        this.sb = sb;
        this.writer = new URIWriter((Appendable)this, MimeType.PLAIN);
    }

    public String getPath() {
        if (this.sb != null) {
            int index = this.sb.indexOf("?");
            if (index != -1) {
                return this.sb.substring(0, index);
            }
            return this.sb.toString();
        }
        return null;
    }

    public Map<String, String[]> getQueryParams() {
        int index;
        if (this.sb != null && (index = this.sb.indexOf("?")) != -1) {
            String query = this.sb.substring(index + 1);
            return Arrays.stream(query.split("&")).collect(Collectors.toMap(s -> s.split("=")[0], s -> {
                String[] stringArray;
                if (s.split("=").length > 1) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = s.split("=")[1];
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "";
                }
                return stringArray;
            }));
        }
        return null;
    }

    public void reset() {
        if (this.sb != null) {
            this.sb.setLength(0);
        }
        this.writer.reset((Appendable)this.sb);
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        this.sb.append(csq);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        this.sb.append(csq, start, end);
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.sb.append(c);
        return this;
    }
}

