/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import junit.framework.TestCase;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.metadata.ControllerDescriptor;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.metadata.PathParamDescriptor;
import org.exoplatform.web.controller.metadata.RouteDescriptor;
import org.exoplatform.web.controller.router.ControlMode;
import org.exoplatform.web.controller.router.EncodingMode;
import org.exoplatform.web.controller.router.Names;
import org.exoplatform.web.controller.router.ValueType;

public class TestDescriptorBuilder
extends TestCase {
    public void testFoo() throws Exception {
        URL routerURL = TestDescriptorBuilder.class.getClassLoader().getResource("router.xml");
        XMLStreamReader routerReader = XMLInputFactory.newInstance().createXMLStreamReader(routerURL.openStream());
        ControllerDescriptor routerDesc = new DescriptorBuilder().build(routerReader);
        TestDescriptorBuilder.assertEquals((char)'&', (char)routerDesc.getSeparatorEscape());
        Iterator i = routerDesc.getRoutes().iterator();
        TestDescriptorBuilder.assertTrue((boolean)i.hasNext());
        RouteDescriptor route1 = (RouteDescriptor)i.next();
        TestDescriptorBuilder.assertEquals((String)"/public/{gtn:sitetype}/{gtn:sitename}{gtn:path}", (String)route1.getPath());
        TestDescriptorBuilder.assertEquals(Collections.singleton(WebAppController.HANDLER_PARAM), (Object)route1.getRouteParamNames());
        TestDescriptorBuilder.assertEquals((Object)WebAppController.HANDLER_PARAM, (Object)route1.getRouteParam(WebAppController.HANDLER_PARAM).getQualifiedName());
        TestDescriptorBuilder.assertEquals((String)"portal", (String)route1.getRouteParam(WebAppController.HANDLER_PARAM).getValue());
        TestDescriptorBuilder.assertEquals(Collections.singleton(Names.GTN_PATH), route1.getPathParams().keySet());
        TestDescriptorBuilder.assertEquals((Object)Names.GTN_PATH, (Object)((PathParamDescriptor)route1.getPathParams().get(Names.GTN_PATH)).getQualifiedName());
        TestDescriptorBuilder.assertEquals((String)".*", (String)((PathParamDescriptor)route1.getPathParams().get(Names.GTN_PATH)).getPattern());
        TestDescriptorBuilder.assertEquals((Object)EncodingMode.FORM, (Object)((PathParamDescriptor)route1.getPathParams().get(Names.GTN_PATH)).getEncodingMode());
        TestDescriptorBuilder.assertTrue((boolean)i.hasNext());
        RouteDescriptor route2 = (RouteDescriptor)i.next();
        TestDescriptorBuilder.assertEquals((String)"/private/{gtn:sitetype}/{gtn:sitename}{gtn:path}", (String)route2.getPath());
        TestDescriptorBuilder.assertEquals(Collections.singleton(WebAppController.HANDLER_PARAM), (Object)route2.getRouteParamNames());
        TestDescriptorBuilder.assertEquals((Object)WebAppController.HANDLER_PARAM, (Object)route2.getRouteParam(WebAppController.HANDLER_PARAM).getQualifiedName());
        TestDescriptorBuilder.assertEquals((String)"portal", (String)route2.getRouteParam(WebAppController.HANDLER_PARAM).getValue());
        TestDescriptorBuilder.assertEquals(Collections.singleton(Names.GTN_PATH), route2.getPathParams().keySet());
        TestDescriptorBuilder.assertEquals((Object)Names.GTN_PATH, (Object)((PathParamDescriptor)route2.getPathParams().get(Names.GTN_PATH)).getQualifiedName());
        TestDescriptorBuilder.assertEquals((String)".*", (String)((PathParamDescriptor)route2.getPathParams().get(Names.GTN_PATH)).getPattern());
        TestDescriptorBuilder.assertEquals((Object)EncodingMode.PRESERVE_PATH, (Object)((PathParamDescriptor)route2.getPathParams().get(Names.GTN_PATH)).getEncodingMode());
        TestDescriptorBuilder.assertTrue((boolean)i.hasNext());
        RouteDescriptor route3 = (RouteDescriptor)i.next();
        TestDescriptorBuilder.assertEquals((String)"/upload", (String)route3.getPath());
        TestDescriptorBuilder.assertEquals(Collections.singleton(WebAppController.HANDLER_PARAM), (Object)route3.getRouteParamNames());
        TestDescriptorBuilder.assertEquals((Object)WebAppController.HANDLER_PARAM, (Object)route3.getRouteParam(WebAppController.HANDLER_PARAM).getQualifiedName());
        TestDescriptorBuilder.assertEquals((String)"upload", (String)route3.getRouteParam(WebAppController.HANDLER_PARAM).getValue());
        TestDescriptorBuilder.assertTrue((boolean)i.hasNext());
        RouteDescriptor route4 = (RouteDescriptor)i.next();
        TestDescriptorBuilder.assertEquals((String)"/download", (String)route4.getPath());
        TestDescriptorBuilder.assertEquals(Collections.singleton(WebAppController.HANDLER_PARAM), (Object)route4.getRouteParamNames());
        TestDescriptorBuilder.assertEquals((Object)WebAppController.HANDLER_PARAM, (Object)route4.getRouteParam(WebAppController.HANDLER_PARAM).getQualifiedName());
        TestDescriptorBuilder.assertEquals((String)"download", (String)route4.getRouteParam(WebAppController.HANDLER_PARAM).getValue());
        TestDescriptorBuilder.assertTrue((boolean)i.hasNext());
        RouteDescriptor route5 = (RouteDescriptor)i.next();
        TestDescriptorBuilder.assertEquals((String)"/a", (String)route5.getPath());
        TestDescriptorBuilder.assertEquals(Collections.singleton(Names.A), (Object)route5.getRouteParamNames());
        TestDescriptorBuilder.assertEquals((Object)Names.A, (Object)route5.getRouteParam(Names.A).getQualifiedName());
        TestDescriptorBuilder.assertEquals((String)"a_value", (String)route5.getRouteParam(Names.A).getValue());
        TestDescriptorBuilder.assertEquals((int)1, (int)route5.getChildren().size());
        RouteDescriptor route5_1 = (RouteDescriptor)route5.getChildren().get(0);
        TestDescriptorBuilder.assertEquals((String)"/b", (String)route5_1.getPath());
        TestDescriptorBuilder.assertEquals(Collections.singleton(Names.B), (Object)route5_1.getRouteParamNames());
        TestDescriptorBuilder.assertEquals((Object)Names.B, (Object)route5_1.getRouteParam(Names.B).getQualifiedName());
        TestDescriptorBuilder.assertEquals((String)"b_value", (String)route5_1.getRouteParam(Names.B).getValue());
        TestDescriptorBuilder.assertTrue((boolean)i.hasNext());
        RouteDescriptor route6 = (RouteDescriptor)i.next();
        TestDescriptorBuilder.assertEquals((String)"/b", (String)route6.getPath());
        TestDescriptorBuilder.assertEquals(new HashSet<String>(Arrays.asList("foo", "bar", "juu")), (Object)route6.getRequestParamMatchNames());
        TestDescriptorBuilder.assertEquals((Object)Names.FOO, (Object)route6.getRequestParam("foo").getQualifiedName());
        TestDescriptorBuilder.assertEquals((String)"foo", (String)route6.getRequestParam("foo").getName());
        TestDescriptorBuilder.assertEquals(null, (String)route6.getRequestParam("foo").getValue());
        TestDescriptorBuilder.assertEquals((Object)ValueType.LITERAL, (Object)route6.getRequestParam("foo").getValueType());
        TestDescriptorBuilder.assertEquals((Object)ControlMode.OPTIONAL, (Object)route6.getRequestParam("foo").getControlMode());
        TestDescriptorBuilder.assertEquals((Object)Names.BAR, (Object)route6.getRequestParam("bar").getQualifiedName());
        TestDescriptorBuilder.assertEquals((String)"bar", (String)route6.getRequestParam("bar").getName());
        TestDescriptorBuilder.assertEquals((String)"bar", (String)route6.getRequestParam("bar").getValue());
        TestDescriptorBuilder.assertEquals((Object)ValueType.LITERAL, (Object)route6.getRequestParam("bar").getValueType());
        TestDescriptorBuilder.assertEquals((Object)ControlMode.OPTIONAL, (Object)route6.getRequestParam("bar").getControlMode());
        TestDescriptorBuilder.assertEquals((Object)Names.JUU, (Object)route6.getRequestParam("juu").getQualifiedName());
        TestDescriptorBuilder.assertEquals((String)"juu", (String)route6.getRequestParam("juu").getName());
        TestDescriptorBuilder.assertEquals((String)"juu", (String)route6.getRequestParam("juu").getValue());
        TestDescriptorBuilder.assertEquals((Object)ValueType.PATTERN, (Object)route6.getRequestParam("juu").getValueType());
        TestDescriptorBuilder.assertEquals((Object)ControlMode.REQUIRED, (Object)route6.getRequestParam("juu").getControlMode());
        TestDescriptorBuilder.assertFalse((boolean)i.hasNext());
    }
}

