/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.util.HashMap;
import junit.framework.TestCase;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.metadata.ParamDescriptor;
import org.exoplatform.web.controller.metadata.RouteDescriptor;
import org.exoplatform.web.controller.router.Names;
import org.exoplatform.web.controller.router.Router;

public class TestLegacyPortal
extends TestCase {
    private Router router;

    protected void setUp() throws Exception {
        this.router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"gtn:handler").withValue("portal")}).sub(DescriptorBuilder.route((String)"/public/{gtn:sitename}{gtn:path}").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"gtn:access").withValue("public"), DescriptorBuilder.pathParam((String)"gtn:path").matchedBy(".*").preservePath()})).sub(DescriptorBuilder.route((String)"/private/{gtn:sitename}{gtn:path}").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"gtn:access").withValue("private"), DescriptorBuilder.pathParam((String)"gtn:path").matchedBy(".*").preservePath()}))}).build();
    }

    public void testPrivateClassicComponent() throws Exception {
        HashMap<QualifiedName, String> expectedParameters = new HashMap<QualifiedName, String>();
        expectedParameters.put(Names.GTN_HANDLER, "portal");
        expectedParameters.put(Names.GTN_SITENAME, "classic");
        expectedParameters.put(Names.GTN_ACCESS, "private");
        expectedParameters.put(Names.GTN_PATH, "");
        TestLegacyPortal.assertEquals(expectedParameters, (Object)this.router.route("/private/classic"));
        TestLegacyPortal.assertEquals((String)"/private/classic", (String)this.router.render(expectedParameters));
    }

    public void testPrivateClassic() throws Exception {
        HashMap<QualifiedName, String> expectedParameters = new HashMap<QualifiedName, String>();
        expectedParameters.put(Names.GTN_HANDLER, "portal");
        expectedParameters.put(Names.GTN_SITENAME, "classic");
        expectedParameters.put(Names.GTN_ACCESS, "private");
        expectedParameters.put(Names.GTN_PATH, "");
        TestLegacyPortal.assertEquals(expectedParameters, (Object)this.router.route("/private/classic"));
        TestLegacyPortal.assertEquals((String)"/private/classic", (String)this.router.render(expectedParameters));
    }

    public void testPrivateClassicSlash() throws Exception {
        HashMap<QualifiedName, String> expectedParameters = new HashMap<QualifiedName, String>();
        expectedParameters.put(Names.GTN_HANDLER, "portal");
        expectedParameters.put(Names.GTN_SITENAME, "classic");
        expectedParameters.put(Names.GTN_ACCESS, "private");
        expectedParameters.put(Names.GTN_PATH, "/");
        TestLegacyPortal.assertEquals(expectedParameters, (Object)this.router.route("/private/classic/"));
        TestLegacyPortal.assertEquals((String)"/private/classic/", (String)this.router.render(expectedParameters));
    }

    public void testPrivateClassicSlashComponent() throws Exception {
        HashMap<QualifiedName, String> expectedParameters = new HashMap<QualifiedName, String>();
        expectedParameters.put(Names.GTN_HANDLER, "portal");
        expectedParameters.put(Names.GTN_SITENAME, "classic");
        expectedParameters.put(Names.GTN_ACCESS, "private");
        expectedParameters.put(Names.GTN_PATH, "/");
        TestLegacyPortal.assertEquals(expectedParameters, (Object)this.router.route("/private/classic/"));
        TestLegacyPortal.assertEquals((String)"/private/classic/", (String)this.router.render(expectedParameters));
    }

    public void testPrivateClassicHome() throws Exception {
        HashMap<QualifiedName, String> expectedParameters = new HashMap<QualifiedName, String>();
        expectedParameters.put(Names.GTN_HANDLER, "portal");
        expectedParameters.put(Names.GTN_SITENAME, "classic");
        expectedParameters.put(Names.GTN_ACCESS, "private");
        expectedParameters.put(Names.GTN_PATH, "/home");
        TestLegacyPortal.assertEquals(expectedParameters, (Object)this.router.route("/private/classic/home"));
        TestLegacyPortal.assertEquals((String)"/private/classic/home", (String)this.router.render(expectedParameters));
    }

    public void testPrivateClassicHomeComponent() throws Exception {
        HashMap<QualifiedName, String> expectedParameters = new HashMap<QualifiedName, String>();
        expectedParameters.put(Names.GTN_HANDLER, "portal");
        expectedParameters.put(Names.GTN_SITENAME, "classic");
        expectedParameters.put(Names.GTN_ACCESS, "private");
        expectedParameters.put(Names.GTN_PATH, "/home");
        TestLegacyPortal.assertEquals(expectedParameters, (Object)this.router.route("/private/classic/home"));
        TestLegacyPortal.assertEquals((String)"/private/classic/home", (String)this.router.render(expectedParameters));
    }
}

