/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.util.Collections;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.metadata.ParamDescriptor;
import org.exoplatform.web.controller.metadata.RouteDescriptor;
import org.exoplatform.web.controller.router.AbstractTestController;
import org.exoplatform.web.controller.router.Names;
import org.exoplatform.web.controller.router.Router;

public class TestRender
extends AbstractTestController {
    public void testRoot() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/")}).build();
        TestRender.assertEquals((String)"/", (String)router.render(Collections.emptyMap()));
    }

    public void testA() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/a")}).build();
        TestRender.assertEquals((String)"/a", (String)router.render(Collections.emptyMap()));
    }

    public void testAB() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/a/b")}).build();
        TestRender.assertEquals((String)"/a/b", (String)router.render(Collections.emptyMap()));
    }

    public void testPathParam() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{p}")}).build();
        TestRender.assertEquals((String)"/a", (String)router.render(Collections.singletonMap(Names.P, "a")));
        TestRender.assertEquals((String)"", (String)router.render(Collections.emptyMap()));
    }

    public void testSimplePatternPathParam() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{p}").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"p").matchedBy("a")})}).build();
        TestRender.assertEquals((String)"/a", (String)router.render(Collections.singletonMap(Names.P, "a")));
        TestRender.assertEquals((String)"", (String)router.render(Collections.singletonMap(Names.P, "ab")));
    }

    public void testPrecedence() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/a")}).add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{p}/b").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"p").matchedBy("a")})}).build();
        TestRender.assertEquals((String)"/a", (String)router.render(Collections.emptyMap()));
        TestRender.assertEquals((String)"/a/b", (String)router.render(Collections.singletonMap(Names.P, "a")));
    }

    public void testLang() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{a}b").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"a").matchedBy("(([A-Za-z]{2})/)?").preservePath()})}).build();
        TestRender.assertEquals((String)"/fr/b", (String)router.render(Collections.singletonMap(Names.A, "fr/")));
        TestRender.assertEquals((String)"/b", (String)router.render(Collections.singletonMap(Names.A, "")));
    }

    public void testDisjunction() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{a}").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"a").matchedBy("a|b")})}).build();
        TestRender.assertEquals((String)"/b", (String)router.render(Collections.singletonMap(Names.A, "b")));
    }

    public void testCaptureGroup() throws Exception {
        Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/{a}").with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"a").matchedBy("a(.)c").captureGroup(true)})}).build();
        TestRender.assertEquals((String)"/abc", (String)router.render(Collections.singletonMap(Names.A, "b")));
    }
}

