/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.exoplatform.component.test.AbstractGateInTest;
import org.exoplatform.test.mocks.servlet.MockServletRequest;
import org.exoplatform.web.filter.ExtensibleFilter;
import org.exoplatform.web.filter.Filter;
import org.exoplatform.web.filter.FilterDefinition;

public class TestExtensibleFilter
extends AbstractGateInTest {
    public void testDoFilter() throws IOException, ServletException {
        String pathRequest = "/testPath";
        ExtensibleFilter exFilter = new ExtensibleFilter();
        MockFilterOKTF mockFilterOKTF = new MockFilterOKTF();
        MockFilterOKWTF mockFilterOKWTF = new MockFilterOKWTF();
        MockFilterChain chain = new MockFilterChain();
        exFilter.addFilterDefinitions(Arrays.asList(this.getFilterDefinition(mockFilterOKTF), this.getFilterDefinition(mockFilterOKWTF)));
        exFilter.doFilter((ServletRequest)new MockServletRequest(null, null), null, (FilterChain)chain, pathRequest);
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKTF.start);
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKTF.end);
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKWTF.start);
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKWTF.end);
        TestExtensibleFilter.assertTrue((boolean)chain.called);
        exFilter = new ExtensibleFilter();
        mockFilterOKTF = new MockFilterOKTF();
        mockFilterOKWTF = new MockFilterOKWTF();
        chain = new MockFilterChain();
        exFilter.addFilterDefinitions(Arrays.asList(this.getFilterDefinition(mockFilterOKTF), this.getFilterDefinition(mockFilterOKWTF), this.getFilterDefinition(new MockFilterKO())));
        exFilter.doFilter((ServletRequest)new MockServletRequest(null, null), null, (FilterChain)chain, pathRequest);
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKTF.start);
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKTF.end);
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKWTF.start);
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKWTF.end);
        TestExtensibleFilter.assertFalse((boolean)chain.called);
        exFilter = new ExtensibleFilter();
        mockFilterOKTF = new MockFilterOKTF();
        mockFilterOKWTF = new MockFilterOKWTF();
        chain = new MockFilterChain();
        exFilter.addFilterDefinitions(Arrays.asList(this.getFilterDefinition(mockFilterOKTF), this.getFilterDefinition(mockFilterOKWTF), this.getFilterDefinition(new MockFilterKOIO())));
        try {
            exFilter.doFilter((ServletRequest)new MockServletRequest(null, null), null, (FilterChain)chain, pathRequest);
            TestExtensibleFilter.fail((String)"IOException is expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKTF.start);
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKTF.end);
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKWTF.start);
        TestExtensibleFilter.assertFalse((boolean)mockFilterOKWTF.end);
        TestExtensibleFilter.assertFalse((boolean)chain.called);
        exFilter = new ExtensibleFilter();
        mockFilterOKTF = new MockFilterOKTF();
        mockFilterOKWTF = new MockFilterOKWTF();
        chain = new MockFilterChain();
        exFilter.addFilterDefinitions(Arrays.asList(this.getFilterDefinition(mockFilterOKTF), this.getFilterDefinition(mockFilterOKWTF), this.getFilterDefinition(new MockFilterKOSE())));
        try {
            exFilter.doFilter((ServletRequest)new MockServletRequest(null, null), null, (FilterChain)chain, pathRequest);
            TestExtensibleFilter.fail((String)"ServletException is expected");
        }
        catch (ServletException servletException) {
            // empty catch block
        }
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKTF.start);
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKTF.end);
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKWTF.start);
        TestExtensibleFilter.assertFalse((boolean)mockFilterOKWTF.end);
        TestExtensibleFilter.assertFalse((boolean)chain.called);
        exFilter = new ExtensibleFilter();
        mockFilterOKTF = new MockFilterOKTF();
        mockFilterOKWTF = new MockFilterOKWTF();
        chain = new MockFilterChain();
        exFilter.addFilterDefinitions(Arrays.asList(this.getFilterDefinition(mockFilterOKTF), this.getFilterDefinition(mockFilterOKWTF), this.getFilterDefinition(new MockFilterKORE())));
        try {
            exFilter.doFilter((ServletRequest)new MockServletRequest(null, null), null, (FilterChain)chain, pathRequest);
            TestExtensibleFilter.fail((String)"RuntimeException is expected");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKTF.start);
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKTF.end);
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKWTF.start);
        TestExtensibleFilter.assertFalse((boolean)mockFilterOKWTF.end);
        TestExtensibleFilter.assertFalse((boolean)chain.called);
        exFilter = new ExtensibleFilter();
        mockFilterOKTF = new MockFilterOKTF();
        mockFilterOKWTF = new MockFilterOKWTF();
        chain = new MockFilterChain();
        exFilter.addFilterDefinitions(Arrays.asList(this.getFilterDefinition(mockFilterOKTF), this.getFilterDefinition(mockFilterOKWTF), this.getFilterDefinition(new MockFilterKOER())));
        try {
            exFilter.doFilter((ServletRequest)new MockServletRequest(null, null), null, (FilterChain)chain, pathRequest);
            TestExtensibleFilter.fail((String)"Error is expected");
        }
        catch (Error error) {
            // empty catch block
        }
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKTF.start);
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKTF.end);
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKWTF.start);
        TestExtensibleFilter.assertFalse((boolean)mockFilterOKWTF.end);
        TestExtensibleFilter.assertFalse((boolean)chain.called);
        exFilter = new ExtensibleFilter();
        mockFilterOKTF = new MockFilterOKTF();
        mockFilterOKWTF = new MockFilterOKWTF();
        MockFilterOKTF mockFilterOKTF2 = new MockFilterOKTF();
        chain = new MockFilterChain();
        exFilter.addFilterDefinitions(Arrays.asList(this.getFilterDefinition(mockFilterOKTF), this.getFilterDefinition(mockFilterOKWTF), this.getFilterDefinition(new MockFilterKOIO()), this.getFilterDefinition(mockFilterOKTF2)));
        try {
            exFilter.doFilter((ServletRequest)new MockServletRequest(null, null), null, (FilterChain)chain, pathRequest);
            TestExtensibleFilter.fail((String)"IOException is expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKTF.start);
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKTF.end);
        TestExtensibleFilter.assertTrue((boolean)mockFilterOKWTF.start);
        TestExtensibleFilter.assertFalse((boolean)mockFilterOKWTF.end);
        TestExtensibleFilter.assertFalse((boolean)chain.called);
        TestExtensibleFilter.assertFalse((boolean)mockFilterOKTF2.start);
        TestExtensibleFilter.assertFalse((boolean)mockFilterOKTF2.end);
    }

    private FilterDefinition getFilterDefinition(Filter filter) {
        return new FilterDefinition(filter, Collections.singletonList(".*"));
    }

    private static class MockFilterOKTF
    implements Filter {
        private boolean start;
        private boolean end;

        private MockFilterOKTF() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            try {
                this.start = true;
                chain.doFilter(request, response);
            }
            finally {
                this.end = true;
            }
        }
    }

    private static class MockFilterOKWTF
    implements Filter {
        private boolean start;
        private boolean end;

        private MockFilterOKWTF() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            this.start = true;
            chain.doFilter(request, response);
            this.end = true;
        }
    }

    private static class MockFilterChain
    implements FilterChain {
        private boolean called;

        private MockFilterChain() {
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            this.called = true;
        }
    }

    private static class MockFilterKO
    implements Filter {
        private MockFilterKO() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        }
    }

    private static class MockFilterKOIO
    implements Filter {
        private MockFilterKOIO() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            throw new IOException();
        }
    }

    private static class MockFilterKOSE
    implements Filter {
        private MockFilterKOSE() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            throw new ServletException();
        }
    }

    private static class MockFilterKORE
    implements Filter {
        private MockFilterKORE() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            throw new RuntimeException();
        }
    }

    private static class MockFilterKOER
    implements Filter {
        private MockFilterKOER() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            throw new Error();
        }
    }
}

