/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.controller.resource;

import com.google.javascript.jscomp.AbstractCommandLineRunner;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.LoggerErrorManager;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.utils.CharsetTextEncoder;
import org.exoplatform.commons.utils.CompositeReader;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.commons.utils.TextEncoder;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.gatein.common.io.IOTools;
import org.gatein.portal.controller.resource.ResourceRequestHandler;
import org.gatein.portal.controller.resource.ScriptKey;
import org.gatein.portal.controller.resource.ScriptResult;

class ScriptLoader
implements Loader<ScriptKey, ScriptResult, ControllerContext> {
    ScriptLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptResult retrieve(ControllerContext context, ScriptKey key) throws Exception {
        JavascriptConfigService service = (JavascriptConfigService)PortalContainer.getComponent(JavascriptConfigService.class);
        CompositeReader script = service.getCompositeScript(key.id, key.locale);
        String sourceName = String.valueOf((Object)key.id.getScope()) + "/" + key.id.getName() + ".js";
        if (script != null) {
            CompositeReader result;
            if (key.minified) {
                ArrayList<Reader> minifiedReaders = new ArrayList<Reader>();
                if (CompositeReader.isMinify((Reader)script)) {
                    ScriptResult.Error error = this.minify(sourceName, (Reader)script, minifiedReaders);
                    if (error != null) {
                        return error;
                    }
                } else {
                    List readers = script.getCompounds();
                    for (Reader reader : readers) {
                        if (CompositeReader.isMinify((Reader)reader)) {
                            ScriptResult.Error error = this.minify(sourceName, reader, minifiedReaders);
                            if (error == null) continue;
                            return error;
                        }
                        minifiedReaders.add(reader);
                    }
                }
                result = new CompositeReader(minifiedReaders);
            } else {
                result = script;
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                TextEncoder encoder = CharsetTextEncoder.getUTF8();
                char[] buffer = new char[256];
                int l = result.read(buffer);
                while (l != -1) {
                    encoder.encode(buffer, 0, l, (OutputStream)out);
                    l = result.read(buffer);
                }
                ScriptResult.Resolved resolved = new ScriptResult.Resolved(out.toByteArray());
                return resolved;
            }
            finally {
                Safe.close((Closeable)result);
            }
        }
        return ScriptResult.NOT_FOUND;
    }

    private ScriptResult.Error minify(String sourceName, Reader reader, List<Reader> minifiedReaders) throws IOException {
        CompilationLevel level = CompilationLevel.SIMPLE_OPTIMIZATIONS;
        CompilerOptions options = new CompilerOptions();
        options.setWarningLevel(DiagnosticGroups.NON_STANDARD_JSDOC, CheckLevel.OFF);
        options.setStrictModeInput(false);
        options.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT_2021);
        options.setLanguageOut(CompilerOptions.LanguageMode.ECMASCRIPT5);
        options.setExternExports(true);
        level.setOptionsForCompilationLevel(options);
        StringWriter code = new StringWriter();
        IOTools.copy((Reader)reader, (Writer)code);
        SourceFile[] inputs = new SourceFile[]{SourceFile.fromCode((String)sourceName, (String)code.toString())};
        Compiler compiler = new Compiler();
        compiler.setErrorManager((ErrorManager)new LoggerErrorManager(Logger.getLogger(ResourceRequestHandler.class.getName())));
        Result res = compiler.compile(AbstractCommandLineRunner.getBuiltinExterns((CompilerOptions.Environment)CompilerOptions.Environment.BROWSER), Arrays.asList(inputs), options);
        if (res.success) {
            minifiedReaders.add(new StringReader(compiler.toSource()));
            return null;
        }
        StringBuilder msg = new StringBuilder("Handle me gracefully JS errors\n");
        for (JSError error : res.errors) {
            msg.append(error.getSourceName()).append(":").append(error.getLineNumber()).append(" ").append(error.getDescription()).append("\n");
        }
        return new ScriptResult.Error(msg.toString());
    }
}

