/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.Date;
import org.exoplatform.commons.utils.BinaryOutput;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.resource.ResourceRenderer;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;
import org.gatein.portal.controller.resource.ResourceRequestHandler;

@Deprecated
public class SkinResourceRequestHandler
extends WebRequestHandler {
    private final Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String EXPIRES = "Expires";
    private final SkinService skinService;

    public SkinResourceRequestHandler(SkinService skinService) {
        this.skinService = skinService;
    }

    public String getHandlerName() {
        return "skin";
    }

    public boolean execute(ControllerContext context) throws Exception {
        long ifModifiedSince;
        String compressParam = context.getParameter(ResourceRequestHandler.COMPRESS_QN);
        boolean compress = "min".equals(compressParam);
        HttpServletResponse response = context.getResponse();
        String ifModifiedSinceString = context.getRequest().getHeader(IF_MODIFIED_SINCE);
        long l = ifModifiedSince = ifModifiedSinceString == null ? 0L : new Date(ifModifiedSinceString).getTime();
        if (ifModifiedSince > 0L) {
            response.setHeader("Cache-Control", null);
            response.setStatus(304);
            return true;
        }
        response.setContentType("text/css");
        ServletOutputStream out = response.getOutputStream();
        BinaryOutput output = new BinaryOutput(){
            final /* synthetic */ OutputStream val$out;
            {
                this.val$out = outputStream;
            }

            public Charset getCharset() {
                return UTF_8;
            }

            public void write(byte b) throws IOException {
                this.val$out.write(b);
            }

            public void write(byte[] bytes) throws IOException {
                this.val$out.write(bytes);
            }

            public void write(byte[] bytes, int off, int len) throws IOException {
                this.val$out.write(bytes, off, len);
            }
        };
        String resource = "/" + context.getParameter(ResourceRequestHandler.RESOURCE_QN) + ".css";
        try {
            SkinResourceRenderer renderer = new SkinResourceRenderer(response, context, output);
            if (this.skinService.renderCSS(context, renderer, compress)) {
                return true;
            }
            this.log.warn((Object)("CSS " + resource + " not found"));
            return false;
        }
        catch (Exception e) {
            if (!(e instanceof SocketException)) {
                if (e.getClass().toString().contains("ClientAbortException")) {
                    return true;
                }
                this.log.error((Object)("Could not render css " + resource), (Throwable)e);
            }
            return false;
        }
    }

    private boolean isNotModified(long ifModifedSince, long lastModified) {
        return Math.abs(ifModifedSince - lastModified) < 1000L;
    }

    protected boolean getRequiresLifeCycle() {
        return false;
    }

    public static class SkinResourceRenderer
    implements ResourceRenderer {
        private final BinaryOutput output;
        private final HttpServletResponse response;
        private final ControllerContext context;

        public SkinResourceRenderer(HttpServletResponse response, ControllerContext context, BinaryOutput output) {
            this.response = response;
            this.output = output;
            this.context = context;
        }

        @Override
        public BinaryOutput getOutput() {
            return this.output;
        }

        @Override
        public void setExpiration(long seconds) {
            if (seconds > 0L) {
                this.response.setHeader("Cache-Control", "public, " + seconds);
                this.response.setDateHeader(SkinResourceRequestHandler.EXPIRES, System.currentTimeMillis() + seconds * 1000L);
                this.response.setHeader("Etag", "W/\"" + ResourceRequestHandler.VERSION.hashCode() + "\"");
            } else {
                this.response.setHeader("Cache-Control", "no-cache");
            }
            long lastModified = ((SkinService)ExoContainerContext.getService(SkinService.class)).getLastModified(this.context);
            this.response.setDateHeader(SkinResourceRequestHandler.LAST_MODIFIED, lastModified);
        }
    }
}

