/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.component.test.web.WebAppImpl;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.resource.AbstractWebResourceTest;
import org.exoplatform.test.mocks.servlet.MockServletContext;
import org.exoplatform.test.mocks.servlet.MockServletRequest;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.application.javascript.JavascriptConfigParser;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.URIWriter;
import org.gatein.common.io.IOTools;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.ResourceScope;
import org.gatein.portal.controller.resource.script.ScriptResource;
import org.gatein.wci.WebApp;
import org.json.JSONObject;

public class TestJavascriptConfigService
extends AbstractWebResourceTest {
    private static final ControllerContext CONTROLLER_CONTEXT = new MockControllerContext();
    private JavascriptConfigService jsService;
    private static ServletContext mockServletContext;
    private static boolean isFirstStartup;

    protected void setUp() throws Exception {
        PortalContainer portalContainer = this.getContainer();
        this.jsService = (JavascriptConfigService)portalContainer.getComponentInstanceOfType(JavascriptConfigService.class);
        if (isFirstStartup) {
            HashMap<String, String> resources = new HashMap<String, String>(6);
            resources.put("/js/script1.js", "aaa;");
            resources.put("/js/script2.js", "bbb;");
            resources.put("/js/module1.js", "ccc;");
            resources.put("/js/module2.js", "ddd;");
            resources.put("/js/common.js", "kkk;");
            resources.put("/js/pluginTest.js", "iii;");
            resources.put("/js/exclude.js", "eee;");
            resources.put("/js/normalize_test.js", " \n \t /* // */  //  /* \n  /* /*  */  \n  ggg; // /* */ \n");
            mockServletContext = new MockJSServletContext("mockwebapp", resources);
            this.jsService.registerContext((WebApp)new WebAppImpl(mockServletContext, Thread.currentThread().getContextClassLoader()));
            URL url = portalContainer.getPortalClassLoader().getResource("mockwebapp/gatein-resources.xml");
            JavascriptConfigParser.processConfigResource((InputStream)url.openStream(), (JavascriptConfigService)this.jsService, (ServletContext)mockServletContext);
            isFirstStartup = false;
        }
    }

    public void testGetScript() throws Exception {
        String script1 = "aaa;\nif (typeof define === 'function' && define.amd && !require.specified('SHARED/script1')) {define('SHARED/script1');}";
        String script2 = "bbb;\nif (typeof define === 'function' && define.amd && !require.specified('SHARED/script2')) {define('SHARED/script2');}";
        this.assertReader(script1, this.jsService.getScript(new ResourceId(ResourceScope.SHARED, "script1"), null));
        this.assertReader(script2, this.jsService.getScript(new ResourceId(ResourceScope.SHARED, "script2"), null));
        String module1 = "\ndefine('SHARED/module1', [], function() {\nvar require = eXo.require, requirejs = eXo.require,define = eXo.define;\neXo.define.names=[];\neXo.define.deps=[];\nreturn ccc;\n});";
        this.assertReader(module1, this.jsService.getScript(new ResourceId(ResourceScope.SHARED, "module1"), null));
        String module2 = "\ndefine('SHARED/module2', [\"SHARED/module1\"], function(mod1) {\nvar require = eXo.require, requirejs = eXo.require,define = eXo.define;\neXo.define.names=[\"mod1\"];\neXo.define.deps=[mod1];\nreturn ddd;\n});";
        this.assertReader(module2, this.jsService.getScript(new ResourceId(ResourceScope.SHARED, "module2"), null));
    }

    public void testCommonJS() throws Exception {
        String commonjs = "\ndefine('SHARED/commonjs', [\"require\",\"exports\",\"module\"], function(require,exports,module) {\nvar require = eXo.require, requirejs = eXo.require,define = eXo.define;\neXo.define.names=[\"require\",\"exports\",\"module\"];\neXo.define.deps=[eXo.require,exports,module];\nreturn kkk;\n});";
        this.assertReader(commonjs, this.jsService.getScript(new ResourceId(ResourceScope.SHARED, "commonjs"), null));
    }

    public void testExcludeJS() throws Exception {
        String excludejs = "\ndefine('SHARED/excludejs', [], function() {\nvar require = eXo.require, requirejs = eXo.require,define = eXo.define;\neXo.define.names=[];\neXo.define.deps=[];\nreturn eee;\n});";
        this.assertReader(excludejs, this.jsService.getScript(new ResourceId(ResourceScope.SHARED, "excludejs"), null));
    }

    public void testRequireJSPlugin() throws Exception {
        String pluginTest = "\ndefine('SHARED/pluginTest', [\"SHARED/text!/path/to/file.js\",\"SHARED/text!/path/to/file2.js\"], function(text,text_1) {\nvar require = eXo.require, requirejs = eXo.require,define = eXo.define;\neXo.define.names=[\"text!/path/to/file.js\",\"text!/path/to/file2.js\"];\neXo.define.deps=[text,text_1];\nreturn iii;\n});";
        this.assertReader(pluginTest, this.jsService.getScript(new ResourceId(ResourceScope.SHARED, "pluginTest"), null));
    }

    public void testGroupingScript() throws Exception {
        String module1 = "\n//Begin SHARED/module1\n\ndefine('SHARED/module1', [], function() {\nvar require = eXo.require, requirejs = eXo.require,define = eXo.define;\neXo.define.names=[];\neXo.define.deps=[];\nreturn ccc;\n});\n//End SHARED/module1";
        String module2 = "\n//Begin SHARED/module2\n\ndefine('SHARED/module2', [\"SHARED/module1\"], function(mod1) {\nvar require = eXo.require, requirejs = eXo.require,define = eXo.define;\neXo.define.names=[\"mod1\"];\neXo.define.deps=[mod1];\nreturn ddd;\n});\n//End SHARED/module2";
        StringWriter buffer = new StringWriter();
        IOTools.copy((Reader)this.jsService.getScript(new ResourceId(ResourceScope.GROUP, "fooGroup"), null), (Writer)buffer);
        String result = buffer.toString();
        result = result.replace(module1, "");
        result = result.replace(module2, "");
        TestJavascriptConfigService.assertTrue((boolean)result.trim().isEmpty());
    }

    public void testGetJSConfig() throws Exception {
        JSONObject config = this.jsService.getJSConfig();
        JSONObject shim = config.getJSONObject("shim");
        TestJavascriptConfigService.assertNotNull((Object)shim);
        JSONObject remoteDep = shim.getJSONObject("remote2");
        TestJavascriptConfigService.assertNotNull((Object)remoteDep);
        TestJavascriptConfigService.assertEquals((String)"{\"deps\":[\"remote1\"]}", (String)remoteDep.toString());
        JSONObject scriptDep = shim.getJSONObject("SHARED/script2");
        TestJavascriptConfigService.assertNotNull((Object)scriptDep);
        TestJavascriptConfigService.assertEquals((String)"{\"deps\":[\"SHARED/script1\"]}", (String)scriptDep.toString());
        JSONObject paths = config.getJSONObject("paths");
        TestJavascriptConfigService.assertNotNull((Object)paths);
        TestJavascriptConfigService.assertEquals((String)"http://js/remote1.js", (String)paths.getString("remote1"));
        TestJavascriptConfigService.assertEquals((String)"http://js/remote2.js", (String)paths.getString("remote2"));
        TestJavascriptConfigService.assertTrue((boolean)paths.getString("SHARED/module1").contains("/mockwebapp/js/fooGroup.js"));
        TestJavascriptConfigService.assertTrue((boolean)paths.getString("SHARED/module2").contains("/mockwebapp/js/fooGroup.js"));
        TestJavascriptConfigService.assertTrue((boolean)paths.getString("SHARED/script1").contains("/mockwebapp/js/script1.js"));
        TestJavascriptConfigService.assertTrue((boolean)paths.getString("SHARED/script2").contains("/mockwebapp/js/script2.js"));
    }

    public void testGenerateURL() throws Exception {
        ResourceId remote1 = new ResourceId(ResourceScope.SHARED, "remote1");
        String remoteURL = this.jsService.generateUrl(remote1);
        TestJavascriptConfigService.assertEquals((String)"http://js/remote1.js", (String)remoteURL);
        ResourceId module1 = new ResourceId(ResourceScope.SHARED, "module1");
        remoteURL = this.jsService.generateUrl(module1);
        TestJavascriptConfigService.assertEquals((String)"/mockwebapp/js/module1.js?hash=-55414319&scope=SHARED&minify=true", (String)remoteURL);
    }

    public void testGenerateURLWithLocale() throws Exception {
        ScriptResource resource = this.jsService.getResource(new ResourceId(ResourceScope.SHARED, "text"));
        resource.addSupportedLocale(Locale.ENGLISH);
        resource.addSupportedLocale(Locale.FRENCH);
        JSONObject config = this.jsService.getJSConfig();
        TestJavascriptConfigService.assertNotNull((Object)config);
        TestJavascriptConfigService.assertNotNull((Object)config.getJSONObject("paths"));
        TestJavascriptConfigService.assertNotNull((Object)config.getJSONObject("paths").getString("SHARED/text"));
        TestJavascriptConfigService.assertEquals((String)"/mockwebapp/js/text.js?hash=1278397679&scope=SHARED&minify=true", (String)config.getJSONObject("paths").getString("SHARED/text"));
        config = this.jsService.getJSConfig();
        TestJavascriptConfigService.assertNotNull((Object)config);
        TestJavascriptConfigService.assertNotNull((Object)config.getJSONObject("paths"));
        TestJavascriptConfigService.assertNotNull((Object)config.getJSONObject("paths").getString("SHARED/text"));
        TestJavascriptConfigService.assertTrue((boolean)config.getJSONObject("paths").getString("SHARED/text").contains("/mockwebapp/js/text.js"));
    }

    public void testNormalize() throws Exception {
        String normalizedJS = "\ndefine('SHARED/normalize_test', [], function() {\nvar require = eXo.require, requirejs = eXo.require,define = eXo.define;\neXo.define.names=[];\neXo.define.deps=[];\nreturn ggg; // /* */ \n\n});";
        this.assertReader(normalizedJS, this.jsService.getScript(new ResourceId(ResourceScope.SHARED, "normalize_test"), null));
    }

    public void testResolveIDs() {
        HashMap tmp = new HashMap();
        tmp.put(new ResourceId(ResourceScope.SHARED, "script2"), null);
        Map ids = this.jsService.resolveIds(tmp);
        TestJavascriptConfigService.assertEquals((int)2, (int)ids.size());
        ArrayList result = new ArrayList(ids.keySet());
        TestJavascriptConfigService.assertEquals((String)"script1", (String)((ScriptResource)result.get(0)).getId().getName());
        TestJavascriptConfigService.assertEquals((String)"script2", (String)((ScriptResource)result.get(1)).getId().getName());
        tmp.clear();
        tmp.put(new ResourceId(ResourceScope.SHARED, "module2"), null);
        ids = this.jsService.resolveIds(tmp);
        TestJavascriptConfigService.assertEquals((int)1, (int)ids.size());
        TestJavascriptConfigService.assertEquals((String)"module2", (String)((ScriptResource)ids.keySet().iterator().next()).getId().getName());
    }

    private void assertReader(String expected, Reader actual) throws Exception {
        StringWriter buffer = new StringWriter();
        IOTools.copy((Reader)actual, (Writer)buffer, (int)1);
        TestJavascriptConfigService.assertEquals((String)expected, (String)buffer.toString());
    }

    static {
        isFirstStartup = true;
    }

    private static class MockJSServletContext
    extends MockServletContext {
        private Map<String, String> resources;

        public MockJSServletContext(String contextName, Map<String, String> resources) {
            super(contextName);
            this.resources = resources;
        }

        public String getContextPath() {
            return "/" + this.getServletContextName();
        }

        public InputStream getResourceAsStream(String s) {
            String input = this.resources.get(s);
            if (input != null) {
                return new ByteArrayInputStream(input.getBytes());
            }
            return null;
        }
    }

    private static class MockControllerContext
    extends ControllerContext {
        public MockControllerContext() {
            super(null, null, (HttpServletRequest)new MockServletRequest(null, null), null, null);
        }

        public void renderURL(Map<QualifiedName, String> parameters, URIWriter uriWriter) throws IOException {
            Object lang = parameters.get(QualifiedName.create((String)"gtn", (String)"lang"));
            lang = StringUtils.isBlank((CharSequence)lang) ? "" : "-" + (String)lang;
            uriWriter.appendSegment("mock_url_of_" + parameters.get(QualifiedName.create((String)"gtn", (String)"resource")) + (String)lang + ".js");
        }
    }
}

