/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.impl.LocaleConfigImpl;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.application.JspBasedWebHandler;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestJspBasedWebHandler {
    @Test
    public void testPrepareDispatch() throws Exception {
        String bootstrapPath = "bootstrapUrl";
        String bootstrapModuleName = "SHARED/bootstrap";
        String applicationJSModuleName = "SHARED/applicationJSModule";
        String applicationJSModulePath = "applicationJSModulePath";
        String additionalJSModuleName = "SHARED/additionalJSModule";
        String additionalJSModulePath = "additionalJSModulePath";
        String additionalCSSModuleName = "additionalCSSModule";
        String companyName = "companyNameAcme";
        String primarycolor = "#445588";
        String uiParamKey = "uiParamKey";
        String uiParamValue = "uiParamValue";
        long brandingLastModifiedTime = System.currentTimeMillis();
        LocaleConfigService localeConfigService = (LocaleConfigService)Mockito.mock(LocaleConfigService.class);
        BrandingService brandingService = (BrandingService)Mockito.mock(BrandingService.class);
        JavascriptConfigService javascriptConfigService = (JavascriptConfigService)Mockito.mock(JavascriptConfigService.class);
        SkinService skinService = (SkinService)Mockito.mock(SkinService.class);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/portal");
        HashMap attributes = new HashMap();
        ((HttpServletRequest)Mockito.doAnswer(invocation -> {
            String key = (String)invocation.getArgument(0, String.class);
            Object value = invocation.getArgument(1);
            attributes.put(key, value);
            return null;
        }).when((Object)request)).setAttribute((String)ArgumentMatchers.any(), ArgumentMatchers.any());
        LocaleConfigImpl localeConfig = new LocaleConfigImpl();
        localeConfig.setLocale(Locale.ENGLISH);
        Mockito.when((Object)localeConfigService.getDefaultLocaleConfig()).thenReturn((Object)localeConfig);
        Mockito.when((Object)brandingService.getCompanyName()).thenReturn((Object)companyName);
        Mockito.when((Object)brandingService.getLastUpdatedTime()).thenReturn((Object)brandingLastModifiedTime);
        Mockito.when((Object)brandingService.getThemeStyle()).thenReturn(Collections.singletonMap("primaryColor", primarycolor));
        JSONObject jsConfig = new JSONObject("{paths:{}}");
        JSONObject jsConfigPaths = jsConfig.getJSONObject("paths");
        jsConfigPaths.put(bootstrapModuleName, (Object)bootstrapPath);
        jsConfigPaths.put(additionalJSModuleName, (Object)additionalJSModulePath);
        jsConfigPaths.put(applicationJSModuleName, (Object)applicationJSModulePath);
        Mockito.when((Object)javascriptConfigService.getJSConfig((ControllerContext)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any())).thenReturn((Object)jsConfig);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        ControllerContext controllerContext = new ControllerContext(null, null, request, response, null);
        JspBasedWebHandler jspBasedWebHandler = new JspBasedWebHandler(this, localeConfigService, brandingService, javascriptConfigService, skinService){};
        jspBasedWebHandler.prepareDispatch(controllerContext, applicationJSModuleName, Arrays.asList(additionalJSModuleName, bootstrapModuleName), Collections.singletonList(additionalCSSModuleName), params -> {
            try {
                params.put(uiParamKey, (Object)uiParamValue);
            }
            catch (JSONException e) {
                Assert.fail((String)e.getMessage());
            }
        });
        Assert.assertFalse((boolean)attributes.isEmpty());
        Assert.assertTrue((boolean)attributes.containsKey("jsConfig"));
        Assert.assertTrue((boolean)attributes.containsKey("localeConfig"));
        Assert.assertTrue((boolean)attributes.containsKey("headerScripts"));
        Assert.assertTrue((boolean)attributes.containsKey("pageScripts"));
        Assert.assertTrue((boolean)attributes.containsKey("inlineScripts"));
        Assert.assertTrue((boolean)attributes.containsKey("brandingPrimaryColor"));
        Assert.assertTrue((boolean)attributes.containsKey("brandingThemeUrl"));
        Assert.assertTrue((boolean)attributes.containsKey("skinUrls"));
        Assert.assertEquals((Object)jsConfig.toString(), attributes.get("jsConfig"));
        Assert.assertEquals((Object)localeConfig, attributes.get("localeConfig"));
        Assert.assertEquals(Collections.emptyList(), attributes.get("headerScripts"));
        String inlineScripts = attributes.get("inlineScripts").toString();
        Assert.assertTrue((boolean)inlineScripts.contains(bootstrapModuleName));
        Assert.assertTrue((boolean)inlineScripts.contains(applicationJSModuleName));
        Assert.assertTrue((boolean)inlineScripts.contains(additionalJSModuleName));
        Assert.assertTrue((boolean)inlineScripts.contains(uiParamKey));
        Assert.assertTrue((boolean)inlineScripts.contains(uiParamValue));
        Assert.assertTrue((boolean)inlineScripts.contains(companyName));
        Assert.assertTrue((boolean)inlineScripts.contains("brandingLogo"));
        Assert.assertTrue((boolean)attributes.get("brandingThemeUrl").toString().contains(String.valueOf(brandingLastModifiedTime)));
        Assert.assertEquals((Object)attributes.get("brandingPrimaryColor").toString(), (Object)primarycolor);
        ((HttpServletResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).setContentType("text/html; charset=UTF-8");
    }
}

