/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application.javascript;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CompositeReader;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.portal.resource.AbstractResourceService;
import org.exoplatform.portal.resource.compressor.ResourceCompressor;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.javascript.JavascriptConfigDeployer;
import org.exoplatform.web.controller.router.URIWriter;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.ResourceRequestHandler;
import org.gatein.portal.controller.resource.ResourceScope;
import org.gatein.portal.controller.resource.script.BaseScriptResource;
import org.gatein.portal.controller.resource.script.FetchMode;
import org.gatein.portal.controller.resource.script.Module;
import org.gatein.portal.controller.resource.script.ScriptGraph;
import org.gatein.portal.controller.resource.script.ScriptGroup;
import org.gatein.portal.controller.resource.script.ScriptResource;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.WebApp;
import org.gatein.wci.WebAppListener;
import org.json.JSONArray;
import org.json.JSONObject;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="management"), @Property(key="type", value="javascript")})
@ManagedDescription(value="Javascript config service")
@RESTEndpoint(path="javascriptService")
public class JavascriptConfigService
extends AbstractResourceService
implements Startable {
    private final Log log = ExoLogger.getLogger(JavascriptConfigService.class);
    final ScriptGraph scripts;
    private final WebAppListener deployer;
    public static final List<String> RESERVED_MODULE = Arrays.asList("require", "exports", "module");
    private static final Pattern INDEX_PATTERN = Pattern.compile("^.+?(_([1-9]+))$");
    public static final Pattern JS_ID_PATTERN = Pattern.compile("^[a-zA-Z_$][0-9a-zA-Z_$]*$");
    public final Map<String, String> scriptURLs = new HashMap<String, String>();
    public static final Comparator<Module> MODULE_COMPARATOR = new Comparator<Module>(){

        @Override
        public int compare(Module o1, Module o2) {
            return o1.getPriority() - o2.getPriority();
        }
    };

    public JavascriptConfigService(ExoContainerContext context, ResourceCompressor compressor) {
        super(compressor);
        this.scripts = new ScriptGraph();
        this.deployer = new JavascriptConfigDeployer(context.getPortalContainerName(), this);
    }

    public Reader getScript(ResourceId resourceId, Locale locale) throws Exception {
        return this.getCompositeScript(resourceId, locale);
    }

    public CompositeReader getCompositeScript(ResourceId resourceId, Locale locale) throws Exception {
        if (ResourceScope.GROUP.equals((Object)resourceId.getScope())) {
            ScriptGroup loadGroup = this.scripts.getLoadGroup(resourceId.getName());
            if (loadGroup != null) {
                ArrayList<StringReader> readers = new ArrayList<StringReader>(loadGroup.getDependencies().size());
                for (ResourceId id : loadGroup.getDependencies()) {
                    CompositeReader rd = this.getCompositeScript(id, locale);
                    if (rd == null) continue;
                    readers.add(new StringReader("\n//Begin " + String.valueOf(id) + "\n"));
                    readers.add((StringReader)rd);
                    readers.add(new StringReader("\n//End " + String.valueOf(id) + "\n"));
                }
                return new CompositeReader(readers);
            }
            return null;
        }
        ScriptResource resource = this.getResource(resourceId);
        if (resource != null) {
            ArrayList<Module> modules = new ArrayList<Module>(resource.getModules());
            Collections.sort(modules, MODULE_COMPARATOR);
            ArrayList<Reader> readers = new ArrayList<Reader>(modules.size() * 2);
            StringBuilder buffer = new StringBuilder();
            boolean isModule = FetchMode.ON_LOAD.equals((Object)resource.getFetchMode());
            if (isModule) {
                JSONArray deps = new JSONArray();
                LinkedList<String> params = new LinkedList<String>();
                LinkedList<String> argNames = new LinkedList<String>();
                LinkedList<String> argValues = new LinkedList<String>(params);
                for (ResourceId id : resource.getDependencies()) {
                    ScriptResource dep = this.getResource(id);
                    if (dep != null) {
                        Set<ScriptResource.DepInfo> depInfos = resource.getDepInfo(id);
                        for (ScriptResource.DepInfo info : depInfos) {
                            String pluginRS = info.getPluginRS();
                            String alias = info.getAlias();
                            if (alias == null) {
                                alias = dep.getAlias();
                            }
                            deps.put((Object)this.parsePluginRS(dep.getId().toString(), pluginRS));
                            params.add(this.encode(params, alias));
                            argNames.add(this.parsePluginRS(alias, pluginRS));
                        }
                        continue;
                    }
                    if (!RESERVED_MODULE.contains(id.getName())) continue;
                    String reserved = id.getName();
                    deps.put((Object)reserved);
                    params.add(reserved);
                    argNames.add(reserved);
                }
                argValues.addAll(params);
                int reserveIdx = argValues.indexOf("require");
                if (reserveIdx != -1) {
                    argValues.set(reserveIdx, "eXo.require");
                }
                buffer.append("\ndefine('").append(resourceId).append("', ");
                buffer.append(deps);
                buffer.append(", function(");
                buffer.append(StringUtils.join(params, (String)","));
                buffer.append(") {\nvar require = eXo.require, requirejs = eXo.require,define = eXo.define;");
                buffer.append("\neXo.define.names=").append(new JSONArray(argNames)).append(";");
                buffer.append("\neXo.define.deps=[").append(StringUtils.join(argValues, (String)",")).append("]").append(";");
                buffer.append("\nreturn ");
            }
            boolean isMinify = true;
            for (Module js : modules) {
                Reader jScript;
                if (js instanceof Module.Local) {
                    isMinify = ((Module.Local)js).isMinify();
                }
                if ((jScript = this.getJavascript(js, locale)) == null) continue;
                readers.add(new StringReader(buffer.toString()));
                buffer.setLength(0);
                readers.add(new NormalizeJSReader(this, jScript));
            }
            if (isModule) {
                buffer.append("\n});");
            } else {
                buffer.append("\nif (typeof define === 'function' && define.amd && !require.specified('").append(resource.getId()).append("')) {");
                buffer.append("define('").append(resource.getId()).append("');}");
            }
            readers.add(new StringReader(buffer.toString()));
            return new CompositeReader.MinifiableReader(readers, isMinify);
        }
        return null;
    }

    public String generateURL(ControllerContext controllerContext, ResourceId id, boolean merge, boolean minified, Locale locale) throws IOException {
        BaseScriptResource resource = null;
        resource = ResourceScope.GROUP.equals((Object)id.getScope()) ? this.scripts.getLoadGroup(id.getName()) : this.getResource(id);
        if (resource != null) {
            BaseScriptResource rs;
            List<Module> modules;
            if (resource instanceof ScriptResource && (modules = ((ScriptResource)(rs = resource)).getModules()).size() > 0 && modules.get(0) instanceof Module.Remote) {
                return ((Module.Remote)modules.get(0)).getURI();
            }
            StringBuilder buffer = new StringBuilder();
            URIWriter writer = new URIWriter((Appendable)buffer);
            controllerContext.renderURL(resource.getParameters(minified, locale), writer);
            return buffer.toString();
        }
        return null;
    }

    public Map<ScriptResource, FetchMode> resolveIds(Map<ResourceId, FetchMode> ids) {
        return this.scripts.resolve(ids);
    }

    public JSONObject getJSConfig(ControllerContext controllerContext, Locale locale) throws Exception {
        JSONObject paths = new JSONObject();
        JSONObject shim = new JSONObject();
        for (ScriptResource resource : this.getAllResources()) {
            String url;
            ScriptGroup group;
            if (resource.isEmpty() && !ResourceScope.SHARED.equals((Object)resource.getId().getScope())) continue;
            String name = resource.getId().toString();
            List<Module> modules = resource.getModules();
            if (FetchMode.IMMEDIATE.equals((Object)resource.getFetchMode()) || modules.size() > 0 && modules.get(0) instanceof Module.Remote) {
                JSONArray deps = new JSONArray();
                for (ResourceId id : resource.getDependencies()) {
                    deps.put((Object)this.getResource(id).getId());
                }
                if (deps.length() > 0) {
                    shim.put(name, (Object)new JSONObject().put("deps", (Object)deps));
                }
            }
            if ((group = resource.getGroup()) != null) {
                ResourceId grpId = group.getId();
                String key = grpId.toString() + "-" + (locale == null ? "" : locale.toString());
                url = this.scriptURLs.get(key);
                if (url == null) {
                    url = this.buildURL(grpId, controllerContext, locale);
                    this.scriptURLs.put(key, url);
                }
            } else {
                String key = resource.getId().toString() + "-" + (locale == null ? "" : locale.toString());
                url = this.scriptURLs.get(key);
                if (url == null) {
                    url = this.buildURL(resource.getId(), controllerContext, locale);
                    this.scriptURLs.put(key, url);
                }
            }
            paths.put(name, (Object)url);
        }
        JSONObject config = new JSONObject();
        config.put("paths", (Object)paths);
        config.put("shim", (Object)shim);
        return config;
    }

    public ScriptResource getResource(ResourceId resource) {
        return this.scripts.getResource(resource);
    }

    public void start() {
        this.log.debug((Object)"Registering JavascriptConfigService for servlet container events");
        ServletContainerFactory.getServletContainer().addWebAppListener(this.deployer);
    }

    @Managed
    @ManagedDescription(value="Retrieve all javascript modules IDs")
    @Impact(value=ImpactType.READ)
    public Collection<String> getJavascriptKeys() {
        WebAppController webAppController = (WebAppController)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WebAppController.class);
        ResourceRequestHandler handler = (ResourceRequestHandler)webAppController.getHandler("script");
        return handler.getJavascriptModules();
    }

    @Managed
    @ManagedDescription(value="Reload all javascript modules")
    @Impact(value=ImpactType.WRITE)
    public void reloadJavascripts() {
        WebAppController webAppController = (WebAppController)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WebAppController.class);
        ResourceRequestHandler handler = (ResourceRequestHandler)webAppController.getHandler("script");
        handler.reloadJavascriptModules();
    }

    @Managed
    @ManagedDescription(value="Reload a selected javascript module by its ID")
    @Impact(value=ImpactType.WRITE)
    public void reloadJavascript(@ManagedDescription(value="JS Module: SCOPE/NAME") @ManagedName(value="jsModule") String jsModule) {
        WebAppController webAppController = (WebAppController)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WebAppController.class);
        ResourceRequestHandler handler = (ResourceRequestHandler)webAppController.getHandler("script");
        handler.reloadJavascriptModule(jsModule);
    }

    public void stop() {
        this.log.debug((Object)"Unregistering JavascriptConfigService for servlet container events");
        ServletContainerFactory.getServletContainer().removeWebAppListener(this.deployer);
    }

    private Reader getJavascript(Module module, Locale locale) {
        Module.Local localModule;
        WebApp webApp;
        if (module instanceof Module.Local && (webApp = (WebApp)this.contexts.get((localModule = (Module.Local)module).getContextPath())) != null) {
            ServletContext sc = webApp.getServletContext();
            return localModule.read(locale, sc, webApp.getClassLoader());
        }
        return null;
    }

    private String buildURL(ResourceId id, ControllerContext context, Locale locale) throws Exception {
        String url = this.generateURL(context, id, !PropertyManager.isDevelopping(), !PropertyManager.isDevelopping(), locale);
        if (url != null && url.endsWith(".js")) {
            return url.substring(0, url.length() - ".js".length());
        }
        return null;
    }

    private List<ScriptResource> getAllResources() {
        LinkedList<ScriptResource> resources = new LinkedList<ScriptResource>();
        for (ResourceScope scope : ResourceScope.values()) {
            resources.addAll(this.scripts.getResources(scope));
        }
        return resources;
    }

    private String encode(LinkedList<String> params, String alias) {
        Matcher validMatcher = JS_ID_PATTERN.matcher(alias = alias.replace("/", "_"));
        if (!validMatcher.matches()) {
            this.log.error("alias {} is not valid, changing to default 'alias' name", new Object[]{alias});
            alias = "alias";
        }
        int idx = -1;
        Iterator<String> iterator = params.descendingIterator();
        while (iterator.hasNext()) {
            String param = iterator.next();
            Matcher matcher = INDEX_PATTERN.matcher(param);
            if (matcher.matches()) {
                if (!param.replace(matcher.group(1), "").equals(alias)) continue;
                idx = Integer.parseInt(matcher.group(2));
                break;
            }
            if (!alias.equals(param)) continue;
            idx = 0;
            break;
        }
        if (idx != -1) {
            StringBuilder tmp = new StringBuilder(alias);
            tmp.append("_").append(idx + 1);
            String a = tmp.toString();
            this.log.warn("alias {} is duplicated, adding index: {}", new Object[]{alias, a});
            return a;
        }
        return alias;
    }

    private String parsePluginRS(String name, String pluginRS) {
        StringBuilder depBuild = new StringBuilder(name);
        if (pluginRS != null) {
            depBuild.append("!").append(pluginRS);
        }
        return depBuild.toString();
    }

    private class NormalizeJSReader
    extends Reader {
        private boolean finished = false;
        private boolean multiComments = false;
        private boolean singleComment = false;
        private Reader sub;

        public NormalizeJSReader(JavascriptConfigService javascriptConfigService, Reader sub) {
            this.sub = sub;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.finished) {
                return this.sub.read(cbuf, off, len);
            }
            char[] buffer = new char[len];
            int relLen = this.sub.read(buffer, 0, len);
            if (relLen == -1) {
                this.finished = true;
                return -1;
            }
            int r = off;
            for (int i = 0; i < relLen; ++i) {
                boolean overflow;
                char c = buffer[i];
                char next = '\u0000';
                boolean skip = false;
                boolean bl = overflow = i + 1 == relLen;
                if (!this.finished) {
                    skip = true;
                    if (!this.singleComment && c == '/' && (next = this.readNext(buffer, i, overflow)) == '*') {
                        this.multiComments = true;
                        ++i;
                    } else if (!this.singleComment && c == '*' && (next = this.readNext(buffer, i, overflow)) == '/') {
                        this.multiComments = false;
                        ++i;
                    } else if (!this.multiComments && c == '/' && next == '/') {
                        this.singleComment = true;
                        ++i;
                    } else if (c == '\n') {
                        this.singleComment = false;
                    } else if (!(Character.isWhitespace(c) || Character.isSpaceChar(c) || Character.isISOControl(c))) {
                        skip = false;
                    }
                    if (skip || this.multiComments || this.singleComment) continue;
                    if (next != '\u0000' && overflow) {
                        this.sub = new CompositeReader(new Reader[]{new StringReader(String.valueOf(c)), this.sub});
                    }
                    cbuf[r++] = c;
                    this.finished = true;
                    continue;
                }
                cbuf[r++] = c;
            }
            return r - off;
        }

        private char readNext(char[] buffer, int i, boolean overflow) throws IOException {
            char c = '\u0000';
            if (overflow) {
                int tmp = this.sub.read();
                if (tmp != -1) {
                    c = (char)tmp;
                }
            } else {
                c = buffer[i + 1];
            }
            return c;
        }

        @Override
        public void close() throws IOException {
            this.sub.close();
        }
    }
}

