/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.xml.DocumentSource;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.component.test.web.ServletContextImpl;
import org.exoplatform.component.test.web.WebAppImpl;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.resource.MockResourceResolver;
import org.exoplatform.portal.resource.ResourceResolver;
import org.exoplatform.portal.resource.SimpleSkin;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinKey;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.SkinURL;
import org.exoplatform.portal.resource.SkinVisitor;
import org.exoplatform.portal.resource.config.xml.SkinConfigParser;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.test.mocks.servlet.MockServletRequest;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.controller.router.Router;
import org.gatein.wci.WebApp;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/test-configuration.xml")})
public abstract class AbstractSkinServiceTest
extends AbstractKernelTest {
    protected static final String ASSETS_VERSION = "PORTAL-VERSION";
    protected SkinService skinService;
    protected ControllerContext controllerCtx;
    protected List<SkinKey> skinsToDelete = new ArrayList<SkinKey>();
    private static ServletContext mockServletContext;
    protected static MockResourceResolver resResolver;

    abstract boolean isDevelopingMode();

    abstract Router getRouter();

    abstract boolean setUpTestEnvironment();

    abstract void touchSetUp();

    protected void setUp() throws Exception {
        PropertyManager.setProperty((String)"exo.product.developing", (String)String.valueOf(this.isDevelopingMode()));
        PortalContainer portalContainer = this.getContainer();
        this.skinService = (SkinService)portalContainer.getComponentInstanceOfType(SkinService.class);
        this.controllerCtx = this.getControllerContext();
        if (this.setUpTestEnvironment()) {
            URL base = AbstractSkinServiceTest.class.getClassLoader().getResource("mockwebapp");
            File f = new File(base.toURI());
            AbstractSkinServiceTest.assertTrue((boolean)f.exists());
            AbstractSkinServiceTest.assertTrue((boolean)f.isDirectory());
            mockServletContext = new ServletContextImpl(f, "/mockwebapp", "mockwebapp");
            this.skinService.registerContext((WebApp)new WebAppImpl(mockServletContext, Thread.currentThread().getContextClassLoader()));
            resResolver = new MockResourceResolver();
            this.skinService.addResourceResolver((ResourceResolver)resResolver);
            URL url = mockServletContext.getResource("/gatein-resources.xml");
            SkinConfigParser.processConfigResource((DocumentSource)DocumentSource.create((URL)url), (SkinService)this.skinService, (ServletContext)mockServletContext);
            this.touchSetUp();
        }
    }

    protected void tearDown() throws Exception {
        resResolver.reset();
        for (SkinKey key : this.skinsToDelete) {
            this.skinService.removeSupportedSkin(key.getName());
            this.skinService.removeSkin(key);
        }
        this.skinsToDelete.clear();
        this.skinService.reloadSkins();
    }

    public void testInitializing() throws Exception {
        AbstractSkinServiceTest.assertEquals((int)1, (int)this.skinService.getAvailableSkinNames().size());
        AbstractSkinServiceTest.assertTrue((boolean)this.skinService.getAvailableSkinNames().contains("TestSkin"));
        AbstractSkinServiceTest.assertTrue((boolean)this.skinService.mainResolver.resolvers.contains(resResolver));
    }

    public void testPortalSkin() {
        String contextPath = mockServletContext.getContextPath();
        SkinConfig portalSkin = this.skinService.getPortalSkin("Core", "TestSkin");
        AbstractSkinServiceTest.assertNotNull((Object)portalSkin);
        AbstractSkinServiceTest.assertEquals((String)"Core", (String)portalSkin.getModule());
        AbstractSkinServiceTest.assertEquals((String)(contextPath + "/skin/core/Stylesheet.css"), (String)portalSkin.getCSSPath());
        portalSkin = this.skinService.getPortalSkin("Module2", "TestSkin");
        AbstractSkinServiceTest.assertNotNull((Object)portalSkin);
        AbstractSkinServiceTest.assertEquals((String)"Module2", (String)portalSkin.getModule());
        AbstractSkinServiceTest.assertEquals((String)(contextPath + "/skin/module2/Stylesheet.css"), (String)portalSkin.getCSSPath());
        portalSkin = this.skinService.getPortalSkin("Module3", "TestSkin");
        AbstractSkinServiceTest.assertNotNull((Object)portalSkin);
        AbstractSkinServiceTest.assertEquals((String)"Module3", (String)portalSkin.getModule());
        AbstractSkinServiceTest.assertEquals((String)(contextPath + "/skin/module3/Stylesheet.css"), (String)portalSkin.getCSSPath());
        portalSkin = this.skinService.getPortalSkin("Module1", "TestSkin");
        AbstractSkinServiceTest.assertNotNull((Object)portalSkin);
        AbstractSkinServiceTest.assertEquals((String)"Module1", (String)portalSkin.getModule());
        AbstractSkinServiceTest.assertEquals((String)(contextPath + "/skin/module1/Stylesheet.css"), (String)portalSkin.getCSSPath());
    }

    public void testRemovePortalSkin() {
        String skinName = "TestSkin";
        String module = "ToDeletePortalSkin";
        String cssPath = mockServletContext.getContextPath() + "/skin/core/Stylesheet.css";
        SkinConfig portalSkin = this.skinService.getPortalSkin(module, skinName);
        AbstractSkinServiceTest.assertNull((Object)portalSkin);
        this.skinService.addPortalSkin(module, skinName, cssPath);
        portalSkin = this.skinService.getPortalSkin(module, skinName);
        AbstractSkinServiceTest.assertNotNull((Object)portalSkin);
        AbstractSkinServiceTest.assertEquals((String)cssPath, (String)portalSkin.getCSSPath());
        this.skinService.removePortalSkin(module, skinName);
        portalSkin = this.skinService.getPortalSkin(module, skinName);
        AbstractSkinServiceTest.assertNull((Object)portalSkin);
    }

    public void testPortalSkinAndPriority() {
        Collection portalSkinConfigs = this.skinService.getPortalSkins("TestSkin");
        String contextPath = mockServletContext.getContextPath();
        AbstractSkinServiceTest.assertNotNull((Object)portalSkinConfigs);
        AbstractSkinServiceTest.assertEquals((int)4, (int)portalSkinConfigs.size());
        SkinConfig[] array = new SkinConfig[4];
        portalSkinConfigs.toArray(array);
        SkinConfig portalSkin = array[0];
        AbstractSkinServiceTest.assertNotNull((Object)portalSkin);
        AbstractSkinServiceTest.assertEquals((String)"Core", (String)portalSkin.getModule());
        AbstractSkinServiceTest.assertEquals((String)(contextPath + "/skin/core/Stylesheet.css"), (String)portalSkin.getCSSPath());
        portalSkin = array[1];
        AbstractSkinServiceTest.assertNotNull((Object)portalSkin);
        AbstractSkinServiceTest.assertEquals((String)"Module2", (String)portalSkin.getModule());
        AbstractSkinServiceTest.assertEquals((String)(contextPath + "/skin/module2/Stylesheet.css"), (String)portalSkin.getCSSPath());
        portalSkin = array[2];
        AbstractSkinServiceTest.assertNotNull((Object)portalSkin);
        AbstractSkinServiceTest.assertEquals((String)"Module3", (String)portalSkin.getModule());
        AbstractSkinServiceTest.assertEquals((String)(contextPath + "/skin/module3/Stylesheet.css"), (String)portalSkin.getCSSPath());
        portalSkin = array[3];
        AbstractSkinServiceTest.assertNotNull((Object)portalSkin);
        AbstractSkinServiceTest.assertEquals((String)"Module1", (String)portalSkin.getModule());
        AbstractSkinServiceTest.assertEquals((String)(contextPath + "/skin/module1/Stylesheet.css"), (String)portalSkin.getCSSPath());
    }

    public void testPortalSkinVisitor() {
        String contextPath = mockServletContext.getContextPath();
        Collection portalSkinConfigs = this.skinService.findSkins(new SkinVisitor(this){

            public Collection<SkinConfig> getSkins(Set<Map.Entry<SkinKey, SkinConfig>> portalSkins, Set<Map.Entry<SkinKey, SkinConfig>> skinConfigs) {
                HashSet<SkinConfig> list = new HashSet<SkinConfig>();
                for (Map.Entry<SkinKey, SkinConfig> entry : portalSkins) {
                    if (!entry.getKey().getModule().equals("Core")) continue;
                    list.add(entry.getValue());
                }
                return list;
            }
        });
        AbstractSkinServiceTest.assertNotNull((Object)portalSkinConfigs);
        AbstractSkinServiceTest.assertEquals((int)1, (int)portalSkinConfigs.size());
        SkinConfig[] arr = portalSkinConfigs.toArray(new SkinConfig[1]);
        SkinConfig portalSkin = arr[0];
        AbstractSkinServiceTest.assertNotNull((Object)portalSkin);
        AbstractSkinServiceTest.assertEquals((String)"Core", (String)portalSkin.getModule());
        AbstractSkinServiceTest.assertEquals((String)(contextPath + "/skin/core/Stylesheet.css"), (String)portalSkin.getCSSPath());
    }

    public void testPortletSkin() {
        SkinConfig portletSkin = this.skinService.getSkin("mockwebapp/FirstPortlet", "TestSkin");
        String contextPath = mockServletContext.getContextPath();
        AbstractSkinServiceTest.assertNotNull((Object)portletSkin);
        AbstractSkinServiceTest.assertNotNull((Object)portletSkin.getAdditionalModules());
        AbstractSkinServiceTest.assertEquals((int)1, (int)portletSkin.getAdditionalModules().size());
        AbstractSkinServiceTest.assertEquals((String)"AdditionalModule", (String)((String)portletSkin.getAdditionalModules().get(0)));
        AbstractSkinServiceTest.assertEquals((String)(contextPath + "/skin/FirstPortlet.css"), (String)portletSkin.getCSSPath());
        portletSkin = this.skinService.getSkin("mockwebapp/SecondPortlet", "TestSkin");
        AbstractSkinServiceTest.assertNotNull((Object)portletSkin);
        AbstractSkinServiceTest.assertNull((Object)portletSkin.getAdditionalModules());
        AbstractSkinServiceTest.assertEquals((String)(contextPath + "/skin/SecondPortlet.css"), (String)portletSkin.getCSSPath());
    }

    public void testThemes() {
        Map themeStyles = this.skinService.getPortletThemes();
        Set themes = (Set)themeStyles.get("Simple");
        AbstractSkinServiceTest.assertNotNull((Object)themes);
        AbstractSkinServiceTest.assertTrue((boolean)themes.contains("SimpleBlue"));
        AbstractSkinServiceTest.assertTrue((boolean)themes.contains("SimpleViolet"));
        AbstractSkinServiceTest.assertNotNull(themeStyles.get("VistaStyle"));
    }

    public void testExistingCSS() throws Exception {
        SkinURL skinURL = this.newSimpleSkin(mockServletContext.getContextPath() + "/skin/Stylesheet.css").createURL(this.controllerCtx);
        String css = this.skinService.getCSS(AbstractSkinServiceTest.newControllerContext(this.getRouter(), skinURL.toString()), false);
        AbstractSkinServiceTest.assertTrue((css.length() > 0 ? 1 : 0) != 0);
        skinURL.setOrientation(Orientation.RT);
        String uri = skinURL.toString();
        css = this.skinService.getCSS(AbstractSkinServiceTest.newControllerContext(this.getRouter(), uri), false);
        AbstractSkinServiceTest.assertTrue((css.length() > 0 ? 1 : 0) != 0);
    }

    public void testNonExistingCSS() throws Exception {
        SkinURL skinURL = this.newSimpleSkin("/non/existing/file.css").createURL(this.controllerCtx);
        String css = this.skinService.getCSS(AbstractSkinServiceTest.newControllerContext(this.getRouter(), skinURL.toString()), false);
        AbstractSkinServiceTest.assertNull((Object)css);
        skinURL.setOrientation(Orientation.RT);
        String uri = skinURL.toString();
        css = this.skinService.getCSS(AbstractSkinServiceTest.newControllerContext(this.getRouter(), uri), false);
        AbstractSkinServiceTest.assertNull((Object)css);
    }

    public void testProcessComment() throws Exception {
        String resource = "/process/comment/file.css";
        String css = "foo; /*background:url(bar.gif); Inline comment*//* Block comment\n   background:url(bar.gif);\n   End of block comment */";
        resResolver.addResource(resource, css);
        SkinURL skinURL = this.newSimpleSkin(resource).createURL(this.controllerCtx);
        AbstractSkinServiceTest.assertEquals((String)"foo;", (String)this.skinService.getCSS(AbstractSkinServiceTest.newControllerContext(this.getRouter(), skinURL.toString()), false));
    }

    public void testOrientation() throws Exception {
        String resource = "/orientation/file.css";
        SkinURL skinURL = this.newSimpleSkin(resource).createURL(this.controllerCtx);
        String uri = skinURL.toString();
        String css = "aaa;/*orientation=lt*/;\nbbb;/*orientation=rt*/\n aaa; /* orientation=lt */;\n bbb; /* orientation=rt */ \n{aaa;bbb;/*orientation=lt*/ccc;\nddd;/*orientation=rt*/}\n{aaa;/*orientation=lt*/\nbbb;}{ccc;\n/*orientation=rt*/ddd;}";
        resResolver.addResource(resource, css);
        AbstractSkinServiceTest.assertEquals((String)"aaa;/*orientation=lt*/;aaa; /* orientation=lt */;{aaa;bbb;/*orientation=lt*/ccc;{aaa;/*orientation=lt*/bbb;}{ccc;", (String)this.skinService.getCSS(AbstractSkinServiceTest.newControllerContext(this.getRouter(), uri), false).replaceAll("\n", ""));
        skinURL.setOrientation(Orientation.RT);
        uri = skinURL.toString();
        AbstractSkinServiceTest.assertEquals((String)"bbb;/*orientation=rt*/bbb; /* orientation=rt */ddd;/*orientation=rt*/}bbb;}{ccc;/*orientation=rt*/ddd;}", (String)this.skinService.getCSS(AbstractSkinServiceTest.newControllerContext(this.getRouter(), uri), false).replaceAll("\n", ""));
    }

    public void testBackgroundURL() throws Exception {
        String resource = "/background/url/file.css";
        String css = "background:url(images/foo.gif);\nbackground:url('/images/foo.gif');\naaa; background: #fff url('images/foo.gif') no-repeat center -614px; ccc;\nbackground-image: url(images/foo.gif), url(images/bar.gif);";
        resResolver.addResource(resource, css);
        SkinURL skinURL = this.newSimpleSkin(resource).createURL(this.controllerCtx);
        AbstractSkinServiceTest.assertEquals((String)"background:url(/background/url/images/foo.gif);\nbackground:url('/images/foo.gif');\naaa; background: #fff url('/background/url/images/foo.gif') no-repeat center -614px; ccc;\nbackground-image: url(/background/url/images/foo.gif), url(/background/url/images/bar.gif);", (String)this.skinService.getCSS(AbstractSkinServiceTest.newControllerContext(this.getRouter(), skinURL.toString()), false));
    }

    public void testFontFaceURL() throws Exception {
        String resource = "/fonts/url/file.css";
        String css = "src: local('foo'), url('fonts/foo.woff') format('woff'), format('truetype') url(fonts/bar.ttf);\nsrc: url('fonts/baz.eot');\nsrc:url('fonts/bat.svg#batFont');";
        resResolver.addResource(resource, css);
        SkinURL skinURL = this.newSimpleSkin(resource).createURL(this.controllerCtx);
        AbstractSkinServiceTest.assertEquals((String)"src: local('foo'), url('/fonts/url/fonts/foo.woff') format('woff'), format('truetype') url(/fonts/url/fonts/bar.ttf);\nsrc: url('/fonts/url/fonts/baz.eot');\nsrc:url('/fonts/url/fonts/bat.svg#batFont');", (String)this.skinService.getCSS(AbstractSkinServiceTest.newControllerContext(this.getRouter(), skinURL.toString()), false));
    }

    public void testCustomSkinKey() {
        this.skinService.addSkin("jcr/foo", "bar", "/path/to/customkey.css", -1, false);
        this.skinsToDelete.add(new SkinKey("jcr/foo", "bar"));
        SkinConfig skin = this.skinService.getSkin("foo", "bar");
        AbstractSkinServiceTest.assertNull((Object)skin);
        skin = this.skinService.getSkin("jcr/foo", "bar");
        AbstractSkinServiceTest.assertNotNull((Object)skin);
        AbstractSkinServiceTest.assertEquals((String)"/path/to/customkey.css", (String)skin.getCSSPath());
        Collection list = this.skinService.findSkins(new SkinVisitor(this){

            public Collection<SkinConfig> getSkins(Set<Map.Entry<SkinKey, SkinConfig>> portalSkins, Set<Map.Entry<SkinKey, SkinConfig>> skinConfigs) {
                HashSet<SkinConfig> list = new HashSet<SkinConfig>();
                for (Map.Entry<SkinKey, SkinConfig> entry : portalSkins) {
                    if (!entry.getKey().getModule().startsWith("jcr/")) continue;
                    list.add(entry.getValue());
                }
                for (Map.Entry<SkinKey, SkinConfig> entry : skinConfigs) {
                    if (!entry.getKey().getModule().startsWith("jcr/")) continue;
                    list.add(entry.getValue());
                }
                return list;
            }
        });
        AbstractSkinServiceTest.assertNotNull((Object)list);
        AbstractSkinServiceTest.assertEquals((int)1, (int)list.size());
        SkinConfig next = (SkinConfig)list.iterator().next();
        AbstractSkinServiceTest.assertEquals((String)"/path/to/customkey.css", (String)next.getCSSPath());
    }

    ControllerContext getControllerContext() {
        try {
            return AbstractSkinServiceTest.newControllerContext(this.getRouter());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The controller context is not initialized properly", e);
        }
    }

    public static ControllerContext newControllerContext(Router router) {
        return AbstractSkinServiceTest.newControllerContext(router, "/portal");
    }

    public static ControllerContext newControllerContext(Router router, String requestURI) {
        try {
            MockServletRequest request = new MockServletRequest(null, new URL("http://localhost" + requestURI), "/portal", null, false);
            String portalPath = request.getRequestURI().substring(request.getContextPath().length());
            Iterator matcher = router.matcher(portalPath, request.getParameterMap());
            Map parameters = null;
            if (matcher.hasNext()) {
                parameters = (Map)matcher.next();
            }
            return new ControllerContext(null, router, (HttpServletRequest)request, null, parameters);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public SimpleSkin newSimpleSkin(String uri) {
        return new SimpleSkin(this.skinService, "module", null, uri);
    }
}

