/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource.config.tasks;

import jakarta.servlet.ServletContext;
import org.exoplatform.portal.resource.SkinDependentManager;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.config.tasks.AbstractSkinModule;
import org.exoplatform.portal.resource.config.tasks.SkinConfigTask;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PortalSkinTask
extends AbstractSkinModule
implements SkinConfigTask {
    private String moduleName;
    protected boolean filtered;

    public PortalSkinTask() {
        super(null);
        this.overwrite = true;
    }

    @Override
    public void execute(SkinService skinService, ServletContext scontext) {
        int priority;
        if (this.moduleName == null || this.cssPath == null) {
            return;
        }
        if (this.skinName == null) {
            this.skinName = skinService.getDefaultSkin();
        }
        String contextPath = scontext.getContextPath();
        String fullCSSPath = contextPath + this.cssPath;
        try {
            priority = Integer.valueOf(this.cssPriority);
        }
        catch (Exception e) {
            priority = Integer.MAX_VALUE;
        }
        skinService.addPortalSkin(this.moduleName, this.skinName, fullCSSPath, priority, this.overwrite, this.filtered);
        this.updateSkinDependentManager(contextPath, this.moduleName, this.skinName);
    }

    @Override
    public void binding(Element elemt) {
        this.bindingCSSPath(elemt);
        this.bindingSkinName(elemt);
        this.bindingModuleName(elemt);
        this.bindingOverwrite(elemt);
        this.bindingCSSPriority(elemt);
        this.bindingFiltered(elemt);
    }

    private void bindingModuleName(Element element) {
        NodeList nodes = element.getElementsByTagName("skin-module");
        if (nodes == null || nodes.getLength() < 1) {
            return;
        }
        this.moduleName = nodes.item(0).getFirstChild().getNodeValue();
    }

    private void bindingFiltered(Element element) {
        NodeList nodes = element.getElementsByTagName("filtered");
        if (nodes == null || nodes.getLength() < 1) {
            return;
        }
        String isFiltered = nodes.item(0).getFirstChild().getNodeValue();
        this.setFiltered("true".equals(isFiltered));
    }

    private void updateSkinDependentManager(String webApp, String moduleName, String skinName) {
        SkinDependentManager.addPortalSkin(webApp, moduleName, skinName);
        SkinDependentManager.addSkinDeployedInApp(webApp, skinName);
        SkinDependentManager.addDependentAppToSkinName(skinName, webApp);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }
}

