/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.exoplatform.portal.resource.CommentBlockHandler;
import org.exoplatform.portal.resource.SkipCommentReader;

public class TestSkipCommentReader
extends TestCase {
    private SkipCommentReader skipCommentReader;

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
        if (this.skipCommentReader != null) {
            this.skipCommentReader.close();
        }
    }

    private void initiateReader(String relativePath) {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(relativePath);
        this.skipCommentReader = new SkipCommentReader((Reader)new InputStreamReader(in));
    }

    private void initiateReader(Reader reader) {
        this.skipCommentReader = new SkipCommentReader(reader);
    }

    public void testFirstCSSFile() throws IOException {
        this.initiateReader("skin/test_1.css");
        this.skipCommentReader.setCommentBlockHandler((CommentBlockHandler)new CommentBlockHandler.OrientationCommentBlockHandler());
        for (int i = 0; i < 30; ++i) {
            this.skipCommentReader.readLine();
            this.skipCommentReader.readLine();
        }
    }

    public void testSkipCommentBlock() throws IOException {
        StringReader reader = new StringReader("abcdefgh/* comment block */ijklmn");
        this.initiateReader(reader);
        String line = this.skipCommentReader.readLine();
        TestSkipCommentReader.assertEquals((String)"abcdefghijklmn", (String)line);
    }

    public void testSkipMultipleCommentBlocks() throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("1.abcdefgh/* comment block */ijklmn\n");
        builder.append("2.abcdefgh/* comment block */ijklmn\n");
        builder.append("3.abcdefgh/* comment block */ijklmn\n");
        builder.append("4.abcdefgh/* comment block */ijklmn\n");
        StringReader reader = new StringReader(builder.toString());
        this.initiateReader(reader);
        String line = this.skipCommentReader.readLine();
        TestSkipCommentReader.assertEquals((String)"1.abcdefghijklmn", (String)line);
        line = this.skipCommentReader.readLine();
        TestSkipCommentReader.assertEquals((String)"2.abcdefghijklmn", (String)line);
        line = this.skipCommentReader.readLine();
        TestSkipCommentReader.assertEquals((String)"3.abcdefghijklmn", (String)line);
        line = this.skipCommentReader.readLine();
        TestSkipCommentReader.assertEquals((String)"4.abcdefghijklmn", (String)line);
    }

    public void testSkipCommentBlocksWithHandler() throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("1.abcdefgh/* orientation=lt */ijklmn\n");
        builder.append("2.abcdefgh/* comment block */ijklmn\n");
        builder.append("3.abcdefgh/* orientation=rt */ijklmn\n");
        builder.append("4.abcdefgh/* comment block */ijklmn\n");
        StringReader reader = new StringReader(builder.toString());
        this.initiateReader(reader);
        this.skipCommentReader.setCommentBlockHandler((CommentBlockHandler)new CommentBlockHandler.OrientationCommentBlockHandler());
        String line = this.skipCommentReader.readLine();
        TestSkipCommentReader.assertEquals((String)"1.abcdefgh/* orientation=lt */ijklmn", (String)line);
        line = this.skipCommentReader.readLine();
        TestSkipCommentReader.assertEquals((String)"2.abcdefghijklmn", (String)line);
        line = this.skipCommentReader.readLine();
        TestSkipCommentReader.assertEquals((String)"3.abcdefgh/* orientation=rt */ijklmn", (String)line);
        line = this.skipCommentReader.readLine();
        TestSkipCommentReader.assertEquals((String)"4.abcdefghijklmn", (String)line);
    }

    public void testNumberOfCommingEscapes() throws IOException {
        String COMMENT_BLOCK = "/*COMMENT BLOCK*/";
        StringBuilder builder = new StringBuilder();
        builder.append(COMMENT_BLOCK).append("1.abcdefghijklmn\n");
        builder.append("2.abcdefghijklmn\n");
        builder.append("3.").append(COMMENT_BLOCK).append("abcdefghijklmn\n");
        StringReader reader = new StringReader(builder.toString());
        this.initiateReader(reader);
        this.skipCommentReader.setNumberOfCommingEscapes(COMMENT_BLOCK.length());
        String firstLine = this.skipCommentReader.readLine();
        TestSkipCommentReader.assertEquals((String)(COMMENT_BLOCK + "1.abcdefghijklmn"), (String)firstLine);
        String secondLine = this.skipCommentReader.readLine();
        TestSkipCommentReader.assertEquals((String)"2.abcdefghijklmn", (String)secondLine);
        this.skipCommentReader.setNumberOfCommingEscapes(2 + COMMENT_BLOCK.length());
        String thirdLine = this.skipCommentReader.readLine();
        TestSkipCommentReader.assertEquals((String)("3." + COMMENT_BLOCK + "abcdefghijklmn"), (String)thirdLine);
    }

    public void testCursorState() throws IOException {
        StringReader reader = new StringReader("0123456//*xxxx*/*789");
        this.initiateReader(reader);
        TestSkipCommentReader.assertEquals((Object)SkipCommentReader.State.ENCOUNTING_ORDINARY_CHARACTER, (Object)this.skipCommentReader.getCursorState());
        for (int i = 0; i < 7; ++i) {
            int readChar = this.skipCommentReader.readSingleCharacter();
            TestSkipCommentReader.assertEquals((Object)SkipCommentReader.State.ENCOUNTING_ORDINARY_CHARACTER, (Object)this.skipCommentReader.getCursorState());
        }
        this.skipCommentReader.readSingleCharacter();
        TestSkipCommentReader.assertEquals((Object)SkipCommentReader.State.ENCOUNTING_FORWARD_SLASH, (Object)this.skipCommentReader.getCursorState());
        this.skipCommentReader.readSingleCharacter();
        TestSkipCommentReader.assertEquals((Object)SkipCommentReader.State.ENCOUNTING_ASTERIK, (Object)this.skipCommentReader.getCursorState());
    }
}

