/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import jakarta.servlet.ServletContext;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.xml.DocumentSource;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.config.tasks.SkinConfigTask;
import org.exoplatform.portal.resource.config.xml.SkinConfigParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestGateInResourceParser {
    private static final String FILTERED_MODULE = "FilteredModule";
    private static final String SKIN_NAME = "Default";
    private static final String CONTEXT_PATH = "portal";
    @Mock
    private SkinService skinService;
    @Mock
    private ServletContext scontext;

    @Before
    public void setUp() {
        Mockito.when((Object)this.scontext.getContextPath()).thenReturn((Object)CONTEXT_PATH);
    }

    @Test
    public void testResources1() {
        this.assertDescriptorCanBeLoaded("org/exoplatform/portal/resource/gatein-resources-1_0.xml");
    }

    @Test
    public void testResources1WithSkinModule() {
        this.assertDescriptorCanBeLoaded("org/exoplatform/portal/resource/gatein-resources-1_0-with-skin-module.xml");
    }

    @Test
    public void testResources11() {
        this.assertDescriptorCanBeLoaded("org/exoplatform/portal/resource/gatein-resources-1_1.xml");
    }

    @Test
    public void testResources12() {
        this.assertDescriptorCanBeLoaded("org/exoplatform/portal/resource/gatein-resources-1_2.xml");
    }

    @Test
    public void testResources13() {
        this.assertDescriptorCanBeLoaded("org/exoplatform/portal/resource/gatein-resources-1_3.xml");
    }

    @Test
    public void testResources14() {
        this.assertDescriptorCanBeLoaded("org/exoplatform/portal/resource/gatein-resources-1_4.xml");
    }

    @Test
    public void testResources15() {
        List<SkinConfigTask> tasks = this.getTasks("org/exoplatform/portal/resource/gatein-resources-1_5.xml");
        Assert.assertFalse((boolean)tasks.isEmpty());
        Assert.assertEquals((long)5L, (long)tasks.size());
        tasks.forEach(skinConfigTask -> skinConfigTask.execute(this.skinService, this.scontext));
        ((SkinService)Mockito.verify((Object)this.skinService, (VerificationMode)Mockito.times((int)1))).addSkin((String)ArgumentMatchers.eq((Object)"web/BannerPortlet"), (String)ArgumentMatchers.eq((Object)SKIN_NAME), (String)ArgumentMatchers.argThat(s -> s.contains("/skin/portal/webui/component/UIBannerPortlet/DefaultStylesheet.css")), ArgumentMatchers.anyInt(), ArgumentMatchers.eq((boolean)false), (List)ArgumentMatchers.argThat(list -> CollectionUtils.isNotEmpty((Collection)list) && list.size() == 1 && list.contains(FILTERED_MODULE)));
        ((SkinService)Mockito.verify((Object)this.skinService, (VerificationMode)Mockito.times((int)1))).addSkin((String)ArgumentMatchers.eq((Object)"web/FooterPortlet"), (String)ArgumentMatchers.eq((Object)SKIN_NAME), (String)ArgumentMatchers.argThat(s -> s.contains("/skin/portal/webui/component/UIFooterPortlet/DefaultStylesheet.css")), ArgumentMatchers.anyInt(), ArgumentMatchers.eq((boolean)false), (List)ArgumentMatchers.argThat(CollectionUtils::isEmpty));
        ((SkinService)Mockito.verify((Object)this.skinService, (VerificationMode)Mockito.times((int)1))).addSkin((String)ArgumentMatchers.eq((Object)"web/NavigationPortlet"), (String)ArgumentMatchers.eq((Object)SKIN_NAME), (String)ArgumentMatchers.argThat(s -> s == null), ArgumentMatchers.anyInt(), ArgumentMatchers.eq((boolean)false), (List)ArgumentMatchers.argThat(list -> CollectionUtils.isNotEmpty((Collection)list) && list.size() == 1 && list.contains(FILTERED_MODULE)));
        ((SkinService)Mockito.verify((Object)this.skinService, (VerificationMode)Mockito.times((int)1))).addPortalSkin((String)ArgumentMatchers.eq((Object)"MyModule"), (String)ArgumentMatchers.eq((Object)SKIN_NAME), (String)ArgumentMatchers.argThat(s -> s.contains("/skin/Stylesheet.css")), ArgumentMatchers.anyInt(), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false));
        ((SkinService)Mockito.verify((Object)this.skinService, (VerificationMode)Mockito.times((int)1))).addPortalSkin((String)ArgumentMatchers.eq((Object)FILTERED_MODULE), (String)ArgumentMatchers.eq((Object)SKIN_NAME), (String)ArgumentMatchers.argThat(s -> s.contains("/skin/FilteredStylesheet.css")), ArgumentMatchers.anyInt(), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)true));
    }

    private List<SkinConfigTask> assertDescriptorCanBeLoaded(String descriptorPath) {
        List<SkinConfigTask> tasks = this.getTasks(descriptorPath);
        Assert.assertNotNull((String)"There are no tasks", tasks);
        Assert.assertEquals((long)8L, (long)tasks.size());
        return tasks;
    }

    private List<SkinConfigTask> getTasks(String descriptorPath) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(descriptorPath);
        Assert.assertNotNull((String)("The " + descriptorPath + " can not be found"), (Object)url);
        DocumentSource source = DocumentSource.create((URL)url);
        return SkinConfigParser.fetchTasks((DocumentSource)source);
    }
}

