/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.IOException;
import org.exoplatform.portal.resource.AbstractSkinServiceTest;
import org.exoplatform.portal.resource.SkinURL;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.metadata.ParamDescriptor;
import org.exoplatform.web.controller.metadata.RouteDescriptor;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.controller.router.RouterConfigException;

public class TestSkinServiceInDevelopingMode
extends AbstractSkinServiceTest {
    private static boolean isFirstStartup = true;

    @Override
    boolean isDevelopingMode() {
        return true;
    }

    @Override
    boolean setUpTestEnvironment() {
        return isFirstStartup;
    }

    @Override
    Router getRouter() {
        try {
            Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/skins/{gtn:version}/{gtn:resource}{gtn:compress}{gtn:orientation}.css").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"gtn:handler").withValue("skin")}).with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:version").matchedBy("[^/]*").preservePath()}).with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:orientation").matchedBy("-(lt)|-(rt)|").captureGroup(true)}).with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:compress").matchedBy("-(min)|").captureGroup(true)}).with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:resource").matchedBy(".+?").preservePath()})}).build();
            return router;
        }
        catch (RouterConfigException e) {
            return null;
        }
    }

    @Override
    void touchSetUp() {
        isFirstStartup = false;
    }

    public void testRenderURL() {
        SkinURL skinURL = this.skinService.getSkin("mockwebapp/FirstPortlet", "TestSkin").createURL();
        TestSkinServiceInDevelopingMode.assertEquals((String)"/mockwebapp/skin/FirstPortlet.css?orientation=LT&minify=false&hash=0", (String)skinURL.toString());
        skinURL.setOrientation(Orientation.RT);
        TestSkinServiceInDevelopingMode.assertEquals((String)"/mockwebapp/skin/FirstPortlet.css?orientation=RT&minify=false&hash=0", (String)skinURL.toString());
    }

    public void testGetSkinModuleFileContent() throws IOException {
        TestSkinServiceInDevelopingMode.assertEquals((String)".FirstPortlet {foo1 : bar1}", (String)this.skinService.getSkinModuleFileContent("/mockwebapp/skin/FirstPortlet.css"));
    }
}

