/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.xml.DocumentSource;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.component.test.web.ServletContextImpl;
import org.exoplatform.component.test.web.WebAppImpl;
import org.exoplatform.portal.resource.MockResourceResolver;
import org.exoplatform.portal.resource.ResourceResolver;
import org.exoplatform.portal.resource.SimpleSkin;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinKey;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.SkinVisitor;
import org.exoplatform.portal.resource.config.xml.SkinConfigParser;
import org.exoplatform.test.mocks.servlet.MockServletRequest;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.controller.router.Router;
import org.gatein.wci.WebApp;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/test-configuration.xml")})
public abstract class AbstractSkinServiceTest
extends AbstractKernelTest {
    private static final String MODULE1 = "Module1";
    private static final String MODULE3 = "Module3";
    private static final String MODULE2 = "Module2";
    private static final String MODULE1_CSS_PATH = "/skin/module1/Stylesheet.css";
    private static final String MODULE3_CSS_PATH = "/skin/module3/Stylesheet.css";
    private static final String MODULE2_CSS_PATH = "/skin/module2/Stylesheet.css";
    private static final String TEST_SKIN = "TestSkin";
    protected SkinService skinService;
    protected ControllerContext controllerCtx;
    protected List<SkinKey> skinsToDelete = new ArrayList<SkinKey>();
    private static ServletContext mockServletContext;
    protected static MockResourceResolver resResolver;

    abstract boolean isDevelopingMode();

    abstract Router getRouter();

    abstract boolean setUpTestEnvironment();

    abstract void touchSetUp();

    protected void setUp() throws Exception {
        this.skinService = (SkinService)this.getContainer().getComponentInstanceOfType(SkinService.class);
        this.skinService.setDeveloping(this.isDevelopingMode());
        SimpleSkin.setDeveloping((boolean)this.isDevelopingMode());
        this.controllerCtx = this.getControllerContext();
        if (this.setUpTestEnvironment()) {
            URL base = AbstractSkinServiceTest.class.getClassLoader().getResource("mockwebapp");
            File f = new File(base.toURI());
            AbstractSkinServiceTest.assertTrue((boolean)f.exists());
            AbstractSkinServiceTest.assertTrue((boolean)f.isDirectory());
            mockServletContext = new ServletContextImpl(f, "/mockwebapp", "mockwebapp");
            this.skinService.registerContext((WebApp)new WebAppImpl(mockServletContext, Thread.currentThread().getContextClassLoader()));
            resResolver = new MockResourceResolver();
            this.skinService.addResourceResolver((ResourceResolver)resResolver);
            URL url = mockServletContext.getResource("/gatein-resources.xml");
            SkinConfigParser.processConfigResource((DocumentSource)DocumentSource.create((URL)url), (SkinService)this.skinService, (ServletContext)mockServletContext);
            URL baseTest = AbstractSkinServiceTest.class.getClassLoader().getResource("mockwebapp-test");
            File fTest = new File(baseTest.toURI());
            AbstractSkinServiceTest.assertTrue((boolean)fTest.exists());
            AbstractSkinServiceTest.assertTrue((boolean)fTest.isDirectory());
            ServletContextImpl mockServletContextTest = new ServletContextImpl(fTest, "/mockwebapp-test", "mockwebapp-test");
            this.skinService.registerContext((WebApp)new WebAppImpl((ServletContext)mockServletContextTest, Thread.currentThread().getContextClassLoader()));
            MockResourceResolver resResolverTest = new MockResourceResolver();
            this.skinService.addResourceResolver((ResourceResolver)resResolverTest);
            URL urlTest = mockServletContextTest.getResource("/gatein-resources.xml");
            SkinConfigParser.processConfigResource((DocumentSource)DocumentSource.create((URL)urlTest), (SkinService)this.skinService, (ServletContext)mockServletContextTest);
            this.touchSetUp();
        }
    }

    protected void tearDown() throws Exception {
        resResolver.reset();
        for (SkinKey key : this.skinsToDelete) {
            this.skinService.removeSupportedSkin(key.getName());
            this.skinService.removeSkin(key);
        }
        this.skinsToDelete.clear();
        this.skinService.reloadSkins();
    }

    public void testInitializing() throws Exception {
        AbstractSkinServiceTest.assertEquals((int)3, (int)this.skinService.getAvailableSkinNames().size());
        AbstractSkinServiceTest.assertTrue((boolean)this.skinService.getAvailableSkinNames().contains(TEST_SKIN));
        AbstractSkinServiceTest.assertTrue((boolean)this.skinService.mainResolver.resolvers.contains(resResolver));
    }

    public void testPortalSkin() {
        String contextPath = mockServletContext.getContextPath();
        SkinConfig portalSkin = this.skinService.getPortalSkin(MODULE1, TEST_SKIN);
        AbstractSkinServiceTest.assertNotNull((Object)portalSkin);
        AbstractSkinServiceTest.assertEquals((String)MODULE1, (String)portalSkin.getModule());
        AbstractSkinServiceTest.assertEquals((String)(contextPath + MODULE1_CSS_PATH), (String)portalSkin.getCSSPath());
        portalSkin = this.skinService.getPortalSkin(MODULE2, TEST_SKIN);
        AbstractSkinServiceTest.assertNotNull((Object)portalSkin);
        AbstractSkinServiceTest.assertEquals((String)MODULE2, (String)portalSkin.getModule());
        AbstractSkinServiceTest.assertEquals((String)(contextPath + MODULE2_CSS_PATH), (String)portalSkin.getCSSPath());
        portalSkin = this.skinService.getPortalSkin(MODULE3, TEST_SKIN);
        AbstractSkinServiceTest.assertNotNull((Object)portalSkin);
        AbstractSkinServiceTest.assertEquals((String)MODULE3, (String)portalSkin.getModule());
        AbstractSkinServiceTest.assertEquals((String)(contextPath + MODULE3_CSS_PATH), (String)portalSkin.getCSSPath());
        portalSkin = this.skinService.getPortalSkin(MODULE1, TEST_SKIN);
        AbstractSkinServiceTest.assertNotNull((Object)portalSkin);
        AbstractSkinServiceTest.assertEquals((String)MODULE1, (String)portalSkin.getModule());
        AbstractSkinServiceTest.assertEquals((String)(contextPath + MODULE1_CSS_PATH), (String)portalSkin.getCSSPath());
    }

    public void testRemovePortalSkin() {
        String skinName = TEST_SKIN;
        String module = "ToDeletePortalSkin";
        String cssPath = mockServletContext.getContextPath() + "/skin/core/Stylesheet.css";
        SkinConfig portalSkin = this.skinService.getPortalSkin(module, skinName);
        AbstractSkinServiceTest.assertNull((Object)portalSkin);
        this.skinService.addPortalSkin(module, skinName, cssPath);
        portalSkin = this.skinService.getPortalSkin(module, skinName);
        AbstractSkinServiceTest.assertNotNull((Object)portalSkin);
        AbstractSkinServiceTest.assertEquals((String)cssPath, (String)portalSkin.getCSSPath());
        this.skinService.removePortalSkin(module, skinName);
        portalSkin = this.skinService.getPortalSkin(module, skinName);
        AbstractSkinServiceTest.assertNull((Object)portalSkin);
    }

    public void testPortalSkinAndPriority() {
        Collection portalSkinConfigs = this.skinService.getPortalSkins(TEST_SKIN);
        String contextPath = mockServletContext.getContextPath();
        AbstractSkinServiceTest.assertNotNull((Object)portalSkinConfigs);
        AbstractSkinServiceTest.assertEquals((int)3, (int)portalSkinConfigs.size());
        SkinConfig[] array = new SkinConfig[4];
        portalSkinConfigs.toArray(array);
        SkinConfig portalSkin = array[0];
        AbstractSkinServiceTest.assertNotNull((Object)portalSkin);
        AbstractSkinServiceTest.assertEquals((String)MODULE2, (String)portalSkin.getModule());
        AbstractSkinServiceTest.assertEquals((String)(contextPath + MODULE2_CSS_PATH), (String)portalSkin.getCSSPath());
        portalSkin = array[1];
        AbstractSkinServiceTest.assertNotNull((Object)portalSkin);
        AbstractSkinServiceTest.assertEquals((String)MODULE3, (String)portalSkin.getModule());
        AbstractSkinServiceTest.assertEquals((String)(contextPath + MODULE3_CSS_PATH), (String)portalSkin.getCSSPath());
        portalSkin = array[2];
        AbstractSkinServiceTest.assertNotNull((Object)portalSkin);
        AbstractSkinServiceTest.assertEquals((String)MODULE1, (String)portalSkin.getModule());
        AbstractSkinServiceTest.assertEquals((String)(contextPath + MODULE1_CSS_PATH), (String)portalSkin.getCSSPath());
    }

    public void testPortalSkinVisitor() {
        String contextPath = mockServletContext.getContextPath();
        Collection portalSkinConfigs = this.skinService.findSkins(new SkinVisitor(this){

            public Collection<SkinConfig> getSkins(Set<Map.Entry<SkinKey, SkinConfig>> portalSkins, Set<Map.Entry<SkinKey, SkinConfig>> skinConfigs) {
                HashSet<SkinConfig> list = new HashSet<SkinConfig>();
                for (Map.Entry<SkinKey, SkinConfig> entry : portalSkins) {
                    if (!entry.getKey().getModule().equals("Core")) continue;
                    list.add(entry.getValue());
                }
                return list;
            }
        });
        AbstractSkinServiceTest.assertNotNull((Object)portalSkinConfigs);
        AbstractSkinServiceTest.assertEquals((int)0, (int)portalSkinConfigs.size());
        portalSkinConfigs = this.skinService.findSkins(new SkinVisitor(this){

            public Collection<SkinConfig> getSkins(Set<Map.Entry<SkinKey, SkinConfig>> portalSkins, Set<Map.Entry<SkinKey, SkinConfig>> skinConfigs) {
                HashSet<SkinConfig> list = new HashSet<SkinConfig>();
                for (Map.Entry<SkinKey, SkinConfig> entry : portalSkins) {
                    if (!entry.getKey().getModule().equals(AbstractSkinServiceTest.MODULE1)) continue;
                    list.add(entry.getValue());
                }
                return list;
            }
        });
        AbstractSkinServiceTest.assertNotNull((Object)portalSkinConfigs);
        AbstractSkinServiceTest.assertEquals((int)1, (int)portalSkinConfigs.size());
        SkinConfig[] arr = portalSkinConfigs.toArray(new SkinConfig[1]);
        SkinConfig portalSkin = arr[0];
        AbstractSkinServiceTest.assertNotNull((Object)portalSkin);
        AbstractSkinServiceTest.assertEquals((String)MODULE1, (String)portalSkin.getModule());
        AbstractSkinServiceTest.assertEquals((String)(contextPath + MODULE1_CSS_PATH), (String)portalSkin.getCSSPath());
    }

    public void testPortletSkin() {
        SkinConfig portletSkin = this.skinService.getSkin("mockwebapp/FirstPortlet", TEST_SKIN);
        String contextPath = mockServletContext.getContextPath();
        AbstractSkinServiceTest.assertNotNull((Object)portletSkin);
        AbstractSkinServiceTest.assertNotNull((Object)portletSkin.getAdditionalModules());
        AbstractSkinServiceTest.assertEquals((int)1, (int)portletSkin.getAdditionalModules().size());
        AbstractSkinServiceTest.assertEquals((String)"AdditionalModule", (String)((String)portletSkin.getAdditionalModules().get(0)));
        AbstractSkinServiceTest.assertEquals((String)(contextPath + "/skin/FirstPortlet.css"), (String)portletSkin.getCSSPath());
        portletSkin = this.skinService.getSkin("mockwebapp/SecondPortlet", TEST_SKIN);
        AbstractSkinServiceTest.assertNotNull((Object)portletSkin);
        AbstractSkinServiceTest.assertTrue((boolean)CollectionUtils.isEmpty((Collection)portletSkin.getAdditionalModules()));
        AbstractSkinServiceTest.assertEquals((String)(contextPath + "/skin/SecondPortlet.css"), (String)portletSkin.getCSSPath());
    }

    public void testThemes() {
        Map themeStyles = this.skinService.getPortletThemes();
        Set themes = (Set)themeStyles.get("Simple");
        AbstractSkinServiceTest.assertNotNull((Object)themes);
        AbstractSkinServiceTest.assertTrue((boolean)themes.contains("SimpleBlue"));
        AbstractSkinServiceTest.assertTrue((boolean)themes.contains("SimpleViolet"));
        AbstractSkinServiceTest.assertNotNull(themeStyles.get("VistaStyle"));
    }

    public void testCustomSkinKey() {
        this.skinService.addSkin("jcr/foo", "bar", "/path/to/customkey.css", -1, false);
        this.skinsToDelete.add(new SkinKey("jcr/foo", "bar"));
        SkinConfig skin = this.skinService.getSkin("foo", "bar");
        AbstractSkinServiceTest.assertNull((Object)skin);
        skin = this.skinService.getSkin("jcr/foo", "bar");
        AbstractSkinServiceTest.assertNotNull((Object)skin);
        AbstractSkinServiceTest.assertEquals((String)"/path/to/customkey.css", (String)skin.getCSSPath());
        Collection list = this.skinService.findSkins(new SkinVisitor(this){

            public Collection<SkinConfig> getSkins(Set<Map.Entry<SkinKey, SkinConfig>> portalSkins, Set<Map.Entry<SkinKey, SkinConfig>> skinConfigs) {
                HashSet<SkinConfig> list = new HashSet<SkinConfig>();
                for (Map.Entry<SkinKey, SkinConfig> entry : portalSkins) {
                    if (!entry.getKey().getModule().startsWith("jcr/")) continue;
                    list.add(entry.getValue());
                }
                for (Map.Entry<SkinKey, SkinConfig> entry : skinConfigs) {
                    if (!entry.getKey().getModule().startsWith("jcr/")) continue;
                    list.add(entry.getValue());
                }
                return list;
            }
        });
        AbstractSkinServiceTest.assertNotNull((Object)list);
        AbstractSkinServiceTest.assertEquals((int)1, (int)list.size());
        SkinConfig next = (SkinConfig)list.iterator().next();
        AbstractSkinServiceTest.assertEquals((String)"/path/to/customkey.css", (String)next.getCSSPath());
    }

    ControllerContext getControllerContext() {
        try {
            return AbstractSkinServiceTest.newControllerContext(this.getRouter());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The controller context is not initialized properly", e);
        }
    }

    public static ControllerContext newControllerContext(Router router) {
        return AbstractSkinServiceTest.newControllerContext(router, "/portal");
    }

    public static ControllerContext newControllerContext(Router router, String requestURI) {
        try {
            MockServletRequest request = new MockServletRequest(null, new URL("http://localhost/portal" + requestURI), "/portal", null, false);
            String portalPath = request.getRequestURI().substring(request.getContextPath().length());
            Iterator matcher = router.matcher(portalPath, request.getParameterMap());
            Map parameters = null;
            if (matcher.hasNext()) {
                parameters = (Map)matcher.next();
            }
            return new ControllerContext(null, router, (HttpServletRequest)request, null, parameters);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

