/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.exoplatform.commons.utils.BinaryOutput;
import org.exoplatform.portal.resource.AbstractSkinServiceTest;
import org.exoplatform.portal.resource.ResourceRenderer;
import org.exoplatform.portal.resource.SkinResourceRequestHandler;
import org.exoplatform.portal.resource.SkinURL;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.test.mocks.servlet.MockHttpServletResponse;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.metadata.ParamDescriptor;
import org.exoplatform.web.controller.metadata.RouteDescriptor;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.controller.router.RouterConfigException;

public class TestSkinService
extends AbstractSkinServiceTest {
    private static boolean isFirstStartup = true;

    @Override
    boolean isDevelopingMode() {
        return false;
    }

    @Override
    boolean setUpTestEnvironment() {
        return isFirstStartup;
    }

    @Override
    Router getRouter() {
        try {
            Router router = DescriptorBuilder.router().add(new RouteDescriptor[]{DescriptorBuilder.route((String)"/skins/{gtn:version}/{gtn:resource}{gtn:compress}{gtn:orientation}.css").with(new ParamDescriptor[]{DescriptorBuilder.routeParam((String)"gtn:handler").withValue("skin")}).with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:version").matchedBy("[^/]*").preservePath()}).with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:orientation").matchedBy("-(lt)|-(rt)|").captureGroup(true)}).with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:compress").matchedBy("-(min)|").captureGroup(true)}).with(new ParamDescriptor[]{DescriptorBuilder.pathParam((String)"gtn:resource").matchedBy(".+?").preservePath()})}).build();
            return router;
        }
        catch (RouterConfigException e) {
            return null;
        }
    }

    @Override
    void touchSetUp() {
        isFirstStartup = false;
    }

    public void testRenderCss() throws IOException {
        final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BinaryOutput output = new BinaryOutput(){

            public Charset getCharset() {
                return StandardCharsets.UTF_8;
            }

            public void write(byte b) throws IOException {
                outputStream.write(b);
            }

            public void write(byte[] bytes) throws IOException {
                outputStream.write(bytes);
            }

            public void write(byte[] bytes, int off, int len) throws IOException {
                outputStream.write(bytes, off, len);
            }
        };
        ControllerContext controllerContext = TestSkinService.newControllerContext(this.getRouter(), "/skins/7.0/mockwebapp/skin/FirstPortlet-min-lt.css");
        SkinResourceRequestHandler.SkinResourceRenderer renderer = new SkinResourceRequestHandler.SkinResourceRenderer((HttpServletResponse)new MockHttpServletResponse(), controllerContext, output);
        TestSkinService.assertTrue((boolean)this.skinService.renderCSS(controllerContext, (ResourceRenderer)renderer, true));
        String result = outputStream.toString();
        TestSkinService.assertEquals((String)".FirstPortlet {foo1 : bar1}", (String)result);
    }

    public void testGetCustomPortalSkins() {
        Collection customSkins = this.skinService.getCustomPortalSkins("TestSkin");
        TestSkinService.assertNotNull((Object)customSkins);
        TestSkinService.assertEquals((int)0, (int)customSkins.size());
        customSkins = this.skinService.getCustomPortalSkins("OtherSkin");
        TestSkinService.assertNotNull((Object)customSkins);
        TestSkinService.assertEquals((int)1, (int)customSkins.size());
    }

    public void testGetSkinList() {
        String[] skinList = this.skinService.getSkinList();
        TestSkinService.assertNotNull((Object)skinList);
        TestSkinService.assertEquals((int)3, (int)skinList.length);
    }

    public void testRenderURL() {
        SkinURL skinURL = this.skinService.getSkin("mockwebapp/FirstPortlet", "TestSkin").createURL();
        TestSkinService.assertEquals((String)"/mockwebapp/skin/FirstPortlet.css?orientation=LT&minify=true&hash=1107379639", (String)skinURL.toString());
        skinURL.setOrientation(Orientation.RT);
        TestSkinService.assertEquals((String)"/mockwebapp/skin/FirstPortlet.css?orientation=RT&minify=true&hash=1107379639", (String)skinURL.toString());
    }

    public void testGetSkinModuleFileContent() throws IOException {
        TestSkinService.assertEquals((String)".FirstPortlet {foo1 : bar1}", (String)this.skinService.getSkinModuleFileContent("/mockwebapp/skin/FirstPortlet.css"));
        TestSkinService.assertEquals((String)".ThirdPortlet {foo1 : bar1}\n", (String)this.skinService.getSkinModuleFileContent("/mockwebapp-test/skin/ThirdPortlet.css"));
    }

    public void testGetSkinModuleContent() throws IOException {
        TestSkinService.assertEquals((String)".FirstPortlet {foo1 : bar1}", (String)this.skinService.getSkinModuleContent("/mockwebapp/skin/FirstPortlet.css", 0, Orientation.LT, true));
    }
}

