/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.portal.resource.Resource;
import org.exoplatform.portal.resource.ResourceResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

class MockResourceResolver
implements ResourceResolver {
    private final Log log = ExoLogger.getLogger(MockResourceResolver.class);
    private Map<String, String> map = new HashMap<String, String>();

    public MockResourceResolver() {
        this.addResource("/path/to/MockResourceResolver.css", this.getClass().getName());
    }

    public void addResource(String path, String value) {
        this.map.put(path, value);
    }

    public String removeResource(String path) {
        return this.map.remove(path);
    }

    public Resource resolve(String path) throws NullPointerException {
        if (path == null) {
            throw new NullPointerException("No null path is accepted");
        }
        this.log.info((Object)("path to resolve : " + path));
        final String css = this.map.get(path);
        if (css != null) {
            return new Resource(this, path){

                public Reader read() {
                    return new StringReader(css);
                }
            };
        }
        return null;
    }

    public void reset() {
        this.map.clear();
    }
}

