/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.errorlogin;

import org.exoplatform.commons.utils.Safe;
import org.exoplatform.web.security.errorlogin.InvalidLoginPolicy;

class InvalidAttemptKey {
    private final String sessionId;
    private final String username;
    private final String hostname;

    private InvalidAttemptKey(String sessionId, String username, String hostname) {
        this.sessionId = sessionId;
        this.username = username;
        this.hostname = hostname;
    }

    public static InvalidAttemptKey createKey(InvalidLoginPolicy policy, String sessionId, String username, String hostname) {
        switch (policy) {
            case SESSION: {
                return new InvalidAttemptKey(sessionId, null, null);
            }
            case SESSION_AND_USER: {
                return new InvalidAttemptKey(sessionId, username, null);
            }
            case SERVER: {
                return new InvalidAttemptKey(null, null, hostname);
            }
        }
        throw new IllegalArgumentException("Non-expected value of InvalidLoginPolicy.");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof InvalidAttemptKey) {
            InvalidAttemptKey that = (InvalidAttemptKey)obj;
            return Safe.equals((Object)this.sessionId, (Object)that.sessionId) && Safe.equals((Object)this.username, (Object)that.username) && Safe.equals((Object)this.hostname, (Object)that.hostname);
        }
        return false;
    }

    public int hashCode() {
        int result = 1234567;
        if (this.sessionId != null) {
            result = this.sessionId.hashCode();
        }
        if (this.username != null) {
            result ^= this.username.hashCode();
        }
        if (this.hostname != null) {
            result ^= this.hostname.hashCode();
        }
        return result;
    }
}

