/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.hash;

import java.util.HashMap;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.web.security.hash.Argon2IdPasswordEncoder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.AttributesManager;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.common.exception.IdentityException;

@RunWith(value=MockitoJUnitRunner.class)
public class Argon2IdPasswordEncoderTest
extends AbstractKernelTest {
    private Argon2IdPasswordEncoder argon2IdPasswordEncoder;

    @Before
    public void setUp() throws Exception {
        System.setProperty("credentialEncoder.secureRandomAlgorithm", "SHA1PRNG");
        this.argon2IdPasswordEncoder = new Argon2IdPasswordEncoder();
        this.argon2IdPasswordEncoder.initialize(new HashMap(), null);
    }

    @Test
    public void testEncodeCredential() throws IdentityException {
        IdentitySession identitySession = (IdentitySession)Mockito.mock(IdentitySession.class);
        AttributesManager attributesManager = (AttributesManager)Mockito.mock(AttributesManager.class);
        Attribute saltAttribute = (Attribute)Mockito.mock(Attribute.class);
        Mockito.when((Object)attributesManager.getAttribute("user", "passwordSalt128")).thenReturn(null, (Object[])new Attribute[]{saltAttribute});
        Mockito.when((Object)identitySession.getAttributesManager()).thenReturn((Object)attributesManager);
        this.argon2IdPasswordEncoder.setIdentitySession(identitySession);
        String hash = this.argon2IdPasswordEncoder.encodeCredential("user", "Password1234");
        Argon2IdPasswordEncoderTest.assertNotNull((Object)hash);
        Mockito.when((Object)saltAttribute.getValue()).thenReturn((Object)"7f33a8dddac20d3b2b8e058be59d1a36");
        String storedHash = this.argon2IdPasswordEncoder.encodeCredential("user", "Password1234");
        Argon2IdPasswordEncoderTest.assertNotNull((Object)storedHash);
    }
}

