/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.spring.rest.test;

import io.meeds.spring.module.rest.TestController;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={TestController.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@RunWith(value=SpringRunner.class)
public class SpringRestIntegrationTest {
    private static final String ANONYMOUS_ENDPOINT = "/test/anonymous";
    private static final String USERS_ENDPOINT = "/test/users";
    private static final String ADMINISTRATORS_ENDPOINT = "/test/administrators";
    private static final String ADMIN_USER = "admin";
    private static final String SIMPLE_USER = "simple";
    private static final String TEST_PASSWORD = "testPassword";
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;

    @Before
    public void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    public void adminAccessAdminEndpoint() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)ADMINISTRATORS_ENDPOINT, (Object[])new Object[0]).with(this.testAdminUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void adminAccessUserEndpoint() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)USERS_ENDPOINT, (Object[])new Object[0]).with(this.testAdminUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void adminAccessAnonymousEndpoint() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)ANONYMOUS_ENDPOINT, (Object[])new Object[0]).with(this.testAdminUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void userAccessUserEndpoint() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)USERS_ENDPOINT, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void userAccessAdminEndpoint() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)ADMINISTRATORS_ENDPOINT, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void userAccessAnonymousEndpoint() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)ANONYMOUS_ENDPOINT, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    public void anonymousAccessUserEndpoint() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)USERS_ENDPOINT, (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void anonymousAccessAdminEndpoint() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)ADMINISTRATORS_ENDPOINT, (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    public void anonymousAccessAnonymousEndpoint() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)ANONYMOUS_ENDPOINT, (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    private RequestPostProcessor testAdminUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)ADMIN_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("administrators")});
    }

    private RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }
}

