/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.web.security.filter;

import io.meeds.web.security.plugin.RootWebappFilterPlugin;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.exoplatform.container.PortalContainer;

public class RootWebappFilter
extends HttpFilter {
    private static final long serialVersionUID = -1644590354419007074L;
    private List<RootWebappFilterPlugin> rootWebappFilterPlugins;

    protected void doFilter(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain chain) throws IOException, ServletException {
        RootWebappFilterPlugin rootWebappFilterPlugin = this.getRootWebappFilterPlugins().stream().filter(p -> p.matches(httpRequest, httpResponse)).findFirst().orElse(null);
        if (rootWebappFilterPlugin == null) {
            super.doFilter(httpRequest, httpResponse, chain);
        } else {
            rootWebappFilterPlugin.doFilter(httpRequest, httpResponse, chain);
        }
    }

    public List<RootWebappFilterPlugin> getRootWebappFilterPlugins() {
        if (this.rootWebappFilterPlugins == null) {
            this.rootWebappFilterPlugins = PortalContainer.getInstance().getComponentInstancesOfType(RootWebappFilterPlugin.class);
            if (this.rootWebappFilterPlugins == null) {
                this.rootWebappFilterPlugins = Collections.emptyList();
            }
        }
        return this.rootWebappFilterPlugins;
    }
}

