/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login.onboarding;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import nl.captcha.Captcha;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.resources.impl.LocaleConfigImpl;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.login.onboarding.OnboardingHandler;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.gatein.wci.security.Credentials;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class OnboardingHandlerTest {
    private static final Locale REQUEST_LOCALE = Locale.ENGLISH;
    private static final String CONTEXT_PATH = "/portal";
    private static final String TOKEN_VALUE = "tokenValue";
    private static final String USERNAME = "username";
    private static final String CAPTCHA_VALUE = "captchaValue";
    @Mock
    private ServletContext servletContext;
    @Mock
    private PortalContainer container;
    @Mock
    private PasswordRecoveryService passwordRecoveryService;
    @Mock
    private ResourceBundleService resourceBundleService;
    @Mock
    private ResourceBundle resourceBundle;
    @Mock
    private OrganizationService organizationService;
    @Mock
    private UserHandler userHandler;
    @Mock
    private LocaleConfigService localeConfigService;
    @Mock
    private BrandingService brandingService;
    @Mock
    private JavascriptConfigService javascriptConfigService;
    @Mock
    private WebAppController controller;
    @Mock
    private Router router;
    @Mock
    private HttpSession session;
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Mock
    private RequestDispatcher requestDispatcher;
    @Mock
    private SkinService skinService;
    @Mock
    private Captcha captcha;
    @Mock
    private Credentials credentials;
    private ControllerContext controllerContext;
    private OnboardingHandler onboardingHandler;

    @Before
    public void setUp() throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        Mockito.lenient().when((Object)((ResourceBundleService)this.container.getComponentInstanceOfType(ResourceBundleService.class))).thenReturn((Object)this.resourceBundleService);
        Mockito.when((Object)this.container.getPortalContext()).thenReturn((Object)this.servletContext);
        Mockito.when((Object)this.request.getContextPath()).thenReturn((Object)CONTEXT_PATH);
        Mockito.when((Object)this.servletContext.getContextPath()).thenReturn((Object)CONTEXT_PATH);
        Mockito.when((Object)this.request.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getAttribute("on-boarding")).thenReturn((Object)this.captcha);
        Mockito.when((Object)this.captcha.isCorrect(CAPTCHA_VALUE)).thenReturn((Object)true);
        Mockito.when((Object)this.request.getParameter("captcha")).thenReturn((Object)CAPTCHA_VALUE);
        Mockito.when((Object)this.request.getLocale()).thenReturn((Object)REQUEST_LOCALE);
        LocaleConfigImpl localeConfig = new LocaleConfigImpl();
        localeConfig.setLocale(REQUEST_LOCALE);
        Mockito.when((Object)this.resourceBundleService.getSharedResourceBundleNames()).thenReturn((Object)new String[0]);
        Mockito.when((Object)this.resourceBundleService.getResourceBundle((String[])ArgumentMatchers.any(String[].class), (Locale)ArgumentMatchers.eq((Object)REQUEST_LOCALE))).thenReturn((Object)this.resourceBundle);
        Mockito.when((Object)this.resourceBundle.getString(ArgumentMatchers.anyString())).thenAnswer(invocation -> invocation.getArgument(0));
        ServletOutputStream outputStream = new ServletOutputStream(this){

            public void write(int b) throws IOException {
            }

            public boolean isReady() {
                return false;
            }

            public void setWriteListener(WriteListener writeListener) {
            }
        };
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)outputStream);
        final int[] responseStatus = new int[]{0};
        Mockito.when((Object)this.response.getStatus()).thenAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocation) throws Throwable {
                return responseStatus[0];
            }
        });
        ((HttpServletResponse)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                int status;
                Object[] args = invocation.getArguments();
                responseStatus[0] = status = ((Integer)args[0]).intValue();
                return null;
            }
        }).when((Object)this.response)).setStatus(ArgumentMatchers.anyInt());
        final HashMap requestAttributes = new HashMap();
        Mockito.when((Object)this.request.getAttribute(ArgumentMatchers.anyString())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                String key = (String)args[0];
                return requestAttributes.get(key);
            }
        });
        Mockito.when((Object)this.request.getAttributeNames()).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                return Collections.enumeration(requestAttributes.keySet());
            }
        });
        ((HttpServletRequest)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                String key = (String)args[0];
                Object value = args[1];
                requestAttributes.put(key, value);
                return null;
            }
        }).when((Object)this.request)).setAttribute(ArgumentMatchers.anyString(), ArgumentMatchers.any());
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.passwordRecoveryService.verifyToken(TOKEN_VALUE, "onboard")).thenReturn((Object)USERNAME);
        this.onboardingHandler = new OnboardingHandler(this.container, this.passwordRecoveryService, this.resourceBundleService, this.organizationService, this.localeConfigService, this.brandingService, this.javascriptConfigService, this.skinService);
    }

    @After
    public void teardown() {
        ExoContainerContext.setCurrentContainer(null);
    }

    @Test
    public void testGetRequiresLifeCycle() {
        Assert.assertTrue((boolean)this.onboardingHandler.getRequiresLifeCycle());
    }

    @Test
    public void testGetHandlerName() {
        Assert.assertEquals((Object)"on-boarding", (Object)this.onboardingHandler.getHandlerName());
    }

    @Test
    public void testDisplayTokenExpiredPage() throws Exception {
        this.prepareResetPasswordContext();
        Mockito.reset((Object[])new PasswordRecoveryService[]{this.passwordRecoveryService});
        this.onboardingHandler.execute(this.controllerContext);
        Assert.assertFalse((boolean)Collections.list(this.controllerContext.getRequest().getAttributeNames()).contains("error"));
        Assert.assertEquals((Object)"expired", (Object)this.controllerContext.getRequest().getAttribute("action"));
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    @Test
    public void testDisplayOnboardingPage() throws Exception {
        this.prepareResetPasswordContext();
        this.onboardingHandler.execute(this.controllerContext);
        Assert.assertEquals((Object)USERNAME, (Object)this.controllerContext.getRequest().getAttribute(USERNAME));
        Assert.assertEquals((Object)TOKEN_VALUE, (Object)this.controllerContext.getRequest().getAttribute("tokenId"));
        Assert.assertEquals((Object)"resetPassword", (Object)this.controllerContext.getRequest().getAttribute("action"));
        Assert.assertFalse((boolean)Collections.list(this.controllerContext.getRequest().getAttributeNames()).contains("error"));
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    @Test
    public void testDisplayOnboardingUserNotMatch() throws Exception {
        this.prepareResetPasswordContext();
        String password = "pass1";
        String passwordConfirm = "pass2";
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"resetPassword");
        Mockito.when((Object)this.request.getParameter(USERNAME)).thenReturn((Object)"user2");
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)password);
        Mockito.when((Object)this.request.getParameter("password2")).thenReturn((Object)passwordConfirm);
        this.onboardingHandler.execute(this.controllerContext);
        Assert.assertEquals((long)400L, (long)this.controllerContext.getResponse().getStatus());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    @Test
    public void testDisplayOnboardingWhenBothPasswordsNotMatch() throws Exception {
        this.prepareResetPasswordContext();
        String password = "pass1";
        String passwordConfirm = "pass2";
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"resetPassword");
        Mockito.when((Object)this.request.getParameter(USERNAME)).thenReturn((Object)USERNAME);
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)password);
        Mockito.when((Object)this.request.getParameter("password2")).thenReturn((Object)passwordConfirm);
        this.onboardingHandler.execute(this.controllerContext);
        Assert.assertEquals((long)400L, (long)this.controllerContext.getResponse().getStatus());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    @Test
    public void testDisplayOnboardingWhenPasswordNotValid() throws Exception {
        String password;
        this.prepareResetPasswordContext();
        String passwordConfirm = password = "pass1";
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"resetPassword");
        Mockito.when((Object)this.request.getParameter(USERNAME)).thenReturn((Object)USERNAME);
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)password);
        Mockito.when((Object)this.request.getParameter("password2")).thenReturn((Object)passwordConfirm);
        PropertyManager.setProperty((String)"gatein.validators.passwordpolicy.length.max", (String)"8");
        PropertyManager.setProperty((String)"gatein.validators.passwordpolicy.length.min", (String)"255");
        try {
            this.onboardingHandler.execute(this.controllerContext);
        }
        finally {
            PropertyManager.setProperty((String)"gatein.validators.passwordpolicy.length.max", (String)"");
            PropertyManager.setProperty((String)"gatein.validators.passwordpolicy.length.min", (String)"");
        }
        Assert.assertEquals((long)400L, (long)this.controllerContext.getResponse().getStatus());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
    }

    @Test
    public void testRedirectToLoginWhenValid() throws Exception {
        String password;
        this.prepareResetPasswordContext();
        String passwordConfirm = password = "pass1234";
        Mockito.when((Object)this.request.getParameter("action")).thenReturn((Object)"resetPassword");
        Mockito.when((Object)this.request.getParameter(USERNAME)).thenReturn((Object)USERNAME);
        Mockito.when((Object)this.request.getParameter("password")).thenReturn((Object)password);
        Mockito.when((Object)this.request.getParameter("password2")).thenReturn((Object)passwordConfirm);
        Mockito.when((Object)this.passwordRecoveryService.changePass(TOKEN_VALUE, "onboard", USERNAME, password)).thenReturn((Object)true);
        this.onboardingHandler.execute(this.controllerContext);
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.times((int)1))).changePass((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).sendRedirect(this.servletContext.getContextPath() + "/login");
    }

    private void prepareResetPasswordContext() {
        HashMap<QualifiedName, String> parameters = new HashMap<QualifiedName, String>();
        parameters.put(OnboardingHandler.TOKEN, TOKEN_VALUE);
        this.controllerContext = new ControllerContext(this.controller, this.router, this.request, this.response, parameters);
    }
}

