/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.register;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import nl.captcha.Captcha;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.resources.impl.LocaleConfigImpl;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.exoplatform.web.register.RegisterHandler;
import org.exoplatform.web.register.RegisterUIParamsExtension;
import org.exoplatform.web.security.security.RemindPasswordTokenService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RegisterHandlerTest {
    private static final Locale REQUEST_LOCALE = Locale.ENGLISH;
    private static final String CONTEXT_PATH = "/portal";
    private static final String EMAIL = "email@test.com";
    private static final String CAPTCHA_VALUE = "captchaValue";
    @Mock
    private ServletContext servletContext;
    @Mock
    private PortalContainer container;
    @Mock
    private RemindPasswordTokenService remindPasswordTokenService;
    @Mock
    private PasswordRecoveryService passwordRecoveryService;
    @Mock
    private ResourceBundleService resourceBundleService;
    @Mock
    private ResourceBundle resourceBundle;
    @Mock
    private OrganizationService organizationService;
    @Mock
    private UserHandler userHandler;
    @Mock
    private GroupHandler groupHandler;
    @Mock
    private MembershipTypeHandler membershipTypeHandler;
    @Mock
    private MembershipHandler membershipHandler;
    @Mock
    private LocaleConfigService localeConfigService;
    @Mock
    private BrandingService brandingService;
    @Mock
    private RegisterUIParamsExtension registerUIParamsExtension;
    @Mock
    private JavascriptConfigService javascriptConfigService;
    @Mock
    private WebAppController controller;
    @Mock
    private Router router;
    @Mock
    private InitParams params;
    @Mock
    private HttpSession session;
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Mock
    private RequestDispatcher requestDispatcher;
    @Mock
    private SkinService skinService;
    @Mock
    private Captcha captcha;
    private ControllerContext controllerContext;
    private RegisterHandler registerHandler;

    @Before
    public void setUp() throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        Mockito.lenient().when((Object)((ResourceBundleService)this.container.getComponentInstanceOfType(ResourceBundleService.class))).thenReturn((Object)this.resourceBundleService);
        Mockito.when((Object)this.request.getContextPath()).thenReturn((Object)CONTEXT_PATH);
        Mockito.when((Object)this.request.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getAttribute("register")).thenReturn((Object)this.captcha);
        Mockito.when((Object)this.captcha.isCorrect(CAPTCHA_VALUE)).thenReturn((Object)true);
        Mockito.when((Object)this.request.getParameter("captcha")).thenReturn((Object)CAPTCHA_VALUE);
        Mockito.when((Object)this.request.getLocale()).thenReturn((Object)REQUEST_LOCALE);
        LocaleConfigImpl localeConfig = new LocaleConfigImpl();
        localeConfig.setLocale(REQUEST_LOCALE);
        Mockito.when((Object)this.resourceBundleService.getSharedResourceBundleNames()).thenReturn((Object)new String[0]);
        Mockito.when((Object)this.resourceBundleService.getResourceBundle((String[])ArgumentMatchers.any(String[].class), (Locale)ArgumentMatchers.eq((Object)REQUEST_LOCALE))).thenReturn((Object)this.resourceBundle);
        Mockito.when((Object)this.resourceBundle.getString(ArgumentMatchers.anyString())).thenAnswer(invocation -> invocation.getArgument(0));
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)this.userHandler);
        Mockito.when((Object)this.registerUIParamsExtension.isRegisterEnabled()).thenReturn((Object)true);
        ServletOutputStream outputStream = new ServletOutputStream(this){

            public void write(int b) throws IOException {
            }

            public boolean isReady() {
                return false;
            }

            public void setWriteListener(WriteListener writeListener) {
            }
        };
        Mockito.when((Object)this.response.getOutputStream()).thenReturn((Object)outputStream);
        final int[] responseStatus = new int[]{0};
        Mockito.when((Object)this.response.getStatus()).thenAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocation) throws Throwable {
                return responseStatus[0];
            }
        });
        ((HttpServletResponse)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                int status;
                Object[] args = invocation.getArguments();
                responseStatus[0] = status = ((Integer)args[0]).intValue();
                return null;
            }
        }).when((Object)this.response)).setStatus(ArgumentMatchers.anyInt());
        final HashMap requestAttributes = new HashMap();
        Mockito.when((Object)this.request.getAttribute(ArgumentMatchers.anyString())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                String key = (String)args[0];
                return requestAttributes.get(key);
            }
        });
        Mockito.when((Object)this.request.getAttributeNames()).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                return Collections.enumeration(requestAttributes.keySet());
            }
        });
        this.registerHandler = new RegisterHandler(this.container, this.resourceBundleService, this.passwordRecoveryService, this.organizationService, this.localeConfigService, this.brandingService, this.javascriptConfigService, this.skinService, this.registerUIParamsExtension);
    }

    @After
    public void teardown() throws Exception {
        ExoContainerContext.setCurrentContainer(null);
    }

    @Test
    public void testGetRequiresLifeCycle() {
        Assert.assertTrue((boolean)this.registerHandler.getRequiresLifeCycle());
    }

    @Test
    public void testGetHandlerName() {
        Assert.assertEquals((Object)"register", (Object)this.registerHandler.getHandlerName());
    }

    @Test
    public void testDisplayRegisterPage() throws Exception {
        this.prepareResetPasswordContext();
        this.registerHandler.execute(this.controllerContext);
        Assert.assertNull((Object)this.controllerContext.getRequest().getAttribute("email"));
        Assert.assertFalse((boolean)Collections.list(this.controllerContext.getRequest().getAttributeNames()).contains("error"));
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendExternalRegisterEmail((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (StringBuilder)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testRegisterWithBadEmailFormat() throws Exception {
        this.prepareResetPasswordContext();
        String email = "testFakeEmail";
        Mockito.when((Object)this.request.getParameter("email")).thenReturn((Object)email);
        this.registerHandler.execute(this.controllerContext);
        Assert.assertEquals((long)400L, (long)this.controllerContext.getResponse().getStatus());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendExternalRegisterEmail((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (StringBuilder)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testRegisterWithInvalidCaptcha() throws Exception {
        this.prepareResetPasswordContext();
        Mockito.when((Object)this.request.getParameter("email")).thenReturn((Object)EMAIL);
        Mockito.when((Object)this.captcha.isCorrect(CAPTCHA_VALUE)).thenReturn((Object)false);
        this.registerHandler.execute(this.controllerContext);
        Assert.assertEquals((long)400L, (long)this.controllerContext.getResponse().getStatus());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendExternalRegisterEmail((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (StringBuilder)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testRegisterWithKnownEmailAsUsername() throws Exception {
        this.prepareResetPasswordContext();
        Mockito.when((Object)this.request.getParameter("email")).thenReturn((Object)EMAIL);
        Mockito.when((Object)this.userHandler.findUserByName(EMAIL)).thenReturn((Object)((User)Mockito.mock(User.class)));
        this.registerHandler.execute(this.controllerContext);
        Assert.assertEquals((long)200L, (long)this.controllerContext.getResponse().getStatus());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendExternalRegisterEmail((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (StringBuilder)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testRegisterWithKnownEmail() throws Exception {
        this.prepareResetPasswordContext();
        Mockito.when((Object)this.request.getParameter("email")).thenReturn((Object)EMAIL);
        ListAccess listAccess = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)listAccess.getSize()).thenReturn((Object)1);
        Mockito.when((Object)this.userHandler.findUsersByQuery((Query)ArgumentMatchers.any(), (UserStatus)ArgumentMatchers.any())).thenReturn((Object)listAccess);
        this.registerHandler.execute(this.controllerContext);
        Assert.assertEquals((long)200L, (long)this.controllerContext.getResponse().getStatus());
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.never())).sendExternalRegisterEmail((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (StringBuilder)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testRedirectToLoginWhenValid() throws Exception {
        this.prepareResetPasswordContext();
        Mockito.when((Object)this.request.getParameter("email")).thenReturn((Object)EMAIL);
        this.registerHandler.execute(this.controllerContext);
        ((PasswordRecoveryService)Mockito.verify((Object)this.passwordRecoveryService, (VerificationMode)Mockito.times((int)1))).sendExternalRegisterEmail((String)ArgumentMatchers.eq(null), (String)ArgumentMatchers.eq((Object)EMAIL), (Locale)ArgumentMatchers.eq((Object)REQUEST_LOCALE), (String)ArgumentMatchers.eq(null), (StringBuilder)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false));
    }

    private void prepareResetPasswordContext() {
        this.controllerContext = new ControllerContext(this.controller, this.router, this.request, this.response, new HashMap());
    }
}

