/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.web.security.service;

import io.meeds.web.security.service.ApiKeyService;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.security.ConcurrentMessageDigest;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.springframework.stereotype.Service;

@Service
public class DigestAuthenticatorService {
    private ApiKeyService apiKeyService;
    private Authenticator authenticator;

    public DigestAuthenticatorService(ApiKeyService apiKeyService, Authenticator authenticator) {
        this.authenticator = authenticator;
        this.apiKeyService = apiKeyService;
    }

    public Identity createIdentity(String userName) {
        return this.authenticator.createIdentity(userName);
    }

    public String validateUser(String userName, String clientDigest, String nonce, String nc, String cnonce, String qop, String realm, String digestA2, String algorithm) {
        String digestA1 = this.getDigest(userName, realm, algorithm);
        digestA1 = digestA1.toLowerCase(Locale.ENGLISH);
        String serverDigestValue = qop == null ? digestA1 + ":" + nonce + ":" + digestA2 : digestA1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + digestA2;
        byte[] valueBytes = serverDigestValue.getBytes(StandardCharsets.UTF_8);
        String serverDigest = HexUtils.toHexString((byte[])ConcurrentMessageDigest.digest((String)algorithm, (byte[][])new byte[][]{valueBytes}));
        if (serverDigest.equals(clientDigest)) {
            return userName;
        }
        return null;
    }

    protected String getDigest(String userName, String realmName, String algorithm) {
        String clearTextPassword = this.apiKeyService.getPassword(userName);
        if (clearTextPassword == null) {
            throw new IllegalStateException(String.format("No generated password for user '%s'", userName));
        }
        String digestValue = userName + ":" + realmName + ":" + clearTextPassword;
        byte[] valueBytes = digestValue.getBytes(StandardCharsets.UTF_8);
        return HexUtils.toHexString((byte[])ConcurrentMessageDigest.digest((String)algorithm, (byte[][])new byte[][]{valueBytes}));
    }
}

