/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.web.security.service;

import io.meeds.web.security.plugin.OtpPlugin;
import io.meeds.web.security.service.OtpService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class OtpServiceTest {
    @Mock
    private CacheService cacheService;
    @Mock
    private ExoCache<String, Long> otpTentativeCache;
    @Mock
    private OtpPlugin otpPlugin;
    @InjectMocks
    private OtpService otpService;

    @Before
    public void setUp() {
        this.otpService.setOtpPlugins(Arrays.asList(this.otpPlugin));
        this.otpService.setOtpTentativesTtl(5L);
        this.otpService.setOtpMaxTentatives(3L);
        Mockito.when((Object)this.cacheService.getCacheInstance("otp.tentatives")).thenReturn(this.otpTentativeCache);
        Mockito.when((Object)this.otpPlugin.getName()).thenReturn((Object)"sms");
    }

    @Test
    public void testSendOtpCodeSuccess() {
        this.otpService.sendOtpCode("john", "sms");
        ((OtpPlugin)Mockito.verify((Object)this.otpPlugin)).generateOtpCode("john");
    }

    @Test(expected=IllegalAccessException.class)
    public void testSendOtpCodeNoPluginFoundThrowsException() {
        this.otpService.setOtpPlugins(Collections.emptyList());
        this.otpService.sendOtpCode("john", "email");
    }

    @Test(expected=IllegalAccessException.class)
    public void testValidateOtpBlankCodeThrowsException() {
        this.otpService.validateOtp("john", "sms", " ");
    }

    @Test(expected=IllegalAccessException.class)
    public void testValidateOtpTooManyAttemptsThrowsException() {
        Mockito.when((Object)((Long)this.otpTentativeCache.get((Serializable)((Object)"john")))).thenReturn((Object)3L);
        this.otpService.validateOtp("john", "sms", "1234");
    }

    @Test(expected=IllegalAccessException.class)
    public void testValidateOtpNoPluginFoundThrowsException() {
        this.otpService.setOtpPlugins(Collections.emptyList());
        Mockito.when((Object)((Long)this.otpTentativeCache.get((Serializable)((Object)"john")))).thenReturn((Object)0L);
        this.otpService.validateOtp("john", "sms", "1234");
    }

    @Test(expected=IllegalAccessException.class)
    public void testValidateOtpPluginInvalidatesCodeIncrementsCounter() {
        Mockito.when((Object)((Long)this.otpTentativeCache.get((Serializable)((Object)"john")))).thenReturn((Object)1L);
        Mockito.when((Object)this.otpPlugin.validateOtp("john", "1234")).thenReturn((Object)false);
        this.otpService.validateOtp("john", "sms", "1234");
        ((ExoCache)Mockito.verify(this.otpTentativeCache)).put((Serializable)((Object)"john"), (Object)2L);
    }

    @Test
    public void testValidateOtpPluginValidatesCodeResetsCounter() {
        Mockito.when((Object)((Long)this.otpTentativeCache.get((Serializable)((Object)"john")))).thenReturn((Object)1L);
        Mockito.when((Object)this.otpPlugin.validateOtp("john", "1234")).thenReturn((Object)true);
        this.otpService.validateOtp("john", "sms", "1234");
        ((ExoCache)Mockito.verify(this.otpTentativeCache)).remove((Serializable)((Object)"john"));
    }
}

