/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.web.security.storage;

import io.meeds.web.security.dao.ApiKeyDAO;
import io.meeds.web.security.entity.ApiKeyEntity;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiKeyStorage {
    @Autowired
    private ApiKeyDAO apiKeyDao;

    public void saveKey(String userName, String encryptedPassword) {
        ApiKeyEntity apiKeyEntity = this.apiKeyDao.findByUserName(userName);
        if (apiKeyEntity == null) {
            apiKeyEntity = new ApiKeyEntity(null, userName, encryptedPassword, new Date());
        } else {
            apiKeyEntity.setEncryptedPassword(encryptedPassword);
            apiKeyEntity.setCreationDate(new Date());
        }
        this.apiKeyDao.save(apiKeyEntity);
    }

    public String getKey(String userName) {
        ApiKeyEntity apiKeyEntity = this.apiKeyDao.findByUserName(userName);
        if (apiKeyEntity == null) {
            return null;
        }
        return apiKeyEntity.getEncryptedPassword();
    }
}

