/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.jpa.mock;

import io.meeds.web.security.dao.TokenDAO;
import io.meeds.web.security.entity.TokenEntity;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.jpa.mock.AbstractInMemoryDAO;

public class InMemoryTokenDAO
extends AbstractInMemoryDAO<TokenEntity>
implements TokenDAO {
    public TokenEntity findByTokenId(String tokenId) {
        return this.entities.values().stream().filter(entity -> StringUtils.equals((CharSequence)entity.getTokenId(), (CharSequence)tokenId)).findFirst().orElse(null);
    }

    public List<TokenEntity> findByUsername(String username) {
        return this.entities.values().stream().filter(entity -> StringUtils.equals((CharSequence)entity.getUsername(), (CharSequence)username)).toList();
    }

    public void deleteTokensByUsernameAndType(String username, String tokenType) {
        List<TokenEntity> tokenList = this.entities.values().stream().filter(entity -> StringUtils.equals((CharSequence)entity.getUsername(), (CharSequence)username) && StringUtils.equals((CharSequence)entity.getTokenType(), (CharSequence)tokenType)).toList();
        this.deleteAll(tokenList);
    }

    public void cleanExpired() {
        List<TokenEntity> tokenList = this.entities.values().stream().filter(entity -> entity.getExpirationTime() != null && entity.getExpirationTime().getTime() <= System.currentTimeMillis()).toList();
        this.deleteAll(tokenList);
    }
}

