/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security;

import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.web.security.AbstractTokenServiceTest;
import org.exoplatform.web.security.PortalToken;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.TransientTokenService;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.security-configuration-local.xml")})
public class TestTransientTokenService
extends AbstractTokenServiceTest<TransientTokenService> {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        PortalContainer container = this.getContainer();
        this.service = (AbstractTokenService)container.getComponentInstanceOfType(TransientTokenService.class);
    }

    @Override
    public void testGetToken() throws Exception {
        String tokenId = ((TransientTokenService)this.service).createToken("root");
        TestTransientTokenService.assertEquals((long)((TransientTokenService)this.service).getValidityTime(), (long)2L);
        PortalToken token = ((TransientTokenService)this.service).getToken(tokenId);
        TestTransientTokenService.assertEquals((String)token.getUsername(), (String)"root");
        ((TransientTokenService)this.service).deleteToken(tokenId);
    }

    @Override
    public void testGetAllToken() throws Exception {
        String tokenId1 = ((TransientTokenService)this.service).createToken("root1");
        String tokenId2 = ((TransientTokenService)this.service).createToken("root2");
        String[] tokens = ((TransientTokenService)this.service).getAllTokens();
        TestTransientTokenService.assertEquals((int)tokens.length, (int)2);
        PortalToken token1 = ((TransientTokenService)this.service).getToken(tokenId1);
        TestTransientTokenService.assertEquals((String)token1.getUsername(), (String)"root1");
        PortalToken token2 = ((TransientTokenService)this.service).getToken(tokenId2);
        TestTransientTokenService.assertEquals((String)token2.getUsername(), (String)"root2");
        ((TransientTokenService)this.service).deleteToken(tokenId1);
        ((TransientTokenService)this.service).deleteToken(tokenId2);
    }

    @Override
    public void testSize() throws Exception {
        String tokenId1 = ((TransientTokenService)this.service).createToken("root1");
        TestTransientTokenService.assertEquals((long)((TransientTokenService)this.service).size(), (long)1L);
        ((TransientTokenService)this.service).deleteToken(tokenId1);
    }

    @Override
    public void testDeleteToken() throws Exception {
        String tokenId = ((TransientTokenService)this.service).createToken("root");
        ((TransientTokenService)this.service).deleteToken(tokenId);
        TestTransientTokenService.assertNull((Object)((TransientTokenService)this.service).getToken(tokenId));
    }

    @Override
    public void testCleanExpiredTokens() throws Exception {
        TestTransientTokenService.assertEquals((long)2L, (long)((TransientTokenService)this.service).getValidityTime());
        String tokenId1 = ((TransientTokenService)this.service).createToken("user1");
        TestTransientTokenService.assertEquals((long)1L, (long)((TransientTokenService)this.service).size());
        Thread.sleep(2100L);
        ((TransientTokenService)this.service).cleanExpiredTokens();
        TestTransientTokenService.assertEquals((long)0L, (long)((TransientTokenService)this.service).size());
        ((TransientTokenService)this.service).deleteToken(tokenId1);
    }

    @Override
    public void testGetTokenWithType() throws Exception {
    }

    @Override
    public void testGetTokenWithWrongType() throws Exception {
    }

    @Override
    public void testGetAllTokenWithType() throws Exception {
    }

    @Override
    public void testSizeWithType() throws Exception {
    }

    @Override
    public void testDeleteTokenWithType() throws Exception {
    }

    @Override
    public void testCleanExpiredTokensWithType() throws Exception {
    }
}

