/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import javax.security.auth.login.LoginException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.services.security.jaas.AbstractLoginModule;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.gatein.wci.security.Credentials;

public class PortalLoginModule
extends AbstractLoginModule {
    private static final Log log = ExoLogger.getLogger(PortalLoginModule.class);
    private static final Method getContextMethod;
    public static final String AUTHENTICATED_CREDENTIALS = "authenticatedCredentials";
    private static final String LOGIN_ON_DIFFERENT_NODE = "PortalLoginModule.loginOnDifferentNode";

    public boolean login() throws LoginException {
        if (getContextMethod != null) {
            Credentials authCredentials = null;
            try {
                HttpServletRequest request = this.getCurrentHttpServletRequest();
                if (request == null) {
                    log.debug((Object)"Unable to find HTTPServletRequest.");
                    return false;
                }
                authCredentials = (Credentials)request.getSession().getAttribute(AUTHENTICATED_CREDENTIALS);
                if (authCredentials != null) {
                    Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
                    if (authenticator == null) {
                        throw new LoginException("No Authenticator component found, check your configuration");
                    }
                    String username = authCredentials.getUsername();
                    Identity identity = authenticator.createIdentity(username);
                    this.sharedState.put("exo.security.identity", identity);
                    this.sharedState.put("javax.security.auth.login.name", username);
                    this.subject.getPublicCredentials().add(new UsernameCredential(username));
                    this.subject.getPrivateCredentials().add("");
                    this.sharedState.remove("javax.security.auth.login.password");
                    this.sharedState.put(LOGIN_ON_DIFFERENT_NODE, true);
                }
            }
            catch (Exception e) {
                log.error((Object)this, (Throwable)e);
                LoginException le = new LoginException(e.getMessage());
                le.initCause(e);
                throw le;
            }
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (getContextMethod != null && PortalLoginModule.isClusteredSSO() && this.sharedState.containsKey("javax.security.auth.login.name") && this.sharedState.containsKey("javax.security.auth.login.password") && this.sharedState.get(LOGIN_ON_DIFFERENT_NODE) == null) {
            String uid = (String)this.sharedState.get("javax.security.auth.login.name");
            Credentials wc = new Credentials(uid, "");
            HttpServletRequest request = null;
            try {
                request = this.getCurrentHttpServletRequest();
                if (request == null) {
                    log.debug((Object)"Unable to find HTTPServletRequest.");
                } else {
                    request.getSession().setAttribute(AUTHENTICATED_CREDENTIALS, (Object)wc);
                }
            }
            catch (Exception e) {
                log.error((Object)this, (Throwable)e);
                log.error((Object)"LoginModule error. Turn off session credentials checking with proper configuration option of LoginModule set to false");
            }
        }
        return true;
    }

    public boolean abort() throws LoginException {
        HttpServletRequest request = this.getCurrentHttpServletRequest();
        if (request != null) {
            this.handleCredentialsRemoving(request);
        }
        return true;
    }

    public boolean logout() throws LoginException {
        return true;
    }

    protected Log getLogger() {
        return log;
    }

    protected static boolean isClusteredSSO() {
        return ExoContainer.hasProfile((String)"cluster");
    }

    protected void handleCredentialsRemoving(HttpServletRequest request) {
        try {
            AuthenticationRegistry authenticationRegistry = (AuthenticationRegistry)this.getContainer().getComponentInstanceOfType(AuthenticationRegistry.class);
            if (request != null) {
                authenticationRegistry.removeCredentials(request);
            }
        }
        catch (Exception e) {
            log.debug((Object)"Unable to remove credentials from credentialsRegistry.", (Throwable)e);
        }
    }

    private HttpServletRequest getCurrentHttpServletRequest() {
        HttpServletRequest request = null;
        try {
            if (getContextMethod != null) {
                request = (HttpServletRequest)getContextMethod.invoke(null, "jakarta.servlet.http.HttpServletRequest");
            }
        }
        catch (Exception e) {
            log.debug((Object)"Exception when trying to obtain HTTPServletRequest.", (Throwable)e);
        }
        return request;
    }

    static {
        Method getContext = null;
        log.debug((Object)"About to configure PortalLoginModule");
        try {
            Class<?> policyContextClass = Thread.currentThread().getContextClassLoader().loadClass("javax.security.jacc.PolicyContext");
            getContext = policyContextClass.getDeclaredMethod("getContext", String.class);
        }
        catch (ClassNotFoundException ignore) {
            log.debug((Object)"JACC not found ignoring it", (Throwable)ignore);
        }
        catch (Exception e) {
            log.error((Object)"Could not obtain JACC get context method", (Throwable)e);
        }
        getContextMethod = getContext;
    }
}

