/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.push.service;

import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.push.dao.DeviceDao;
import org.exoplatform.push.domain.Device;
import org.exoplatform.push.service.DeviceService;
import org.exoplatform.push.service.DeviceServiceImpl$AjcClosure1;
import org.exoplatform.push.service.DeviceServiceImpl$AjcClosure3;
import org.exoplatform.push.service.DeviceServiceImpl$AjcClosure5;
import org.exoplatform.push.service.DeviceServiceImpl$AjcClosure7;
import org.exoplatform.push.service.DeviceServiceImpl$AjcClosure9;
import org.exoplatform.push.util.StringUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DeviceServiceImpl
implements DeviceService {
    private static final Log LOG;
    private DeviceDao deviceDao;
    private int tokenExpirationSeconds = 5184000;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public DeviceServiceImpl(InitParams initParams, DeviceDao deviceDao) {
        ValueParam tokenExpirationTimeParam;
        if (initParams != null && (tokenExpirationTimeParam = initParams.getValueParam("tokenExpirationTime")) != null) {
            try {
                this.tokenExpirationSeconds = Integer.parseInt(tokenExpirationTimeParam.getValue());
            }
            catch (NumberFormatException e) {
                LOG.error((Object)("Push Notifications - Token expiration time is not a valid number (" + tokenExpirationTimeParam.getValue() + "), using default value " + this.tokenExpirationSeconds), (Throwable)e);
            }
        }
        this.deviceDao = deviceDao;
    }

    @Override
    @ExoTransactional
    public void saveDevice(Device device) {
        Device device2 = device;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)device2);
        Object[] objectArray = new Object[]{this, device2, joinPoint};
        DeviceServiceImpl$AjcClosure1 deviceServiceImpl$AjcClosure1 = new DeviceServiceImpl$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(deviceServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void deleteDevice(Device device) {
        Device device2 = device;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)device2);
        Object[] objectArray = new Object[]{this, device2, joinPoint};
        DeviceServiceImpl$AjcClosure3 deviceServiceImpl$AjcClosure3 = new DeviceServiceImpl$AjcClosure3(objectArray);
        ExoTransactionalAspect.aspectOf().around(deviceServiceImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @Override
    public Device getDeviceById(Long deviceId) {
        return (Device)this.deviceDao.find(deviceId);
    }

    @Override
    @ExoTransactional
    public List<Device> getDevicesByUser(String username) {
        String string = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        DeviceServiceImpl$AjcClosure5 deviceServiceImpl$AjcClosure5 = new DeviceServiceImpl$AjcClosure5(objectArray);
        return (List)ExoTransactionalAspect.aspectOf().around(deviceServiceImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public Device getDeviceByToken(String token) {
        String string = token;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        DeviceServiceImpl$AjcClosure7 deviceServiceImpl$AjcClosure7 = new DeviceServiceImpl$AjcClosure7(objectArray);
        return (Device)ExoTransactionalAspect.aspectOf().around(deviceServiceImpl$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void deleteDevicesWithExpiredToken() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        DeviceServiceImpl$AjcClosure9 deviceServiceImpl$AjcClosure9 = new DeviceServiceImpl$AjcClosure9(objectArray);
        ExoTransactionalAspect.aspectOf().around(deviceServiceImpl$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    static {
        DeviceServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(DeviceServiceImpl.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final /* synthetic */ void saveDevice_aroundBody0(DeviceServiceImpl ajc$this, Device device, JoinPoint joinPoint) {
        Device existingDevice;
        if (device.getRegistrationDate() == null) {
            device.setRegistrationDate(new Date());
        }
        if ((existingDevice = ajc$this.getDeviceByToken(device.getToken())) != null) {
            if (!device.getUsername().equals(existingDevice.getUsername())) throw new RuntimeException("Token already registered for another user !");
            existingDevice.setType(device.getType());
            existingDevice.setRegistrationDate(device.getRegistrationDate());
            ajc$this.deviceDao.update(existingDevice);
            LOG.info("Device updated : username={}, token={}, type={}", new Object[]{device.getUsername(), StringUtil.mask(device.getToken(), 4), device.getType()});
            return;
        } else {
            ajc$this.deviceDao.create(device);
            LOG.info("New device registered : username={}, token={}, type={}", new Object[]{device.getUsername(), StringUtil.mask(device.getToken(), 4), device.getType()});
        }
    }

    static final /* synthetic */ void deleteDevice_aroundBody2(DeviceServiceImpl ajc$this, Device device, JoinPoint joinPoint) {
        ajc$this.deviceDao.delete(device);
        LOG.info("Device unregistered : username={}, token={}, type={}", new Object[]{device.getUsername(), StringUtil.mask(device.getToken(), 4), device.getType()});
    }

    static final /* synthetic */ List getDevicesByUser_aroundBody4(DeviceServiceImpl ajc$this, String username, JoinPoint joinPoint) {
        return ajc$this.deviceDao.findByUsername(username);
    }

    static final /* synthetic */ Device getDeviceByToken_aroundBody6(DeviceServiceImpl ajc$this, String token, JoinPoint joinPoint) {
        return ajc$this.deviceDao.findByToken(token);
    }

    static final /* synthetic */ void deleteDevicesWithExpiredToken_aroundBody8(DeviceServiceImpl ajc$this, JoinPoint joinPoint) {
        long expirationTimeMillis = ajc$this.tokenExpirationSeconds * 1000;
        Instant instant = Instant.now();
        long currentTimeStamp = instant.toEpochMilli();
        Instant expirationInstant = Instant.ofEpochMilli(currentTimeStamp - expirationTimeMillis);
        int nbDeleted = ajc$this.deviceDao.deleteDevicesWithTokenOlderThan(Date.from(expirationInstant));
        LOG.debug("{} devices deleted", new Object[]{nbDeleted});
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DeviceServiceImpl.java", DeviceServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "saveDevice", "org.exoplatform.push.service.DeviceServiceImpl", "org.exoplatform.push.domain.Device", "device", "", "void"), 61);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteDevice", "org.exoplatform.push.service.DeviceServiceImpl", "org.exoplatform.push.domain.Device", "device", "", "void"), 82);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDevicesByUser", "org.exoplatform.push.service.DeviceServiceImpl", "java.lang.String", "username", "", "java.util.List"), 92);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDeviceByToken", "org.exoplatform.push.service.DeviceServiceImpl", "java.lang.String", "token", "", "org.exoplatform.push.domain.Device"), 97);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteDevicesWithExpiredToken", "org.exoplatform.push.service.DeviceServiceImpl", "", "", "", "void"), 102);
    }
}

