/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.push.service.fcm;

import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.io.IOUtils;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicStatusLine;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.push.domain.Message;
import org.exoplatform.push.exception.InvalidTokenException;
import org.exoplatform.push.service.fcm.FCMMessagePublisher;
import org.exoplatform.services.resources.ResourceBundleService;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class FCMMessagePublisherTest {
    @Mock
    private ResourceBundleService resourceBundleService;
    @Mock
    private CloseableHttpClient httpClient;
    @Mock
    private CloseableHttpResponse httpResponse;
    @Mock
    private WebNotificationService webNotificationService;

    @Before
    public void setup() {
        ResourceBundle resourceBundle = new ResourceBundle(this){

            @Override
            protected Object handleGetObject(String key) {
                return "inline image";
            }

            @Override
            public Enumeration<String> getKeys() {
                return Collections.enumeration(Collections.singleton("Notification.push.label.InlineImage"));
            }
        };
        Mockito.when((Object)this.resourceBundleService.getResourceBundle((String)Mockito.eq((Object)"locale.portlet.notification.PushNotifications"), (Locale)Mockito.any(Locale.class))).thenReturn((Object)resourceBundle);
        Mockito.when((Object)this.webNotificationService.getNumberOnBadge(Mockito.anyString())).thenReturn((Object)5);
    }

    @Test
    public void shouldNotSendMessageWhenInitParamsAreNull() throws Exception {
        FCMMessagePublisher messagePublisher = new FCMMessagePublisher(null, this.resourceBundleService, this.webNotificationService, this.httpClient);
        messagePublisher.send(new Message("", "", "", "", "", ""));
        ((CloseableHttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.never())).execute((HttpUriRequest)Mockito.any());
    }

    @Test
    public void shouldNotSendMessageWhenNoConfigFilePathParam() throws Exception {
        InitParams initParams = new InitParams();
        FCMMessagePublisher messagePublisher = new FCMMessagePublisher(initParams, this.resourceBundleService, this.webNotificationService, this.httpClient);
        messagePublisher.send(new Message("", "", "", "", "", ""));
        ((CloseableHttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.never())).execute((HttpUriRequest)Mockito.any());
    }

    @Test
    public void shouldNotSendMessageWhenNoConfigFile() throws Exception {
        InitParams initParams = new InitParams();
        ValueParam serverKeyParam = new ValueParam();
        serverKeyParam.setName("serviceAccountFilePath");
        serverKeyParam.setValue("fake.json");
        initParams.addParameter((Parameter)serverKeyParam);
        FCMMessagePublisher messagePublisher = new FCMMessagePublisher(initParams, this.resourceBundleService, this.webNotificationService, this.httpClient);
        messagePublisher.send(new Message("", "", "", "", "", ""));
        ((CloseableHttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.never())).execute((HttpUriRequest)Mockito.any());
    }

    @Test
    public void shouldSendMessageWhenConfigFileExistsAndResponseOK() throws Exception {
        Mockito.when((Object)this.httpResponse.getStatusLine()).thenReturn((Object)new BasicStatusLine(new ProtocolVersion("", 1, 2), 200, ""));
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Mockito.any())).thenReturn((Object)this.httpResponse);
        InitParams initParams = new InitParams();
        ValueParam serverKeyParam = new ValueParam();
        serverKeyParam.setName("serviceAccountFilePath");
        serverKeyParam.setValue(this.getClass().getResource("/fcm-test.json").getPath());
        initParams.addParameter((Parameter)serverKeyParam);
        FCMMessagePublisher messagePublisher = new FCMMessagePublisher(this, initParams, this.resourceBundleService, this.webNotificationService, this.httpClient){

            protected PrivateKey getPrivateKeyFromPkcs8(String privateKeyPem) throws IOException {
                return (PrivateKey)Mockito.mock(PrivateKey.class);
            }

            protected String getAccessToken() throws IOException {
                return "fakeAccessToken";
            }
        };
        ArgumentCaptor reqArgs = ArgumentCaptor.forClass(HttpPost.class);
        messagePublisher.send(new Message("john", "token1", "android", "My Notification Title", "My Notification Body", "http://notification.url/target"));
        messagePublisher.send(new Message("mary", "token2", "ios", "My Notification Title", "My Notification Body", "http://notification.url/target"));
        ((CloseableHttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)2))).execute((HttpUriRequest)reqArgs.capture());
        List httpUriRequests = reqArgs.getAllValues();
        Assert.assertNotNull((Object)httpUriRequests);
        HttpPost httpUriRequest = (HttpPost)httpUriRequests.get(0);
        String body = IOUtils.toString((InputStream)httpUriRequest.getEntity().getContent(), (String)"UTF-8");
        JSONObject jsonMessage = new JSONObject(body);
        Assert.assertFalse((boolean)jsonMessage.getBoolean("validate_only"));
        JSONObject message = jsonMessage.getJSONObject("message");
        JSONObject data = message.getJSONObject("data");
        Assert.assertEquals((Object)"My Notification Title", (Object)data.getString("title"));
        Assert.assertEquals((Object)"My Notification Body", (Object)data.getString("body"));
        Assert.assertEquals((Object)"http://notification.url/target", (Object)data.getString("url"));
        Assert.assertEquals((Object)"token1", (Object)message.getString("token"));
        Assert.assertFalse((boolean)message.has("android"));
        Assert.assertFalse((boolean)message.has("ios"));
        httpUriRequest = (HttpPost)httpUriRequests.get(1);
        Assert.assertNotNull((Object)httpUriRequest);
        body = IOUtils.toString((InputStream)httpUriRequest.getEntity().getContent(), (String)"UTF-8");
        jsonMessage = new JSONObject(body);
        Assert.assertFalse((boolean)jsonMessage.getBoolean("validate_only"));
        message = jsonMessage.getJSONObject("message");
        JSONObject notification = message.getJSONObject("notification");
        Assert.assertEquals((Object)"My Notification Title", (Object)notification.getString("title"));
        Assert.assertEquals((Object)"My Notification Body", (Object)notification.getString("body"));
        data = message.getJSONObject("data");
        Assert.assertEquals((Object)"http://notification.url/target", (Object)data.getString("url"));
        Assert.assertEquals((Object)"token2", (Object)message.getString("token"));
        Assert.assertFalse((boolean)message.has("android"));
        Assert.assertTrue((boolean)message.has("apns"));
        JSONObject apns = message.getJSONObject("apns");
        Assert.assertTrue((boolean)apns.has("payload"));
        JSONObject payload = apns.getJSONObject("payload");
        Assert.assertTrue((boolean)payload.has("aps"));
        JSONObject aps = payload.getJSONObject("aps");
        Assert.assertTrue((boolean)aps.has("badge"));
        Assert.assertEquals((long)5L, (long)aps.getInt("badge"));
    }

    @Test
    public void shouldSendSanitizedHTMLMessageWhenConfigFileExistsAndResponseOK() throws Exception {
        Mockito.when((Object)this.httpResponse.getStatusLine()).thenReturn((Object)new BasicStatusLine(new ProtocolVersion("", 1, 2), 200, ""));
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Mockito.any())).thenReturn((Object)this.httpResponse);
        InitParams initParams = new InitParams();
        ValueParam serverKeyParam = new ValueParam();
        serverKeyParam.setName("serviceAccountFilePath");
        serverKeyParam.setValue(this.getClass().getResource("/fcm-test.json").getPath());
        initParams.addParameter((Parameter)serverKeyParam);
        FCMMessagePublisher messagePublisher = new FCMMessagePublisher(this, initParams, this.resourceBundleService, this.webNotificationService, this.httpClient){

            protected PrivateKey getPrivateKeyFromPkcs8(String privateKeyPem) throws IOException {
                return (PrivateKey)Mockito.mock(PrivateKey.class);
            }

            protected String getAccessToken() throws IOException {
                return "fakeAccessToken";
            }
        };
        ArgumentCaptor reqArgs = ArgumentCaptor.forClass(HttpPost.class);
        messagePublisher.send(new Message("john", "token1", "android", "My <b>Notification</b> Title", "My Notification <div class=\"myclass\">Body</div>", "http://notification.url/target"));
        messagePublisher.send(new Message("mary", "token2", "ios", "My <b>Notification</b> Title", "\n\nMy Notification \n\n<div class=\"myclass\">Body</div>", "http://notification.url/target"));
        ((CloseableHttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)2))).execute((HttpUriRequest)reqArgs.capture());
        List httpUriRequests = reqArgs.getAllValues();
        Assert.assertNotNull((Object)httpUriRequests);
        HttpPost httpUriRequest = (HttpPost)httpUriRequests.get(0);
        String body = IOUtils.toString((InputStream)httpUriRequest.getEntity().getContent(), (String)"UTF-8");
        JSONObject jsonMessage = new JSONObject(body);
        Assert.assertEquals((Object)false, (Object)jsonMessage.getBoolean("validate_only"));
        JSONObject message = jsonMessage.getJSONObject("message");
        JSONObject data = message.getJSONObject("data");
        Assert.assertEquals((Object)"My <b>Notification</b> Title", (Object)data.getString("title"));
        Assert.assertEquals((Object)"My Notification <div class=\"myclass\">Body</div>", (Object)data.getString("body"));
        Assert.assertEquals((Object)"http://notification.url/target", (Object)data.getString("url"));
        Assert.assertEquals((Object)"token1", (Object)message.getString("token"));
        Assert.assertFalse((boolean)message.has("android"));
        Assert.assertFalse((boolean)message.has("ios"));
        httpUriRequest = (HttpPost)httpUriRequests.get(1);
        Assert.assertNotNull((Object)httpUriRequest);
        body = IOUtils.toString((InputStream)httpUriRequest.getEntity().getContent(), (String)"UTF-8");
        jsonMessage = new JSONObject(body.replaceAll("\\n", "\\\\n"));
        Assert.assertEquals((Object)false, (Object)jsonMessage.getBoolean("validate_only"));
        message = jsonMessage.getJSONObject("message");
        JSONObject notification = message.getJSONObject("notification");
        Assert.assertEquals((Object)"My Notification Title", (Object)notification.getString("title"));
        Assert.assertEquals((Object)"My Notification \n\nBody", (Object)notification.getString("body"));
        data = message.getJSONObject("data");
        Assert.assertEquals((Object)"http://notification.url/target", (Object)data.getString("url"));
        Assert.assertEquals((Object)"token2", (Object)message.getString("token"));
        Assert.assertFalse((boolean)message.has("android"));
        Assert.assertTrue((boolean)message.has("apns"));
        JSONObject apns = message.getJSONObject("apns");
        Assert.assertTrue((boolean)apns.has("payload"));
        JSONObject payload = apns.getJSONObject("payload");
        Assert.assertTrue((boolean)payload.has("aps"));
        JSONObject aps = payload.getJSONObject("aps");
        Assert.assertTrue((boolean)aps.has("badge"));
        Assert.assertEquals((long)5L, (long)aps.getInt("badge"));
    }

    @Test
    public void shouldSendSanitizedHTMLMessageWithInlineImage() throws Exception {
        Mockito.when((Object)this.httpResponse.getStatusLine()).thenReturn((Object)new BasicStatusLine(new ProtocolVersion("", 1, 2), 200, ""));
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Mockito.any())).thenReturn((Object)this.httpResponse);
        InitParams initParams = new InitParams();
        ValueParam serverKeyParam = new ValueParam();
        serverKeyParam.setName("serviceAccountFilePath");
        serverKeyParam.setValue(this.getClass().getResource("/fcm-test.json").getPath());
        initParams.addParameter((Parameter)serverKeyParam);
        FCMMessagePublisher messagePublisher = new FCMMessagePublisher(this, initParams, this.resourceBundleService, this.webNotificationService, this.httpClient){

            protected PrivateKey getPrivateKeyFromPkcs8(String privateKeyPem) throws IOException {
                return (PrivateKey)Mockito.mock(PrivateKey.class);
            }

            protected String getAccessToken() throws IOException {
                return "fakeAccessToken";
            }
        };
        ArgumentCaptor reqArgs = ArgumentCaptor.forClass(HttpPost.class);
        messagePublisher.send(new Message("john", "token1", "android", "My <b>Notification</b> Title", "My Notification <div class=\"myclass\">Text</div> <img data-plugin-name='insertImage' src=\"http://fake.com/image.png\"/> Text", "http://notification.url/target"));
        messagePublisher.send(new Message("mary", "token2", "ios", "My <b>Notification</b> Title", "My Notification <div class=\"myclass\">Text</div> <img data-plugin-name='insertImage' src=\"http://fake.com/image.png\"/> Text", "http://notification.url/target"));
        ((CloseableHttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)2))).execute((HttpUriRequest)reqArgs.capture());
        List httpUriRequests = reqArgs.getAllValues();
        Assert.assertNotNull((Object)httpUriRequests);
        HttpPost httpUriRequest = (HttpPost)httpUriRequests.get(0);
        String body = IOUtils.toString((InputStream)httpUriRequest.getEntity().getContent(), (String)"UTF-8");
        JSONObject jsonMessage = new JSONObject(body);
        Assert.assertEquals((Object)false, (Object)jsonMessage.getBoolean("validate_only"));
        JSONObject message = jsonMessage.getJSONObject("message");
        JSONObject data = message.getJSONObject("data");
        Assert.assertEquals((Object)"My <b>Notification</b> Title", (Object)data.getString("title"));
        Assert.assertEquals((Object)"My Notification <div class=\"myclass\">Text</div> <i> [inline image] </i> Text", (Object)data.getString("body"));
        Assert.assertEquals((Object)"http://notification.url/target", (Object)data.getString("url"));
        Assert.assertEquals((Object)"token1", (Object)message.getString("token"));
        Assert.assertFalse((boolean)message.has("android"));
        Assert.assertFalse((boolean)message.has("ios"));
        httpUriRequest = (HttpPost)httpUriRequests.get(1);
        Assert.assertNotNull((Object)httpUriRequest);
        body = IOUtils.toString((InputStream)httpUriRequest.getEntity().getContent(), (String)"UTF-8");
        jsonMessage = new JSONObject(body);
        Assert.assertEquals((Object)false, (Object)jsonMessage.getBoolean("validate_only"));
        message = jsonMessage.getJSONObject("message");
        JSONObject notification = message.getJSONObject("notification");
        Assert.assertEquals((Object)"My Notification Title", (Object)notification.getString("title"));
        Assert.assertEquals((Object)"My Notification Text  [inline image]  Text", (Object)notification.getString("body"));
        data = message.getJSONObject("data");
        Assert.assertEquals((Object)"http://notification.url/target", (Object)data.getString("url"));
        Assert.assertEquals((Object)"token2", (Object)message.getString("token"));
        Assert.assertFalse((boolean)message.has("android"));
        Assert.assertTrue((boolean)message.has("apns"));
        JSONObject apns = message.getJSONObject("apns");
        Assert.assertTrue((boolean)apns.has("payload"));
        JSONObject payload = apns.getJSONObject("payload");
        Assert.assertTrue((boolean)payload.has("aps"));
        JSONObject aps = payload.getJSONObject("aps");
        Assert.assertTrue((boolean)aps.has("badge"));
        Assert.assertEquals((long)5L, (long)aps.getInt("badge"));
    }

    @Test
    public void shouldSendMessageWhenConfigFileExistsAndResponseNOK() throws Exception {
        Mockito.when((Object)this.httpResponse.getStatusLine()).thenReturn((Object)new BasicStatusLine(new ProtocolVersion("", 1, 2), 401, "Not Authorized"));
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Mockito.any())).thenReturn((Object)this.httpResponse);
        InitParams initParams = new InitParams();
        ValueParam serverKeyParam = new ValueParam();
        serverKeyParam.setName("serviceAccountFilePath");
        serverKeyParam.setValue(this.getClass().getResource("/fcm-test.json").getPath());
        initParams.addParameter((Parameter)serverKeyParam);
        FCMMessagePublisher messagePublisher = new FCMMessagePublisher(this, initParams, this.resourceBundleService, this.webNotificationService, this.httpClient){

            protected PrivateKey getPrivateKeyFromPkcs8(String privateKeyPem) throws IOException {
                return (PrivateKey)Mockito.mock(PrivateKey.class);
            }

            protected String getAccessToken() throws IOException {
                return "fakeAccessToken";
            }
        };
        ArgumentCaptor reqArgs = ArgumentCaptor.forClass(HttpPost.class);
        try {
            messagePublisher.send(new Message("john", "token1", "android", "My Notification Title", "My Notification Body", ""));
            Assert.fail((String)"An exception must be thrown when FCM returns an error");
        }
        catch (Exception e) {
            ((CloseableHttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)1))).execute((HttpUriRequest)reqArgs.capture());
            Assert.assertEquals((Object)"Error sending Push Notification, response is 401 - Not Authorized", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldSendMessageWithTTLWhenConfigFileExistsAndResponseOK() throws Exception {
        Mockito.when((Object)this.httpResponse.getStatusLine()).thenReturn((Object)new BasicStatusLine(new ProtocolVersion("", 1, 2), 200, ""));
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Mockito.any())).thenReturn((Object)this.httpResponse);
        InitParams initParams = this.buildInitParams();
        FCMMessagePublisher messagePublisher = new FCMMessagePublisher(this, initParams, this.resourceBundleService, this.webNotificationService, this.httpClient){

            protected PrivateKey getPrivateKeyFromPkcs8(String privateKeyPem) throws IOException {
                return (PrivateKey)Mockito.mock(PrivateKey.class);
            }

            protected String getAccessToken() throws IOException {
                return "fakeAccessToken";
            }
        };
        ArgumentCaptor reqArgs = ArgumentCaptor.forClass(HttpPost.class);
        messagePublisher.send(new Message("john", "token1", "android", "My Notification Title", "My Notification Body", ""));
        messagePublisher.send(new Message("mary", "token2", "ios", "My Notification Title", "My Notification Body", ""));
        ((CloseableHttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)2))).execute((HttpUriRequest)reqArgs.capture());
        List httpUriRequests = reqArgs.getAllValues();
        Assert.assertNotNull((Object)httpUriRequests);
        HttpPost httpUriRequest = (HttpPost)httpUriRequests.get(0);
        String body = IOUtils.toString((InputStream)httpUriRequest.getEntity().getContent(), (String)"UTF-8");
        JSONObject jsonMessage = new JSONObject(body);
        Assert.assertEquals((Object)false, (Object)jsonMessage.getBoolean("validate_only"));
        JSONObject message = jsonMessage.getJSONObject("message");
        JSONObject notification = message.getJSONObject("data");
        Assert.assertEquals((Object)"My Notification Title", (Object)notification.getString("title"));
        Assert.assertEquals((Object)"My Notification Body", (Object)notification.getString("body"));
        Assert.assertEquals((Object)"token1", (Object)message.getString("token"));
        JSONObject android = message.getJSONObject("android");
        Assert.assertEquals((Object)"60s", (Object)android.getString("ttl"));
        Assert.assertFalse((boolean)message.has("ios"));
        httpUriRequest = (HttpPost)httpUriRequests.get(1);
        Assert.assertNotNull((Object)httpUriRequest);
        body = IOUtils.toString((InputStream)httpUriRequest.getEntity().getContent(), (String)"UTF-8");
        jsonMessage = new JSONObject(body);
        Assert.assertEquals((Object)false, (Object)jsonMessage.getBoolean("validate_only"));
        message = jsonMessage.getJSONObject("message");
        notification = message.getJSONObject("notification");
        Assert.assertEquals((Object)"My Notification Title", (Object)notification.getString("title"));
        Assert.assertEquals((Object)"My Notification Body", (Object)notification.getString("body"));
        Assert.assertEquals((Object)"token2", (Object)message.getString("token"));
        JSONObject ios = message.getJSONObject("apns");
        Assert.assertEquals((Object)"60s", (Object)android.getString("ttl"));
        Assert.assertFalse((boolean)message.has("ios"));
    }

    @Test
    public void shouldNotThrowInvalidTokenExceptionWhenResponseNotInvalidToken() throws Exception {
        Mockito.when((Object)this.httpResponse.getStatusLine()).thenReturn((Object)new BasicStatusLine(new ProtocolVersion("", 1, 2), 400, ""));
        String invalidTokenResponse = "{\n  \"error\": {\n    \"code\": 400,\n    \"message\": \"Request contains an invalid argument.\",\n    \"status\": \"QUOTA_EXCEEDED\"\n  }\n}";
        ByteArrayEntity httpEntity = new ByteArrayEntity(invalidTokenResponse.getBytes());
        Mockito.when((Object)this.httpResponse.getEntity()).thenReturn((Object)httpEntity);
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Mockito.any())).thenReturn((Object)this.httpResponse);
        InitParams initParams = this.buildInitParams();
        FCMMessagePublisher messagePublisher = new FCMMessagePublisher(this, initParams, this.resourceBundleService, this.webNotificationService, this.httpClient){

            protected PrivateKey getPrivateKeyFromPkcs8(String privateKeyPem) throws IOException {
                return (PrivateKey)Mockito.mock(PrivateKey.class);
            }

            protected String getAccessToken() throws IOException {
                return "fakeAccessToken";
            }
        };
        try {
            messagePublisher.send(new Message("", "", "", "", "", ""));
        }
        catch (InvalidTokenException e) {
            Assert.fail((String)"Should return an Exception, not an InvalidTokenException");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(expected=InvalidTokenException.class)
    public void shouldThrowInvalidTokenExceptionWhenResponseUnregistered() throws Exception {
        Mockito.when((Object)this.httpResponse.getStatusLine()).thenReturn((Object)new BasicStatusLine(new ProtocolVersion("", 1, 2), 400, ""));
        String invalidTokenResponse = "{\n  \"error\": {\n    \"code\": 400,\n    \"message\": \"Request contains an invalid argument.\",\n    \"status\": \"UNREGISTERED\"\n  }\n}";
        ByteArrayEntity httpEntity = new ByteArrayEntity(invalidTokenResponse.getBytes());
        Mockito.when((Object)this.httpResponse.getEntity()).thenReturn((Object)httpEntity);
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Mockito.any())).thenReturn((Object)this.httpResponse);
        InitParams initParams = this.buildInitParams();
        FCMMessagePublisher messagePublisher = new FCMMessagePublisher(this, initParams, this.resourceBundleService, this.webNotificationService, this.httpClient){

            protected PrivateKey getPrivateKeyFromPkcs8(String privateKeyPem) throws IOException {
                return (PrivateKey)Mockito.mock(PrivateKey.class);
            }

            protected String getAccessToken() throws IOException {
                return "fakeAccessToken";
            }
        };
        messagePublisher.send(new Message("", "", "", "", "", ""));
    }

    @Test(expected=InvalidTokenException.class)
    public void shouldThrowInvalidTokenExceptionWhenResponseInvalidToken() throws Exception {
        Mockito.when((Object)this.httpResponse.getStatusLine()).thenReturn((Object)new BasicStatusLine(new ProtocolVersion("", 1, 2), 400, ""));
        String invalidTokenResponse = "{\n  \"error\": {\n    \"code\": 400,\n    \"message\": \"Request contains an invalid argument.\",\n    \"status\": \"INVALID_ARGUMENT\",\n    \"details\": [\n      {\n        \"@type\": \"type.googleapis.com/google.firebase.fcm.v1.FcmError\",\n        \"errorCode\": \"INVALID_ARGUMENT\"\n      },\n      {\n        \"@type\": \"type.googleapis.com/google.rpc.BadRequest\",\n        \"fieldViolations\": [\n          {\n            \"field\": \"message.token\",\n            \"description\": \"Invalid registration token\"\n          }\n        ]\n      }\n    ]\n  }\n}";
        ByteArrayEntity httpEntity = new ByteArrayEntity(invalidTokenResponse.getBytes());
        Mockito.when((Object)this.httpResponse.getEntity()).thenReturn((Object)httpEntity);
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Mockito.any())).thenReturn((Object)this.httpResponse);
        InitParams initParams = this.buildInitParams();
        FCMMessagePublisher messagePublisher = new FCMMessagePublisher(this, initParams, this.resourceBundleService, this.webNotificationService, this.httpClient){

            protected PrivateKey getPrivateKeyFromPkcs8(String privateKeyPem) throws IOException {
                return (PrivateKey)Mockito.mock(PrivateKey.class);
            }

            protected String getAccessToken() throws IOException {
                return "fakeAccessToken";
            }
        };
        messagePublisher.send(new Message("", "", "", "", "", ""));
    }

    private InitParams buildInitParams() {
        InitParams initParams = new InitParams();
        ValueParam serverKeyParam = new ValueParam();
        serverKeyParam.setName("serviceAccountFilePath");
        serverKeyParam.setValue(this.getClass().getResource("/fcm-test.json").getPath());
        initParams.addParameter((Parameter)serverKeyParam);
        ValueParam messageExpirationTimeParam = new ValueParam();
        messageExpirationTimeParam.setName("messageExpirationTime");
        messageExpirationTimeParam.setValue("60");
        initParams.addParameter((Parameter)messageExpirationTimeParam);
        return initParams;
    }
}

