/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.plugin.social;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.service.PermanentLinkService;
import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import lombok.Generated;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewUserPwaNotificationPlugin
implements PwaNotificationPlugin {
    private static final String TITLE_LABEL_KEY = "pwa.notification.NewUserPlugin.title";
    @Autowired
    private ResourceBundleService resourceBundleService;
    @Autowired
    private PermanentLinkService permanentLinkService;
    @Autowired
    private BrandingService brandingService;
    @Autowired
    private IdentityManager identityManager;

    public String getId() {
        return "NewUserPlugin";
    }

    public PwaNotificationMessage process(NotificationInfo notification, LocaleConfig localeConfig) {
        PwaNotificationMessage notificationMessage = new PwaNotificationMessage();
        String username = notification.getValueOwnerParameter(SocialNotificationUtils.REMOTE_ID.getKey());
        notificationMessage.setTitle(this.resourceBundleService.getSharedString(TITLE_LABEL_KEY, localeConfig.getLocale()).replace("{0}", this.getFullName(username)).replace("{1}", this.brandingService.getCompanyName()));
        notificationMessage.setUrl(this.permanentLinkService.getPermanentLink(new PermanentLinkObject("user", username)));
        return notificationMessage;
    }

    @Generated
    public IdentityManager getIdentityManager() {
        return this.identityManager;
    }
}

