/*
 * Decompiled with CFR 0.152.
 */
package nl.martijndwars.webpush;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.concurrent.CompletableFuture;
import nl.martijndwars.webpush.AbstractPushService;
import nl.martijndwars.webpush.Encoding;
import nl.martijndwars.webpush.HttpRequest;
import nl.martijndwars.webpush.Notification;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;
import org.jose4j.lang.JoseException;

public class PushAsyncService
extends AbstractPushService<PushAsyncService> {
    private final AsyncHttpClient httpClient = Dsl.asyncHttpClient();

    public PushAsyncService() {
    }

    public PushAsyncService(String gcmApiKey) {
        super(gcmApiKey);
    }

    public PushAsyncService(KeyPair keyPair) {
        super(keyPair);
    }

    public PushAsyncService(KeyPair keyPair, String subject) {
        super(keyPair, subject);
    }

    public PushAsyncService(String publicKey, String privateKey) throws GeneralSecurityException {
        super(publicKey, privateKey);
    }

    public PushAsyncService(String publicKey, String privateKey, String subject) throws GeneralSecurityException {
        super(publicKey, privateKey, subject);
    }

    public CompletableFuture<Response> send(Notification notification, Encoding encoding) throws GeneralSecurityException, IOException, JoseException {
        BoundRequestBuilder httpPost = this.preparePost(notification, encoding);
        return httpPost.execute().toCompletableFuture();
    }

    public CompletableFuture<Response> send(Notification notification) throws GeneralSecurityException, IOException, JoseException {
        return this.send(notification, Encoding.AES128GCM);
    }

    public BoundRequestBuilder preparePost(Notification notification, Encoding encoding) throws GeneralSecurityException, IOException, JoseException {
        HttpRequest request = this.prepareRequest(notification, encoding);
        BoundRequestBuilder httpPost = this.httpClient.preparePost(request.getUrl());
        request.getHeaders().forEach((arg_0, arg_1) -> ((BoundRequestBuilder)httpPost).addHeader(arg_0, arg_1));
        if (request.getBody() != null) {
            httpPost.setBody(request.getBody());
        }
        return httpPost;
    }
}

