/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.plugin.notes;

import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import lombok.Generated;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"notes"})
@Component
public class NotePostedMentionPwaNotificationPlugin
implements PwaNotificationPlugin {
    private static final String TITLE_LABEL_KEY = "pwa.notification.MentionInNoteNotificationPlugin.title";
    @Autowired
    private ResourceBundleService resourceBundleService;
    @Autowired
    private IdentityManager identityManager;

    public String getId() {
        return "MentionInNoteNotificationPlugin";
    }

    public PwaNotificationMessage process(NotificationInfo notification, LocaleConfig localeConfig) {
        PwaNotificationMessage notificationMessage = new PwaNotificationMessage();
        notificationMessage.setTitle(this.resourceBundleService.getSharedString(TITLE_LABEL_KEY, localeConfig.getLocale()).replace("{0}", notification.getValueOwnerParameter("CURRENT_USER")));
        notificationMessage.setBody(notification.getValueOwnerParameter("NOTE_TITLE"));
        notificationMessage.setUrl(notification.getValueOwnerParameter("NOTE_URL"));
        return notificationMessage;
    }

    @Generated
    public IdentityManager getIdentityManager() {
        return this.identityManager;
    }
}

