/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.plugin.wallet;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.service.PermanentLinkService;
import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import java.util.Locale;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"wallet"})
@Component
public class EtherSenderPwaNotificationPlugin
implements PwaNotificationPlugin {
    private static final String TITLE_LABEL_KEY = "pwa.notification.EtherSenderNotificationPlugin.title";
    @Autowired
    private ResourceBundleService resourceBundleService;
    @Autowired
    private PermanentLinkService permanentLinkService;

    public String getId() {
        return "EtherSenderNotificationPlugin";
    }

    public PwaNotificationMessage process(NotificationInfo notification, LocaleConfig localeConfig) {
        PwaNotificationMessage notificationMessage = new PwaNotificationMessage();
        Locale locale = localeConfig.getLocale();
        notificationMessage.setTitle(this.resourceBundleService.getSharedString(TITLE_LABEL_KEY, locale));
        PermanentLinkObject object = new PermanentLinkObject("wallet", notification.getValueOwnerParameter("senderIdentityId"));
        object.addParameter("transactionHash", notification.getValueOwnerParameter("hash"));
        notificationMessage.setUrl(this.permanentLinkService.getPermanentLink(object));
        return notificationMessage;
    }
}

