/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.plugin.content;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.service.PermanentLinkService;
import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import lombok.Generated;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"content"})
@Component
public class NewsPostedMentionPwaNotificationPlugin
implements PwaNotificationPlugin {
    private static final String TITLE_LABEL_KEY = "pwa.notification.MentionInNewsNotificationPlugin.title";
    @Autowired
    private ResourceBundleService resourceBundleService;
    @Autowired
    private PermanentLinkService permanentLinkService;
    @Autowired
    private IdentityManager identityManager;

    public String getId() {
        return "MentionInNewsNotificationPlugin";
    }

    public PwaNotificationMessage process(NotificationInfo notification, LocaleConfig localeConfig) {
        PwaNotificationMessage notificationMessage = new PwaNotificationMessage();
        notificationMessage.setTitle(this.resourceBundleService.getSharedString(TITLE_LABEL_KEY, localeConfig.getLocale()).replace("{0}", notification.getValueOwnerParameter("CURRENT_USER")));
        notificationMessage.setBody(notification.getValueOwnerParameter("CONTENT_TITLE"));
        notificationMessage.setUrl(this.permanentLinkService.getPermanentLink(new PermanentLinkObject("news", notification.getValueOwnerParameter("NEWS_ID"))));
        return notificationMessage;
    }

    @Generated
    public IdentityManager getIdentityManager() {
        return this.identityManager;
    }
}

