/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.listener;

import io.meeds.pwa.listener.WebNotificationSentListener;
import io.meeds.pwa.service.PwaNotificationService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={WebNotificationSentListener.class})
@ExtendWith(value={MockitoExtension.class})
public class WebNotificationSentListenerTest {
    private static final String NOTIFICATION_ID = "5";
    @MockBean
    private PwaNotificationService pwaNotificationService;
    @MockBean
    private ListenerService listenerService;
    @Autowired
    private WebNotificationSentListener webNotificationSentListener;
    @Mock
    private Event<Object, Object> event;

    @Test
    public void init() {
        this.webNotificationSentListener.init();
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).addListener(ArgumentMatchers.anyString(), (ListenerBase)ArgumentMatchers.eq((Object)this.webNotificationSentListener));
        ((ListenerService)Mockito.verify((Object)this.listenerService)).addListener("notification.web.saved", (ListenerBase)this.webNotificationSentListener);
    }

    @Test
    public void onEventWhenNotHandled() throws Exception {
        this.webNotificationSentListener.onEvent(this.event);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.pwaNotificationService});
    }

    @Test
    public void onEventWhenWebNotifUpdated() throws Exception {
        Mockito.when((Object)this.event.getEventName()).thenReturn((Object)"notification.web.saved");
        Mockito.when((Object)this.event.getData()).thenReturn((Object)false);
        this.webNotificationSentListener.onEvent(this.event);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.pwaNotificationService});
    }

    @Test
    public void onEventWhenWebNotifCreated() throws Exception {
        Mockito.when((Object)this.event.getEventName()).thenReturn((Object)"notification.web.saved");
        Mockito.when((Object)this.event.getData()).thenReturn((Object)true);
        Mockito.when((Object)this.event.getSource()).thenReturn((Object)NOTIFICATION_ID);
        this.webNotificationSentListener.onEvent(this.event);
        ((PwaNotificationService)Mockito.verify((Object)this.pwaNotificationService)).create(Long.parseLong(NOTIFICATION_ID));
    }
}

