/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.service;

import io.meeds.pwa.model.UserPushSubscription;
import io.meeds.pwa.storage.PwaSubscriptionStorage;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PwaSubscriptionService {
    public static final String PWA_INSTALLED = "pwa.installed";
    public static final String PWA_UNINSTALLED = "pwa.uninstalled";
    private static final Log LOG = ExoLogger.getLogger(PwaSubscriptionService.class);
    @Autowired
    private PwaSubscriptionStorage pwaSubscriptionStorage;
    @Autowired
    private ListenerService listenerService;

    public List<UserPushSubscription> getSubscriptions(String username) {
        return this.pwaSubscriptionStorage.get(username);
    }

    public void createSubscription(UserPushSubscription subscription, String username) {
        List<UserPushSubscription> subscriptions = this.pwaSubscriptionStorage.get(username);
        String endpoint = subscription.getEndpoint();
        if (subscriptions.stream().noneMatch(s -> StringUtils.equals((CharSequence)s.getEndpoint(), (CharSequence)endpoint))) {
            LOG.info("Create new subscription with id {} for user {} and endpoint {}", new Object[]{subscription.getId(), username, this.getSubscriptionDomain(endpoint)});
            this.pwaSubscriptionStorage.create(subscription, username);
            this.listenerService.broadcast(PWA_INSTALLED, (Object)username, (Object)subscription);
        } else {
            LOG.debug("Subscription for endpoint {} already exists for user {}", new Object[]{this.getSubscriptionDomain(endpoint), username});
        }
    }

    public void deleteSubscription(String id, String username) {
        this.deleteSubscription(id, username, true);
    }

    public void deleteSubscription(String id, String username, boolean userAction) {
        UserPushSubscription subscription = this.pwaSubscriptionStorage.delete(id, username);
        if (userAction && subscription != null) {
            this.listenerService.broadcast(PWA_UNINSTALLED, (Object)username, (Object)subscription);
        }
    }

    public void deleteAllSubscriptions(String username) {
        List<UserPushSubscription> subscriptions = this.getSubscriptions(username);
        subscriptions.forEach(s -> this.deleteSubscription(s.getId(), username));
    }

    private String getSubscriptionDomain(String endpoint) {
        return endpoint.substring(0, endpoint.indexOf("/", 15));
    }
}

