/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.service;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.pwa.model.ManifestIcon;
import io.meeds.pwa.model.PwaManifest;
import io.meeds.pwa.model.PwaManifestUpdate;
import io.meeds.pwa.plugin.PwaShortcutPlugin;
import io.meeds.pwa.service.PwaManifestService$AjcClosure1;
import io.meeds.social.util.JsonUtils;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.branding.model.BrandingFile;
import org.exoplatform.portal.branding.model.Favicon;
import org.exoplatform.portal.branding.model.Logo;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.thumbnail.ImageResizeService;
import org.exoplatform.services.thumbnail.ImageThumbnailService;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PwaManifestService {
    private static final Log LOG;
    public static final String RESET_ATTACHMENT_ID = "0";
    public static final String DEPRECATED_PUSH_CHANNEL_ID = "PUSH_CHANNEL";
    public static final String PWA_LARGE_ICON_BASE_PATH = "/pwa/rest/manifest/largeIcon?v=";
    public static final String PWA_SMALL_ICON_BASE_PATH = "/pwa/rest/manifest/smallIcon?v=";
    public static final String FILE_API_NAME_SPACE = "CompanyBranding";
    public static final String PWA_LARGE_ICON_NAME = "largeIcon.png";
    public static final String PWA_SMALL_ICON_NAME = "smallIcon.png";
    public static final String PWA_FEATURE = "pwa";
    public static final String PWA_NAME = "pwa.name";
    public static final String PWA_DESCRIPTION = "pwa.description";
    public static final String PWA_BACKGROUND_COLOR = "pwa.backgroundColor";
    public static final String PWA_THEME_COLOR = "pwa.themeColor";
    public static final String PWA_LARGE_ICON = "pwa.illustration512";
    public static final String PWA_SMALL_ICON = "pwa.illustration71";
    public static final boolean DEVELOPPING;
    public static final String DEFAULT_DOMAIN_NAME = "localhost";
    public static final String SHORTCUTS_NAME = "$shortcuts";
    public static final String DOMAIN_URL_PARAM_NAME = "gatein.email.domain.url";
    @Autowired
    private SettingService settingService;
    @Autowired
    private FileService fileService;
    @Autowired
    private UploadService uploadService;
    @Autowired
    private BrandingService brandingService;
    @Autowired
    private ConfigurationManager configurationManager;
    @Autowired
    private ExoFeatureService featureService;
    @Autowired
    private ResourceBundleService resourceBundleService;
    @Autowired
    private ImageThumbnailService imageThumbnailService;
    @Autowired
    private ImageResizeService imageResizeService;
    @Autowired
    private ChannelManager channelManager;
    @Autowired
    private ListenerService listenerService;
    @Value(value="${pwa.manifest.id:}")
    private String manifestId;
    @Value(value="${pwa.manifest.version:}")
    private String manifestVersion;
    @Value(value="${pwa.manifest.description:}")
    private String manifestDescriptionKey;
    @Value(value="${pwa.manifest.path:jar:/pwa/manifest.json}")
    private String pwaManifestPath;
    @Autowired(required=false)
    private List<PwaShortcutPlugin> shortcutPlugins;
    private PwaManifest pwaManifest = new PwaManifest();
    private ManifestIcon largeIcon = null;
    private ManifestIcon smallIcon = null;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    @ContainerTransactional
    public void init() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        PwaManifestService$AjcClosure1 pwaManifestService$AjcClosure1 = new PwaManifestService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(pwaManifestService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public boolean isPwaEnabled() {
        return this.pwaManifest.isEnabled();
    }

    public long getManifestHash() {
        return this.getManifestHash(null);
    }

    public long getManifestHash(String username) {
        return Objects.hash(this.brandingService.getLastUpdatedTime(), Objects.hash(this.getManifestContent(username)));
    }

    public String getManifestContent() {
        return this.getManifestContent(null);
    }

    public String getManifestContent(String username) {
        String content;
        if (this.pwaManifest.getContent() == null) {
            this.computePwaProperties();
            content = this.pwaManifest.getContent(this.brandingService.getBrandingInformation(false));
        } else {
            content = this.pwaManifest.getContent();
        }
        if (content == null) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)username) && CollectionUtils.isNotEmpty(this.shortcutPlugins)) {
            List shortcuts = this.shortcutPlugins.stream().map(p -> p.getShortcuts(username)).flatMap(Collection::stream).toList();
            return content.replace(SHORTCUTS_NAME, JsonUtils.toJsonString(shortcuts));
        }
        return content.replace(SHORTCUTS_NAME, "[]");
    }

    public String getThemeColor() {
        return this.pwaManifest.isEnabled() && this.pwaManifest.getThemeColor() != null ? this.pwaManifest.getThemeColor() : (String)this.brandingService.getThemeStyle().get("primaryColor");
    }

    public void updateManifest(PwaManifestUpdate manifest, String username) {
        this.validateCSSInputs(manifest);
        try {
            this.featureService.saveActiveFeature(PWA_FEATURE, manifest.isEnabled());
            this.updatePropertyValue(PWA_NAME, manifest.getName(), false);
            this.updatePropertyValue(PWA_DESCRIPTION, manifest.getDescription(), false);
            this.updatePropertyValue(PWA_BACKGROUND_COLOR, manifest.getBackgroundColor(), false);
            this.updatePropertyValue(PWA_THEME_COLOR, manifest.getThemeColor(), false);
            this.updateBrandingFile(manifest.getLargeIconUploadId(), PWA_LARGE_ICON_NAME, this.getLargeIcon().getFileId(), PWA_LARGE_ICON, username);
            this.updateBrandingFile(manifest.getSmallIconUploadId(), PWA_SMALL_ICON_NAME, this.getSmallIcon().getFileId(), PWA_SMALL_ICON, username);
        }
        finally {
            this.pwaManifest.setContent(null);
            this.largeIcon = null;
            this.smallIcon = null;
            this.getManifestContent(username);
        }
    }

    public ManifestIcon getLargeIcon() {
        if (this.largeIcon == null) {
            try {
                Long imageId = this.getPropertyValueLong(PWA_LARGE_ICON);
                if (imageId != null) {
                    this.largeIcon = this.retrieveStoredBrandingFile(imageId, new ManifestIcon());
                } else {
                    Logo brandingLogo = this.brandingService.getLogo();
                    if (brandingLogo != null) {
                        this.largeIcon = new ManifestIcon(null, brandingLogo.getSize(), brandingLogo.getData(), brandingLogo.getUpdatedDate(), brandingLogo.getFileId());
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Error retrieving manifest large icon", (Throwable)e);
            }
        }
        return this.largeIcon;
    }

    public ManifestIcon getLargeIcon(String dimensions) {
        ManifestIcon manifestLargeIcon = this.getLargeIcon();
        return (ManifestIcon)this.getBrandingFileThumbnail(manifestLargeIcon, dimensions);
    }

    public ManifestIcon getSmallIcon() {
        if (this.smallIcon == null) {
            try {
                Long imageId = this.getPropertyValueLong(PWA_SMALL_ICON);
                if (imageId != null) {
                    this.smallIcon = this.retrieveStoredBrandingFile(imageId, new ManifestIcon());
                } else {
                    Favicon brandingFavicon = this.brandingService.getFavicon();
                    if (brandingFavicon != null) {
                        this.smallIcon = new ManifestIcon(null, brandingFavicon.getSize(), brandingFavicon.getData(), brandingFavicon.getUpdatedDate(), brandingFavicon.getFileId());
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Error retrieving manifest small icon", (Throwable)e);
            }
        }
        return this.smallIcon;
    }

    public ManifestIcon getSmallIcon(String dimensions) {
        ManifestIcon brandingFile = this.getSmallIcon();
        return (ManifestIcon)this.getBrandingFileThumbnail(brandingFile, dimensions);
    }

    public String getLargeIconPath() {
        ManifestIcon manifestIcon = this.getLargeIcon();
        return manifestIcon == null ? null : PWA_LARGE_ICON_BASE_PATH + Objects.hash(manifestIcon.getUpdatedDate());
    }

    public String getSmallIconPath() {
        ManifestIcon manifestIcon = this.getSmallIcon();
        return manifestIcon == null ? null : PWA_SMALL_ICON_BASE_PATH + Objects.hash(manifestIcon.getUpdatedDate());
    }

    public void refreshManifest() {
        this.pwaManifest.setContent(null);
    }

    private void updateBrandingFile(String uploadId, String fileName, Long fileId, String settingKey, String username) {
        try {
            if (!(!StringUtils.equals((CharSequence)RESET_ATTACHMENT_ID, (CharSequence)uploadId) || this.brandingService.getLogoId() != null && fileId.longValue() == this.brandingService.getLogoId().longValue() || this.brandingService.getFaviconId() != null && fileId.longValue() == this.brandingService.getFaviconId().longValue())) {
                this.removeBrandingFile(fileId, settingKey);
            } else if (!StringUtils.equals((CharSequence)RESET_ATTACHMENT_ID, (CharSequence)uploadId) && StringUtils.isNotBlank((CharSequence)uploadId)) {
                this.updateBrandingFileByUploadId(uploadId, fileName, settingKey, username);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while updating manifest icon", e);
        }
    }

    private void removeBrandingFile(Long fileId, String settingKey) {
        if (fileId != null && fileId > 0L) {
            this.fileService.deleteFile(fileId.longValue());
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL, settingKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBrandingFileByUploadId(String uploadId, String fileName, String settingKey, String username) throws Exception {
        InputStream inputStream = this.getUploadDataAsStream(uploadId);
        if (inputStream == null) {
            throw new IllegalArgumentException("Cannot update " + fileName + ", the object must contain the image data or an upload id");
        }
        try {
            int size = inputStream.available();
            FileItem fileItem = new FileItem(Long.valueOf(0L), fileName, "image/png", FILE_API_NAME_SPACE, (long)size, new Date(), username, false, inputStream);
            fileItem = this.fileService.writeFile(fileItem);
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, settingKey, SettingValue.create((String)String.valueOf(fileItem.getFileInfo().getId())));
        }
        finally {
            inputStream.close();
        }
    }

    private void computePwaProperties() {
        this.pwaManifest.setEnabled(this.featureService.isActiveFeature(PWA_FEATURE));
        this.updateNativeAppPushChannelStatus();
        String domainName = this.getDomainName();
        this.pwaManifest.setManifestId(domainName);
        this.pwaManifest.setDomainName(domainName);
        this.pwaManifest.setFullDomainUrl(this.getFullDomainUrl());
        if (this.pwaManifestPath != null && (this.pwaManifest.getTemplate() == null || DEVELOPPING)) {
            try (InputStream inputStream = this.configurationManager.getInputStream(this.pwaManifestPath);){
                if (inputStream != null) {
                    this.pwaManifest.setTemplate(IOUtil.getStreamContentAsString((InputStream)inputStream));
                }
            }
        }
        this.pwaManifest.setName(this.getPropertyValue(PWA_NAME));
        this.pwaManifest.setManifestId(this.manifestId);
        this.pwaManifest.setVersion(this.manifestVersion);
        this.pwaManifest.setBackgroundColor(this.getPropertyValue(PWA_BACKGROUND_COLOR));
        this.pwaManifest.setThemeColor(this.getPropertyValue(PWA_THEME_COLOR));
        this.computePwaDescription();
        this.largeIcon = null;
        this.pwaManifest.setLargeIconPath(this.getLargeIconPath());
        this.smallIcon = null;
        this.pwaManifest.setSmallIconPath(this.getSmallIconPath());
    }

    private void computePwaDescription() {
        this.pwaManifest.setDescriptionKey(this.manifestDescriptionKey);
        this.pwaManifest.setDescription(this.getPropertyValue(PWA_DESCRIPTION));
        if (this.pwaManifest.getDescription() == null && this.pwaManifest.getDescriptionKey() != null && this.brandingService.getDefaultLanguage() != null) {
            this.pwaManifest.setDescription(this.resourceBundleService.getSharedString(this.pwaManifest.getDescriptionKey(), Locale.forLanguageTag(this.brandingService.getDefaultLanguage())));
        }
    }

    private String getDomainName() {
        String domain = System.getProperty(DOMAIN_URL_PARAM_NAME);
        if (StringUtils.isBlank((CharSequence)domain)) {
            return DEFAULT_DOMAIN_NAME;
        }
        return domain.replace("https://", "").replace("http://", "").replaceAll("(:\\d*)?/?", "");
    }

    private String getFullDomainUrl() {
        String domain = System.getProperty(DOMAIN_URL_PARAM_NAME);
        if (StringUtils.isBlank((CharSequence)domain)) {
            return "http://localhost:8080";
        }
        return domain.replaceAll("(https?://)([^:/]*)(:\\d*)?(.*)", "$1$2$3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getUploadDataAsStream(String uploadId) throws FileNotFoundException {
        UploadResource uploadResource = this.uploadService.getUploadResource(uploadId);
        if (uploadResource == null) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(uploadResource.getStoreLocation()));
            return fileInputStream;
        }
        finally {
            this.uploadService.removeUploadResource(uploadId);
        }
    }

    private <T extends BrandingFile> T retrieveStoredBrandingFile(long imageId, T brandingFile) throws FileStorageException {
        FileItem fileItem = this.fileService.getFile(imageId);
        if (fileItem != null) {
            brandingFile.setData(fileItem.getAsByte());
            brandingFile.setSize(fileItem.getFileInfo().getSize());
            brandingFile.setUpdatedDate(fileItem.getFileInfo().getUpdatedDate().getTime());
            brandingFile.setFileId(imageId);
        }
        return brandingFile;
    }

    private <T extends BrandingFile> T getBrandingFileThumbnail(BrandingFile brandingFile, String dimensions) {
        if (StringUtils.isBlank((CharSequence)dimensions) || !StringUtils.contains((CharSequence)dimensions, (CharSequence)"x")) {
            return (T)brandingFile;
        }
        brandingFile = (BrandingFile)brandingFile.cloneFile();
        FileItem fileItem = this.fileService.getFile(brandingFile.getFileId());
        Integer[] dimensionParts = (Integer[])Arrays.stream(dimensions.split("x")).map(Integer::parseInt).toArray(Integer[]::new);
        FileItem thumbnailFileItem = this.imageThumbnailService.getOrCreateThumbnail(this::scaleImage, fileItem, dimensionParts[0].intValue(), dimensionParts[1].intValue());
        brandingFile.setFileId(thumbnailFileItem.getFileInfo().getId().longValue());
        try (InputStream inputStream = thumbnailFileItem.getAsStream();){
            brandingFile.setData(IOUtils.toByteArray((InputStream)inputStream));
        }
        return (T)brandingFile;
    }

    private byte[] scaleImage(byte[] image, int width, int height, boolean fitExact, boolean ultraQuality) throws Exception {
        return this.imageResizeService.scaleImage(image, width, height, true, true);
    }

    private String getPropertyValue(String key) {
        return this.getPropertyValue(key, null);
    }

    private Long getPropertyValueLong(String key) {
        String value = this.getPropertyValue(key, null);
        return StringUtils.isBlank((CharSequence)value) ? null : Long.valueOf(Long.parseLong(value));
    }

    private String getPropertyValue(String key, String defaultValue) {
        SettingValue value = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, key);
        if (value != null && value.getValue() != null && StringUtils.isNotBlank((CharSequence)value.getValue().toString())) {
            return value.getValue().toString();
        }
        return defaultValue;
    }

    private void updatePropertyValue(String key, String value, boolean updateLastUpdatedTime) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL, key);
        } else {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, key, SettingValue.create((String)value));
        }
        if (updateLastUpdatedTime) {
            this.refreshManifest();
        }
    }

    private void validateCSSInputs(PwaManifestUpdate manifest) {
        Arrays.asList(manifest.getBackgroundColor(), manifest.getThemeColor()).forEach(this::validateCSSStyleValue);
    }

    private void validateCSSStyleValue(String value) {
        if (StringUtils.isNotBlank((CharSequence)value) && (value.contains("javascript") || value.contains("eval"))) {
            throw new IllegalArgumentException(String.format("Invalid css value input %s", value));
        }
    }

    private void updateNativeAppPushChannelStatus() {
        AbstractChannel channel = this.channelManager.getChannel(ChannelKey.key((String)DEPRECATED_PUSH_CHANNEL_ID));
        if (channel != null) {
            channel.setEnabled(!this.pwaManifest.isEnabled());
        }
    }

    @Generated
    public String getPwaManifestPath() {
        return this.pwaManifestPath;
    }

    @Generated
    public PwaManifest getPwaManifest() {
        return this.pwaManifest;
    }

    static {
        PwaManifestService.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(PwaManifestService.class);
        DEVELOPPING = PropertyManager.isDevelopping();
    }

    static final /* synthetic */ void init_aroundBody0(PwaManifestService ajc$this, JoinPoint joinPoint) {
        try {
            ajc$this.computePwaProperties();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while initializing PWA properties", (Throwable)e);
        }
        ajc$this.listenerService.addListener("branding.updated", event -> this.computePwaProperties());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PwaManifestService.java", PwaManifestService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "io.meeds.pwa.service.PwaManifestService", "", "", "", "void"), 179);
    }
}

