/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.pwa.service;

import io.meeds.pwa.model.UserPushSubscription;
import io.meeds.pwa.service.PwaSubscriptionService;
import io.meeds.pwa.storage.PwaSubscriptionStorage;
import java.util.Collections;
import java.util.List;
import org.exoplatform.services.listener.ListenerService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={PwaSubscriptionService.class})
public class PwaSubscriptionServiceTest {
    private static final String SUBSCRIPTION_ID = "subscriptionId";
    private static final String SUBSCRIPTION_ENDPOINT = "http://localhost/endpoint";
    private static final String TEST_USER = "testUser";
    @MockBean
    private PwaSubscriptionStorage pwaSubscriptionStorage;
    @MockBean
    private ListenerService listenerService;
    @Autowired
    private PwaSubscriptionService pwaSubscriptionService;
    @Mock
    private UserPushSubscription userPushSubscription;

    @Test
    public void getSubscriptions() {
        List subscriptions = this.pwaSubscriptionService.getSubscriptions(TEST_USER);
        Assertions.assertNotNull((Object)subscriptions);
        ((PwaSubscriptionStorage)Mockito.verify((Object)this.pwaSubscriptionStorage)).get(TEST_USER);
    }

    @Test
    public void createSubscriptionWhenExists() {
        Mockito.when((Object)this.pwaSubscriptionStorage.get(TEST_USER)).thenReturn(Collections.singletonList(this.userPushSubscription));
        Mockito.when((Object)this.userPushSubscription.getEndpoint()).thenReturn((Object)SUBSCRIPTION_ENDPOINT);
        this.pwaSubscriptionService.createSubscription(this.userPushSubscription, TEST_USER);
        ((PwaSubscriptionStorage)Mockito.verify((Object)this.pwaSubscriptionStorage, (VerificationMode)Mockito.never())).create(this.userPushSubscription, TEST_USER);
        Mockito.when((Object)this.pwaSubscriptionStorage.get(TEST_USER)).thenReturn(Collections.emptyList());
        this.pwaSubscriptionService.createSubscription(this.userPushSubscription, TEST_USER);
        ((PwaSubscriptionStorage)Mockito.verify((Object)this.pwaSubscriptionStorage)).create(this.userPushSubscription, TEST_USER);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("pwa.installed", (Object)TEST_USER, (Object)this.userPushSubscription);
    }

    @Test
    public void deleteSubscription() {
        Mockito.when((Object)this.pwaSubscriptionStorage.delete(SUBSCRIPTION_ID, TEST_USER)).thenReturn((Object)this.userPushSubscription);
        this.pwaSubscriptionService.deleteSubscription(SUBSCRIPTION_ID, TEST_USER);
        ((PwaSubscriptionStorage)Mockito.verify((Object)this.pwaSubscriptionStorage)).delete(SUBSCRIPTION_ID, TEST_USER);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("pwa.uninstalled", (Object)TEST_USER, (Object)this.userPushSubscription);
    }

    @Test
    public void deleteAllSubscriptions() {
        Mockito.when((Object)this.pwaSubscriptionStorage.get(TEST_USER)).thenReturn(Collections.singletonList(this.userPushSubscription));
        Mockito.when((Object)this.userPushSubscription.getId()).thenReturn((Object)SUBSCRIPTION_ID);
        this.pwaSubscriptionService.deleteAllSubscriptions(TEST_USER);
        ((PwaSubscriptionStorage)Mockito.verify((Object)this.pwaSubscriptionStorage)).delete(SUBSCRIPTION_ID, TEST_USER);
    }
}

