/*
 * This file is part of the Meeds project (https://meeds.io/).
 * 
 * Copyright (C) 2020 - 2023 Meeds Association contact@meeds.io
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package io.meeds.qa.ui.steps;

import java.util.Map;

import io.meeds.qa.ui.pages.TasksPage;

public class TasksSteps {

  private static final String TASK_NAME_PARAM = "taskName";

  private TasksPage           tasksPage;

  public void addFourLabelToProject(String label1, String label2, String label3, String label4) {
    tasksPage.addFourLabelToProject(label1, label2, label3, label4);
  }

  public void addLabelToProject(String label) {
    tasksPage.addLabel(label);
  }

  public void addLabelToTask(String label) {
    tasksPage.addLabelToTask(label);
  }

  public void addNewCommentInTask(String comment) {
    tasksPage.clickToAddNewCommentInTask();
    tasksPage.commentTask(comment);
  }

  public void clickToAddNewComment() {
    tasksPage.clickToAddNewCommentInTask();
  }

  public void addNewCommentWithAttachedImages(String comment) {
    tasksPage.clickToAddNewCommentInTask();
    tasksPage.addNewCommentWithAttachedImages(comment);
  }

  public void addNewCommentInTaskWithMentioningTheFirstUserInTask(String comment, String user) {
    tasksPage.addNewCommentInTaskWithMentioningTheFirstUserInTask(comment, user);
  }

  public void addOtherCommentInTask(String comment) {
    tasksPage.addOtherCommentInTask();
    tasksPage.commentTask(comment);
  }

  public void addProject(String projectName) {
    tasksPage.addProject(projectName);
  }

  public void addProjectWithDescription(String projectName, String description) {
    tasksPage.addProjectWithDescription(projectName, description);
  }

  public void addProjectWithFirstCreatedUserAsManger(String projectName, String fullName) {
    tasksPage.addProjectWithFirstCreatedUserAsManger(projectName, fullName);
  }

  public void addProjectWithFirstUserAsParticipant(String projectName, String participant) {
    tasksPage.addProjectWithFirstUserAsParticipant(projectName, participant);
  }

  public void addProjectWithManager(String projectName, String fullName) {
    tasksPage.addProjectWithManager(projectName, fullName);
  }

  public void addProjectWithManagerAndParticipant(String projectName, String manager, String participant) {
    tasksPage.addProjectWithManagerAndParticipant(projectName, manager, participant);
  }

  public void addProjectWithParticipant(String projectName, String lastName) {
    tasksPage.addProjectWithParticipant(projectName, lastName);

  }

  public void addSecondUserToProject(String lastName) {
    tasksPage.addSecondUserToProject(lastName);
  }

  public void addSimpleTaskProject(Map<String, String> taskDetails) {
    tasksPage.clickQuickAddTaskButton();
    tasksPage.setQuickTaskName(taskDetails.get(TASK_NAME_PARAM));
    tasksPage.saveQuickTask();
  }

  public void addSixLabelToProject(String label1, String label2, String label3, String label4, String label5, String label6) {
    tasksPage.addSixLabelToProject(label1, label2, label3, label4, label5, label6);
  }

  public void addTaskInProject(Map<String, String> taskDetails) {
    tasksPage.clickAddTaskButton();
    tasksPage.setTaskName(taskDetails.get(TASK_NAME_PARAM));
    tasksPage.saveAddTaskButton();
  }

  public void setTaskName(String taskName) {
    tasksPage.setTaskName(taskName);
  }

  public void clickSaveTaskButton() {
    tasksPage.saveAddTaskButton();
  }

  public void addTaskWithLabelInProject(String label, Map<String, String> taskDetails) {
    tasksPage.clickAddTaskButton();
    tasksPage.setTaskName(taskDetails.get(TASK_NAME_PARAM));
    tasksPage.addLabel(label);
    tasksPage.saveAddTaskButton();
  }

  public void assignTaskToMe() {
    tasksPage.assignTaskToMe();
  }

  public void assignTaskToUser(String user) {
    tasksPage.assignTaskToUser(user);
  }

  public void boardViewIsDisplayedByDefault() {
    tasksPage.boardViewIsDisplayedByDefault();
  }

  public void cancelFilterButtonIsDisplayed() {
    tasksPage.cancelFilterButtonIsDisplayed();
  }

  public void checkAttachmentDisplay(String attachmentName) {
    tasksPage.checkAttachmentDisplay(attachmentName);
  }

  public void checkClonedProject(String projectName) {

    tasksPage.checkClonedProject(projectName);
  }

  public void checkClonedTask(String taskName) {
    tasksPage.checkClonedTask(taskName);

  }

  public void checkDeletedProject(String projectName) {
    tasksPage.checkDeletedProject(projectName);
  }

  public void checkDeletedStatus(String statusColumn) {
    tasksPage.checkDeletedStatus(statusColumn);
  }

  public void checkDeletedTask(String taskName) {
    tasksPage.checkDeletedTaskIsNotDisplayed(taskName);
  }

  public void checkDescriptionDisplay(String description) {
    tasksPage.checkDescriptionDisplay(description);
  }

  public void checkDisplayOfFilterByProject() {
    tasksPage.checkDisplayOfFilterByProject();
  }

  public void checkDisplayOfFilterByTask() {
    tasksPage.checkDisplayOfFilterByTask();
  }

  public void checkEditedProject(String projectName, String description) {
    tasksPage.checkUpdatedProject(projectName, description);
  }

  public void checkFirstStatusColumn(String columnStatus) {
    tasksPage.checkFirstStatusColumn(columnStatus);
  }

  public void checkGroupingSelected(String groupingValue) {
    tasksPage.checkGroupingSelected(groupingValue);
  }

  public void checkLastStatusColumn(String columnStatus) {
    tasksPage.checkLastStatusColumn(columnStatus);

  }

  public void checkMessageSaveEmptyProject() {
    tasksPage.checkMessageEmptyProjectDisplay();
  }

  public void checkMoveStatusAfterIconIsNotDisplayed() {
    tasksPage.checkMoveStatusAfterIconIsNotDisplayed();
  }

  public void checkMoveStatusBeforeIconIsNotDisplayed() {
    tasksPage.checkMoveStatusBeforeIconIsNotDisplayed();
  }

  public void checkProjectIsDisplayed(String projectName) {
    tasksPage.checkProject(projectName);
  }

  public void checkProjectNameIsDisplayedInProjectCard(String projectName, String description) {
    tasksPage.checkProjectNameIsDisplayedInProjectCard(projectName, description);
  }

  public void checkProjectNotDisplayed(String projectName) {
    tasksPage.checkProjectNotDisplayed(projectName);
  }

  public void checkSecondStatusColumn(String columnStatus) {
    tasksPage.checkSecondStatusColumn(columnStatus);
  }

  public void checkTaskPriority(String taskPriority) {
    tasksPage.checkTaskPriority(taskPriority);
  }

  public void checkTaskStatus(String taskStatus) {
    tasksPage.checkTaskStatus(taskStatus);
  }

  public void checkThatSecondLevelDrawerChangesIsOpened() {
    tasksPage.checkThatSecondLevelDrawerChangesIsOpened();
  }

  public void checkThatTasksAreGroupedByAssignee() {
    tasksPage.checkThatTasksAreGroupedByAssignee();
  }

  public void checkTheTimestampUpdate() {
    tasksPage.checkTheTimestampUpdate();
  }

  public void checkThirdStatusColumn(String columnStatus) {
    tasksPage.checkThirdStatusColumn(columnStatus);
  }

  public void checkTooltipIsDisplayed() {
    tasksPage.checkTooltipIsDisplayed();
  }

  public void checkTypedProjectIsRemoved(String typedProject) {
    tasksPage.checkTypedProjectIsRemoved(typedProject);
  }

  public void checkTypedTaskIsRemoved(String typedTask) {
    tasksPage.checkTypedTaskIsRemoved(typedTask);
  }

  public void checkUpdatedDescription(String description) {
    tasksPage.checkUpdatedDescription(description);
  }

  public void checkViewLinkAttachments() {
    tasksPage.checkViewLinkAttachments();
  }

  public void clearButtonInFilterByTaskIsNotVisible() {
    tasksPage.clearButtonInFilterByTaskIsNotVisible();
  }

  public void clearButtonInFilterByTaskIsVisible() {
    tasksPage.clearButtonInFilterByTaskIsVisible();
  }

  public void clearButtonIsNotVisible() {
    tasksPage.clearButtonIsNotVisible();
  }

  public void clearButtonIsVisible() {
    tasksPage.clearButtonIsVisible();
  }

  public void clickAddNewComment() {
    tasksPage.clickToAddNewCommentInTask();
  }

  public void clickAddProjectButton() {
    tasksPage.clickAddProjectButton();
  }
  public void clickAddTaskButton() {
    tasksPage.clickAddTaskButton();
  }

  public void clickCancel() {
    tasksPage.clickCancel();
  }

  public void clickChangeLocation() {
    tasksPage.clickChangeLocation();
  }

  public void clickDelete() {
    tasksPage.clickDelete();
  }

  public void clickDeleteProjectButton() {
    tasksPage.clickDeleteProjectButton();
  }

  public void clickDocButton() {
    tasksPage.clickDocButton();
  }

  public void clickFilterButton() {
    tasksPage.clickFilterButton();
  }

  public void clickOnAddStatusAfterOptionOfTheFifthStatusColumn() {
    tasksPage.clickOnAddStatusAfterOptionOfTheFifthStatusColumn();
  }

  public void clickOnAddStatusBeforeOption() {
    tasksPage.clickOnAddStatusBeforeOption();
  }

  public void clickOnAssigneeRadioButton() {
    tasksPage.clickOnAssigneeRadioButton();
  }

  public void clickOnClearButton() {
    tasksPage.clickOnClearButton();
  }

  public void clickOnClearButtonInFilterByTask() {
    tasksPage.clickOnClearButtonInFilterByTask();
  }

  public void clickOnCommentReply(String comment) {
    tasksPage.clickOnCommentReply(comment);
  }

  public void clickOnConfirmButton() {
    tasksPage.clickOnConfirmButton();
  }

  public void clickOnDeleteStatusIcon() {
    tasksPage.clickOnDeleteStatusIcon();
  }

  public void clickOnDeleteTaskOption() {
    tasksPage.clickOnDeleteTaskOption();
  }

  public void clickOnEditProjectButton() {
    tasksPage.clickOnEditProjectButton();

  }

  public void clickOnFifthColumnThreeDotsIcon() {
    tasksPage.clickOnFifthColumnThreeDotsIcon();
  }

  public void clickOnLastColumnThreeDotsIcon() {
    tasksPage.clickOnLastColumnThreeDotsIcon();
  }

  public void clickOnMoveStatusAfterIcon() {
    tasksPage.clickOnMoveStatusAfterIcon();
  }

  public void clickOnMoveStatusBeforeIcon() {
    tasksPage.clickOnMoveStatusBeforeIcon();
  }

  public void clickOnPlusButtonToAddTask() {
    tasksPage.clickOnPlusButtonToAddTask();
  }

  public void clickOnPlusButtonToAddTaskOfTheSixthStatusColumn() {
    tasksPage.clickOnPlusButtonToAddTaskOfTheSixthStatusColumn();
  }

  public void clickOnProjectThreeDotsButton() {
    tasksPage.clickOnProjectThreeDotsButton();
  }

  public void clickOnSaveButtonToAddTask() {
    tasksPage.clickOnSaveButtonToAddTask();
  }

  public void clickOnApplyButtonToSaveDescription() {
    tasksPage.clickOnApplyButtonToSaveDescription();
  }

  public void attachImageToTaskDescription() {
    tasksPage.attachImageToTaskDescription();
  }

  public void attachSecondImageToTaskDescription() {
    tasksPage.attachImageToTaskDescription();
  }

  public void clickOutsideTaskDescription() {
    tasksPage.clickOutsideTaskDescription();
  }

  public void checkTaskDescriptionNewAttachImage() {
    tasksPage.checkTaskDescriptionNewAttachImage();
  }

  public void checkAttachedImagesToTaskDescription() {
    tasksPage.checkAttachedImagesToTaskDescription();
  }

  public void checkAttachedImagesToTaskComment() {
    tasksPage.checkAttachedImagesToTaskComment();
  }

  public void openTaskDescriptionEditor() {
    tasksPage.openTaskDescriptionEditor();
  }

  public void clickOnSaveButtonToAddTaskSpaceProject() {
    tasksPage.clickOnSaveButtonToAddTaskSpaceProject();
  }

  public void clickOnTaskThreeDotsOption() {
    tasksPage.clickOnTaskThreeDotsOption();
  }

  public void clickOnTheNotificationThatMentionThirdUserInATaskInProject(String message, String projectName) {
    tasksPage.clickOnTheNotificationThatMentioneThirdUserInATaskInProject(message, projectName);
  }

  public void clickOnTheTimestamp() {
    tasksPage.clickOnTheTimestamp();
  }

  public void clickOnThreeDotsIcon() {
    tasksPage.clickOnThreeDotsIcon();
  }

  public void clickOnUpDateButton() {
    tasksPage.clickOnUpDateButton();
  }

  public void clickOnValidateStatusName() {
    tasksPage.clickOnValidateStatusName();
  }

  public void clickPlusIcon() {
    tasksPage.clickPlusIcon();
  }

  public void clickPlusIconProject() {
    tasksPage.clickPlusIconProject();
  }

  public void clickSaveProjectButton() {
    tasksPage.clickSaveProjectButton();
  }

  public void clickStatusName(String statusColumn) {
    tasksPage.clickStatusName(statusColumn);
  }

  public void clickViewAttachmentLink() {
    tasksPage.clickViewAttachmentLink();
  }

  public void cloneProject(String projectName) {
    tasksPage.cloneProject(projectName);
  }

  public void cloneProjectButtonIsDisplayed() {
    tasksPage.cloneProjectButtonIsDisplayed();
  }

  public void clonetaskinspaceproject() {
    tasksPage.clonetaskinspaceproject();
  }

  public void colorPaletteIsDisplayed() {
    tasksPage.colorPaletteIsDisplayed();
  }

  public void commentButtonIsDisabled() {
    tasksPage.commentButtonIsDisabled();
  }

  public void commentsDrawerIsDisplayed() {
    tasksPage.commentsDrawerIsDisplayed();
  }

  public void commentTaskWithUser(String user, String comment) {
    tasksPage.commentTaskWithUser(user, comment);
  }

  public void completeTask() {
    tasksPage.completeTask();
  }

  public void confirmDeleteStatusColumn() {
    tasksPage.confirmDeleteStatusColumn();
  }

  public void confirmDeleteTask() {
    tasksPage.confirmDeleteTaskFromTasksBord();
  }

  public void confirmFilter() {
    tasksPage.confirmFilter();
  }

  public void confirmFilterButtonIsDisplayed() {
    tasksPage.confirmFilterButtonIsDisplayed();
  }

  public void deleteProject(String projectName) {
    tasksPage.deleteProject(projectName);
  }

  public void deleteProjectButtonIsDisplayed() {
    tasksPage.deleteProjectButtonIsDisplayed();
  }

  public void deleteTaskOptionIsDisplayed() {
    tasksPage.deleteTaskOptionIsDisplayed();
  }

  public void editDescriptionForTask(String newDescription) {
    tasksPage.editDescriptionForTask(newDescription);
  }

  public void editProjectButtonIsDisplayed() {
    tasksPage.editProjectButtonIsDisplayed();
  }

  public void editProjectName(String projectName) {
    tasksPage.editProjectName(projectName);
  }

  public void editProjectNameWithDescription(String projectName, String newProjectName, String newDescription) {
    tasksPage.editProjectNameWithDescription(projectName, newProjectName, newDescription);
  }

  public void editSpaceName(String spaceName) {
    tasksPage.editSpaceName(spaceName);
  }

  public void editTaskDrawerIsDisplayed() {
    tasksPage.editTaskDrawerIsDisplayed();
  }

  public void enterDescriptionForTask(String description) {
    tasksPage.enterDescriptionForTask(description);
  }

  public void enterProjectDescriptionWithoutTheTitle(String description) {
    tasksPage.enterProjectDescriptionWithoutTheTitle(description);
  }

  public void enterProjectTitleAndDescription(String projectName, String description) {
    tasksPage.enterProjectTitleAndDescription(projectName, description);
  }

  public void enterStatusText(String status) {
    tasksPage.enterStatusText(status);
  }

  public void enterTaskComment(String comment) {
    tasksPage.enterTaskComment(comment);
  }

  public void enterTitleForTask(String title) {
    tasksPage.enterTitleForTask(title);
  }

  public void exitFromTheFirstProject() {
    tasksPage.exitFromTheFirstProject();
  }

  public void goBack() {
    tasksPage.goBack();
  }

  public void goToFilterTab() {
    tasksPage.goToFilterTab();
  }

  public void goToGroupAndSortTab() {
    tasksPage.goToGroupAndSortTab();
  }

  public void goToLabelsTab() {
    tasksPage.goToLabelsTab();
  }

  public void goToPLanView() {
    tasksPage.goToPLanView();
  }

  public void goToProjectDetailsList() {
    tasksPage.goToProjectDetailsList();
  }

  public void goToProjectsTab() {
    tasksPage.goToProjectsTab();
  }

  public void goToTasksTab() {
    tasksPage.goToTasksTab();
  }

  public void greenInformationIconIsDisplayed() {
    tasksPage.greenInformationIconIsDisplayed();
  }

  public void hoverOnProjectManagerIcon() {
    tasksPage.hoverOnProjectManagerIcon();
  }

  public void hoverOnTaskName(String task) {
    tasksPage.hoverOnTaskName(task);
  }

  public void hoverOnTheChangesTimestamp() {
    tasksPage.hoverOnTheChangesTimestamp();
  }

  public void isFilterDrawerTabDisplayed(String tab) {
    tasksPage.isFilterDrawerTabDisplayed(tab);
  }

  public void isLabelDisplayedInProjectDetails(String label, String times) {
    tasksPage.isLabelDisplayedInProjectDetails(label, times);
  }

  public void isSearchedTaskDisplayed(String taskName) {
    tasksPage.isSearchedTaskDisplayed(taskName);
  }

  public boolean isStatusEditModeDisplayed(String statusColumn) {
    return tasksPage.isStatusEditModeDisplayed(statusColumn);
  }

  public void labelIsDisplayedInProjectDrawer(String label) {
    tasksPage.labelIsDisplayedInProjectDrawer(label);
  }

  public void labelIsDisplayedInTaskDrawer(String label) {
    tasksPage.labelIsDisplayedInTaskDrawer(label);
  }

  public void labelIsNotDisplayedInProjectDrawer(String label) {
    tasksPage.labelIsNotDisplayedInProjectDrawer(label);
  }

  public void markTaskAsCompletedFromTaskCard() {
    tasksPage.markTaskAsCompletedFromTaskCard();
  }

  public void markTaskAsCompletedInProjectDetails(String taskName) {
    tasksPage.markTaskAsCompletedInProjectDetails(taskName);
  }

  public void maxCharsCount1250InformationIsDisplayed() {
    tasksPage.maxCharsCount1250InformationIsDisplayed();
  }

  public void maxCharsNumberMessageIsDisplayed() {
    tasksPage.maxCharsNumberMessageIsDisplayed();
  }

  public void more1250CharsInformationIsDisplayed() {
    tasksPage.more1250CharsInformationIsDisplayed();
  }

  public void openFilterDrawer() {
    tasksPage.openFilterDrawer();
  }

  public void openProject(String project) {
    tasksPage.openProject(project);
  }

  public void openTaskCard(String task) {
    tasksPage.openTaskCard(task);
  }

  public void openTaskCreated(String taskName) {
    tasksPage.openTaskDrawer(taskName);
  }

  public void openTaskInTasksTab(String taskName) {
    tasksPage.openTaskInTasksTab(taskName);
  }

  public void projectDrawerNotClosing() {
    tasksPage.projectDrawerNotClosing();
  }

  public void projectIsDisplayedInTasksAppCenter(String projectName) {
    tasksPage.projectIsDisplayedInTasksAppCenter(projectName);
  }

  public void projectNameIsDisplayedInProjectDetails(String projectName) {
    tasksPage.projectNameIsDisplayedInProjectDetails(projectName);
  }

  public void redInformationIconIsDisplayed() {
    tasksPage.redInformationIconIsDisplayed();
  }

  public void removeLabelToProject(String label) {
    tasksPage.removeLabelToProject(label);
  }

  public void replyTaskCommentButtonIsDisabled() {
    tasksPage.replyTaskCommentButtonIsDisabled();
  }

  public void resetFilterButtonIsDisplayed() {
    tasksPage.resetFilterButtonIsDisplayed();
  }

  public void returnToProjectsTab() {
    tasksPage.returnToProjectsTab();
  }

  public void saveAddingProject() {
    tasksPage.saveAddingProject();
  }

  public void searchTask(String taskName) {
    tasksPage.searchTask(taskName);
  }

  public void selectFilterOption(String label) {
    tasksPage.selectFilterOption(label);
  }

  public void setInSearchProjectField(String project) {
    tasksPage.setInSearchProjectField(project);
  }

  public void setProjectTitle(String projectTitle) {
    tasksPage.setProjectTitle(projectTitle);
  }

  public void setTaskCompletedInDrawer() {
    tasksPage.setTaskCompletedInDrawer();
  }

  public void setTaskCompletedInDrawerWithoutClosingIt() {
    tasksPage.setTaskCompletedInDrawerWithoutClosingIt();
  }

  public void setTaskDescription(String description) {
    tasksPage.setTaskDescription(description);
  }

  public void setTaskDueDateNextWeek() {
    tasksPage.setTaskDueDateNextWeek();
  }

  public void setTaskDueDateToday() {
    tasksPage.setTaskDueDateToday();
  }

  public void setTaskDueDateTomorrow() {
    tasksPage.setTaskDueDateTomorrow();
  }

  public void setTaskPriority(String taskPriority) {
    tasksPage.setTaskPriority(taskPriority);
  }

  public void setTasksStatus(String taskStatus) {
    tasksPage.setTaskStatus(taskStatus);
  }

  public void setTaskStartDateToday() {
    tasksPage.setTaskStartDateToday();
  }

  public void setTaskStartDateTomorrow() {
    tasksPage.setTaskStartDateTomorrow();
  }

  public void switchToTASKSTab() {
    tasksPage.switchToTASKSTab();
  }

  public void taskIsDisplayedInProjectDetails(String taskName) {
    tasksPage.taskNameIsDisplayedInProjectDetails(taskName);
  }

  public void taskIsMarkedAndDisplayedInCompletedSection(String taskName) {
    tasksPage.taskIsMarkedAndDisplayedInCompletedSection(taskName);
  }

  public void taskIsNotDisplayedInProjectDetails(String taskName) {
    tasksPage.taskNameIsNotDisplayedInProjectDetails(taskName);
  }

  public void taskIsNotMarkedAndDisplayedInUncompletedSection(String taskName) {
    tasksPage.taskIsNotMarkedAndDisplayedInUncompletedSection(taskName);
  }

  public void taskMarkedAsCompletedIsDisplayedInDrawer() {
    tasksPage.taskMarkedAsCompletedIsDisplayedInDrawer();
  }

  public void taskNameAndLabelIsDisplayedInProjectDetails(String label, String taskName) {
    tasksPage.taskNameAndLabelIsDisplayedInProjectDetails(label, taskName);
  }

  public void taskNameIsDisplayedInDesiredColumn(String status, String taskName) {
    tasksPage.taskNameIsDisplayedInDesiredColumn(status, taskName);
  }

  public void taskNamePLanView(String taskName) {
    tasksPage.taskNamePLanView(taskName);
  }

  public void taskOrderInProjectDetails(String task, String number) {
    tasksPage.taskOrderInProjectDetails(task, number);
  }

  public void tasksNumberToDo(String tasksNumber) {
    tasksPage.tasksNumberToDo(tasksNumber);
  }

  public void taskTooltipIsDisplayed(String task) {
    tasksPage.taskTooltipIsDisplayed(task);
  }

  public void updateTaskDescription(String description) {
    tasksPage.updateTaskDescription(description);
  }

  public void userAvatarIsDisplayedInProjectCard(String userName) {
    tasksPage.userAvatarIsDisplayedInProjectCard(userName);
  }

  public void countUserAvatarsInProjectCard(int count) {
    tasksPage.countUserAvatarsInProjectCard(count);
  }

  public void userAvatarIsNotDisplayedInProjectCard(String userName) {
    tasksPage.userAvatarIsNotDisplayedInProjectCard(userName);
  }

  public void userFullNameIsDisplayedInProjectCard(String name) {
    tasksPage.userFullNameIsDisplayedInProjectCard(name);
  }

  public void userFullNameIsNotDisplayedInProjectCard(String name) {
    tasksPage.userFullNameIsNotDisplayedInProjectCard(name);
  }

  public void verifyViewLinkAttachments() {
    tasksPage.verifyViewLinkAttachments();
  }

  public void viewAllCommentsTaskButton() {
    tasksPage.viewAllCommentsTaskButton();
  }

  public void clickFilterTasksButton() {
    tasksPage.clickFilterTasksButton();
  }

  public void goToFilterType(String filterType) {
    tasksPage.goToFilterType(filterType);
  }

  public void selectProjectFilterOption(String option) {
    tasksPage.selectProjectFilterOption(option);
  }

}
