/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.qa.ui.elements;

import io.meeds.qa.ui.elements.ElementFacadeImpl;
import net.serenitybdd.core.annotations.ImplementedBy;
import net.serenitybdd.core.pages.WebElementFacade;
import net.thucydides.core.webdriver.exceptions.ElementShouldBeInvisibleException;
import net.thucydides.core.webdriver.exceptions.ElementShouldBePresentException;
import net.thucydides.core.webdriver.exceptions.ElementShouldBeVisibleException;
import org.junit.Assert;
import org.openqa.selenium.ElementClickInterceptedException;
import org.openqa.selenium.WebDriver;

@ImplementedBy(value=ElementFacadeImpl.class)
public interface ElementFacade
extends WebElementFacade {
    public void click();

    public <T extends ElementFacade> T findByXPath(String var1);

    public WebDriver getDriver();

    public void hover();

    public void scrollToWebElement();

    default public void assertDisabled() {
        long start = System.currentTimeMillis();
        boolean disabled = this.isDisabled();
        Assert.assertTrue((String)String.format("Element %s wasn't disabled after waiting %s ms", this, System.currentTimeMillis() - start), (boolean)disabled);
    }

    default public void assertEnabled() {
        long start = System.currentTimeMillis();
        boolean enabled = this.isEnabled();
        Assert.assertTrue((String)String.format("Element %s wasn't enabled after waiting %s ms", this, System.currentTimeMillis() - start), (boolean)enabled);
    }

    default public void assertNotVisible() {
        long start = System.currentTimeMillis();
        boolean notVisible = this.isNotVisible();
        Assert.assertTrue((String)String.format("Element %s was visible after waiting %s ms", this, System.currentTimeMillis() - start), (boolean)notVisible);
    }

    default public void assertVisible() {
        long start = System.currentTimeMillis();
        boolean visible = this.isVisible();
        if (!visible && this.isPresent()) {
            this.scrollToWebElement();
            visible = this.isVisible();
        }
        Assert.assertTrue((String)String.format("Element %s wasn't visible after waiting %s ms. Current URL: %s", this, System.currentTimeMillis() - start, this.getDriver().getCurrentUrl()), (boolean)visible);
    }

    default public void checkClickable() {
        long start = System.currentTimeMillis();
        if (!this.isClickable()) {
            throw new ElementClickInterceptedException(String.format("Unable to locate a clickable element %s after %s ms. Current URL: %s", this, System.currentTimeMillis() - start, this.getDriver().getCurrentUrl()));
        }
    }

    default public void checkNotVisible() {
        long start = System.currentTimeMillis();
        if (!this.isNotVisible()) {
            throw new ElementShouldBeInvisibleException(String.format("Element is still visible %s after %s ms", this, System.currentTimeMillis() - start), null);
        }
    }

    default public void checkVisible() {
        long start = System.currentTimeMillis();
        if (!this.isVisible()) {
            if (this.isPresent()) {
                this.scrollToWebElement();
            }
            throw new ElementShouldBeVisibleException(String.format("Unable to locate a visible element %s after %s ms. Current URL: %s", this, System.currentTimeMillis() - start, this.getDriver().getCurrentUrl()), null);
        }
    }

    default public void checkCurrentlyVisible() {
        long start = System.currentTimeMillis();
        if (!this.isCurrentlyVisible()) {
            throw new ElementShouldBeVisibleException(String.format("Unable to locate a visible element %s after %s ms", this, System.currentTimeMillis() - start), null);
        }
    }

    default public void checkPresent() {
        long start = System.currentTimeMillis();
        if (!this.isPresent()) {
            throw new ElementShouldBePresentException(String.format("Unable to locate a present element %s after %s ms", this, System.currentTimeMillis() - start), null);
        }
    }

    default public void checkEnabled() {
        long start = System.currentTimeMillis();
        if (!this.isEnabled()) {
            throw new ElementShouldBeVisibleException(String.format("Unable to locate an enabled element %s after %s ms", this, System.currentTimeMillis() - start), null);
        }
    }

    public boolean isCurrentlyVisible();

    public boolean isNotVisible();

    public void scrollDown();

    public void scrollToTheRight();
}

